/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.google.auth.oauth2;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.talend.bigdata.google.api.client.util.Preconditions;
import org.talend.bigdata.google.auth.oauth2.AccessToken;
import org.talend.bigdata.google.auth.oauth2.IdToken;
import org.talend.bigdata.google.auth.oauth2.IdTokenProvider;
import org.talend.bigdata.google.auth.oauth2.OAuth2Credentials;
import org.talend.bigdata.google.auth.oauth2.UserCredentials;
import org.talend.bigdata.google.common.base.MoreObjects;

public class IdTokenCredentials
extends OAuth2Credentials {
    private static final long serialVersionUID = -2133257318957588431L;
    private IdTokenProvider idTokenProvider;
    private String targetAudience;
    private List<IdTokenProvider.Option> options;

    private IdTokenCredentials(Builder builder) {
        this.idTokenProvider = Preconditions.checkNotNull(builder.getIdTokenProvider());
        if (!(this.idTokenProvider instanceof UserCredentials)) {
            this.targetAudience = Preconditions.checkNotNull(builder.getTargetAudience());
        }
        this.options = builder.getOptions();
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        return this.idTokenProvider.idTokenWithAudience(this.targetAudience, this.options);
    }

    public IdToken getIdToken() {
        return (IdToken)this.getAccessToken();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.options, this.targetAudience);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IdTokenCredentials)) {
            return false;
        }
        IdTokenCredentials other = (IdTokenCredentials)obj;
        return Objects.equals(this.idTokenProvider, other.idTokenProvider) && Objects.equals(this.targetAudience, other.targetAudience);
    }

    @Override
    public Builder toBuilder() {
        return new Builder().setIdTokenProvider(this.idTokenProvider).setTargetAudience(this.targetAudience).setOptions(this.options);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends OAuth2Credentials.Builder {
        private IdTokenProvider idTokenProvider;
        private String targetAudience;
        private List<IdTokenProvider.Option> options;

        protected Builder() {
        }

        public Builder setIdTokenProvider(IdTokenProvider idTokenProvider) {
            this.idTokenProvider = idTokenProvider;
            return this;
        }

        public IdTokenProvider getIdTokenProvider() {
            return this.idTokenProvider;
        }

        public Builder setTargetAudience(String targetAudience) {
            this.targetAudience = targetAudience;
            return this;
        }

        public String getTargetAudience() {
            return this.targetAudience;
        }

        public Builder setOptions(List<IdTokenProvider.Option> options) {
            this.options = options;
            return this;
        }

        public List<IdTokenProvider.Option> getOptions() {
            return this.options;
        }

        @Override
        public IdTokenCredentials build() {
            return new IdTokenCredentials(this);
        }
    }
}

