/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.google.auth.oauth2;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.talend.bigdata.google.auth.oauth2.ExternalAccountCredentials;
import org.talend.bigdata.javax.annotation.Nullable;

public class IdentityPoolCredentialSource
extends ExternalAccountCredentials.CredentialSource {
    private static final long serialVersionUID = -745855247050085694L;
    IdentityPoolCredentialSourceType credentialSourceType;
    CredentialFormatType credentialFormatType;
    String credentialLocation;
    @Nullable
    String subjectTokenFieldName;
    @Nullable
    Map<String, String> headers;

    public IdentityPoolCredentialSource(Map<String, Object> credentialSourceMap) {
        super(credentialSourceMap);
        if (credentialSourceMap.containsKey("file") && credentialSourceMap.containsKey("url")) {
            throw new IllegalArgumentException("Only one credential source type can be set, either file or url.");
        }
        if (credentialSourceMap.containsKey("file")) {
            this.credentialLocation = (String)credentialSourceMap.get("file");
            this.credentialSourceType = IdentityPoolCredentialSourceType.FILE;
        } else if (credentialSourceMap.containsKey("url")) {
            this.credentialLocation = (String)credentialSourceMap.get("url");
            this.credentialSourceType = IdentityPoolCredentialSourceType.URL;
        } else {
            throw new IllegalArgumentException("Missing credential source file location or URL. At least one must be specified.");
        }
        Map headersMap = (Map)credentialSourceMap.get("headers");
        if (headersMap != null && !headersMap.isEmpty()) {
            this.headers = new HashMap<String, String>();
            this.headers.putAll(headersMap);
        }
        this.credentialFormatType = CredentialFormatType.TEXT;
        Map formatMap = (Map)credentialSourceMap.get("format");
        if (formatMap != null && formatMap.containsKey("type")) {
            String type = (String)formatMap.get("type");
            if (type != null && "json".equals(type.toLowerCase(Locale.US))) {
                if (!formatMap.containsKey("subject_token_field_name")) {
                    throw new IllegalArgumentException("When specifying a JSON credential type, the subject_token_field_name must be set.");
                }
                this.credentialFormatType = CredentialFormatType.JSON;
                this.subjectTokenFieldName = (String)formatMap.get("subject_token_field_name");
            } else if (type != null && "text".equals(type.toLowerCase(Locale.US))) {
                this.credentialFormatType = CredentialFormatType.TEXT;
            } else {
                throw new IllegalArgumentException(String.format("Invalid credential source format type: %s.", type));
            }
        }
    }

    boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    static enum CredentialFormatType {
        TEXT,
        JSON;

    }

    static enum IdentityPoolCredentialSourceType {
        FILE,
        URL;

    }
}

