/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.google.common.collect;

import java.util.Queue;
import org.talend.bigdata.google.common.annotations.GwtCompatible;
import org.talend.bigdata.google.common.base.Preconditions;
import org.talend.bigdata.google.common.collect.AbstractIterator;
import org.talend.bigdata.google.common.collect.ElementTypesAreNonnullByDefault;
import org.talend.bigdata.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class ConsumingQueueIterator<T>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    @CheckForNull
    protected T computeNext() {
        if (this.queue.isEmpty()) {
            return this.endOfData();
        }
        return this.queue.remove();
    }
}

