/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.google.gson.internal.sql;

import java.io.IOException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.talend.bigdata.google.gson.Gson;
import org.talend.bigdata.google.gson.JsonSyntaxException;
import org.talend.bigdata.google.gson.TypeAdapter;
import org.talend.bigdata.google.gson.TypeAdapterFactory;
import org.talend.bigdata.google.gson.reflect.TypeToken;
import org.talend.bigdata.google.gson.stream.JsonReader;
import org.talend.bigdata.google.gson.stream.JsonToken;
import org.talend.bigdata.google.gson.stream.JsonWriter;

final class SqlTimeTypeAdapter
extends TypeAdapter<Time> {
    static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Time.class ? new SqlTimeTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("hh:mm:ss a");

    private SqlTimeTypeAdapter() {
    }

    @Override
    public synchronized Time read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            Date date = this.format.parse(in.nextString());
            return new Time(date.getTime());
        }
        catch (ParseException e) {
            throw new JsonSyntaxException(e);
        }
    }

    @Override
    public synchronized void write(JsonWriter out, Time value) throws IOException {
        out.value(value == null ? null : this.format.format(value));
    }
}

