/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.jackson.databind.ext;

import java.io.IOException;
import java.util.Calendar;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.talend.bigdata.jackson.core.JsonGenerator;
import org.talend.bigdata.jackson.core.JsonToken;
import org.talend.bigdata.jackson.core.type.WritableTypeId;
import org.talend.bigdata.jackson.databind.BeanDescription;
import org.talend.bigdata.jackson.databind.BeanProperty;
import org.talend.bigdata.jackson.databind.JavaType;
import org.talend.bigdata.jackson.databind.JsonMappingException;
import org.talend.bigdata.jackson.databind.JsonSerializer;
import org.talend.bigdata.jackson.databind.SerializationConfig;
import org.talend.bigdata.jackson.databind.SerializerProvider;
import org.talend.bigdata.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.talend.bigdata.jackson.databind.jsontype.TypeSerializer;
import org.talend.bigdata.jackson.databind.ser.ContextualSerializer;
import org.talend.bigdata.jackson.databind.ser.Serializers;
import org.talend.bigdata.jackson.databind.ser.std.CalendarSerializer;
import org.talend.bigdata.jackson.databind.ser.std.StdSerializer;
import org.talend.bigdata.jackson.databind.ser.std.ToStringSerializer;

public class CoreXMLSerializers
extends Serializers.Base {
    @Override
    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        Class<?> raw = type.getRawClass();
        if (Duration.class.isAssignableFrom(raw) || QName.class.isAssignableFrom(raw)) {
            return ToStringSerializer.instance;
        }
        if (XMLGregorianCalendar.class.isAssignableFrom(raw)) {
            return XMLGregorianCalendarSerializer.instance;
        }
        return null;
    }

    public static class XMLGregorianCalendarSerializer
    extends StdSerializer<XMLGregorianCalendar>
    implements ContextualSerializer {
        static final XMLGregorianCalendarSerializer instance = new XMLGregorianCalendarSerializer();
        final JsonSerializer<Object> _delegate;

        public XMLGregorianCalendarSerializer() {
            this(CalendarSerializer.instance);
        }

        protected XMLGregorianCalendarSerializer(JsonSerializer<?> del) {
            super(XMLGregorianCalendar.class);
            this._delegate = del;
        }

        @Override
        public JsonSerializer<?> getDelegatee() {
            return this._delegate;
        }

        @Override
        public boolean isEmpty(SerializerProvider provider, XMLGregorianCalendar value) {
            return this._delegate.isEmpty(provider, this._convert(value));
        }

        @Override
        public void serialize(XMLGregorianCalendar value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            this._delegate.serialize(this._convert(value), gen, provider);
        }

        @Override
        public void serializeWithType(XMLGregorianCalendar value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId((Object)value, XMLGregorianCalendar.class, JsonToken.VALUE_STRING));
            this.serialize(value, g2, provider);
            typeSer.writeTypeSuffix(g2, typeIdDef);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            this._delegate.acceptJsonFormatVisitor(visitor, null);
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
            JsonSerializer<?> ser = prov.handlePrimaryContextualization(this._delegate, property);
            if (ser != this._delegate) {
                return new XMLGregorianCalendarSerializer(ser);
            }
            return this;
        }

        protected Calendar _convert(XMLGregorianCalendar input) {
            return input == null ? null : input.toGregorianCalendar();
        }
    }
}

