/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.jackson.datatype.guava.deser;

import java.io.IOException;
import java.util.List;
import org.talend.bigdata.google.common.collect.ImmutableRangeSet;
import org.talend.bigdata.google.common.collect.Range;
import org.talend.bigdata.google.common.collect.RangeSet;
import org.talend.bigdata.jackson.core.JsonParseException;
import org.talend.bigdata.jackson.core.JsonParser;
import org.talend.bigdata.jackson.databind.BeanProperty;
import org.talend.bigdata.jackson.databind.DeserializationContext;
import org.talend.bigdata.jackson.databind.JavaType;
import org.talend.bigdata.jackson.databind.JsonDeserializer;
import org.talend.bigdata.jackson.databind.deser.ContextualDeserializer;
import org.talend.bigdata.jackson.databind.type.LogicalType;

public class RangeSetDeserializer
extends JsonDeserializer<RangeSet<Comparable<?>>>
implements ContextualDeserializer {
    private JavaType genericRangeListType;

    @Override
    public LogicalType logicalType() {
        return LogicalType.Collection;
    }

    @Override
    public RangeSet<Comparable<?>> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this.genericRangeListType == null) {
            throw new JsonParseException(p, "RangeSetJsonSerializer was not contextualized (no deserialize target type). You need to specify the generic type down to the generic parameter of RangeSet.");
        }
        Iterable ranges = (Iterable)ctxt.findContextualValueDeserializer(this.genericRangeListType, null).deserialize(p, ctxt);
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        for (Range range : ranges) {
            builder.add(range);
        }
        return builder.build();
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        JavaType genericType = ctxt.getContextualType().containedType(0);
        if (genericType == null) {
            return this;
        }
        RangeSetDeserializer deserializer = new RangeSetDeserializer();
        deserializer.genericRangeListType = ctxt.getTypeFactory().constructCollectionType(List.class, ctxt.getTypeFactory().constructParametricType(Range.class, genericType));
        return deserializer;
    }
}

