/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.jackson.datatype.guava.ser;

import java.io.IOException;
import java.util.List;
import org.talend.bigdata.google.common.collect.Range;
import org.talend.bigdata.google.common.collect.RangeSet;
import org.talend.bigdata.jackson.core.JsonGenerator;
import org.talend.bigdata.jackson.databind.BeanProperty;
import org.talend.bigdata.jackson.databind.JavaType;
import org.talend.bigdata.jackson.databind.JsonSerializer;
import org.talend.bigdata.jackson.databind.SerializerProvider;
import org.talend.bigdata.jackson.databind.ser.ContextualSerializer;

public class RangeSetSerializer
extends JsonSerializer<RangeSet<Comparable<?>>>
implements ContextualSerializer {
    private JavaType genericRangeListType;

    @Override
    public void serialize(RangeSet<Comparable<?>> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (this.genericRangeListType == null) {
            serializers.findValueSerializer(List.class).serialize(value.asRanges(), gen, serializers);
        } else {
            serializers.findValueSerializer(this.genericRangeListType).serialize(value.asRanges(), gen, serializers);
        }
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) {
        if (property == null) {
            return this;
        }
        RangeSetSerializer serializer = new RangeSetSerializer();
        serializer.genericRangeListType = prov.getTypeFactory().constructCollectionType(List.class, prov.getTypeFactory().constructParametricType(Range.class, property.getType().containedType(0)));
        return serializer;
    }
}

