/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.databricks;

import java.util.List;
import java.util.Map;
import org.talend.bigdata.launcher.databricks.DatabricksCluster;
import org.talend.bigdata.launcher.databricks.DatabricksJob;

public class SparkBatchJob
extends DatabricksJob {
    private static final String FILESTORE_PREFIX = "/FileStore";
    private static final String VOLUMES_PREFIX = "/Volumes/";
    private static final String WORKSPACE_PREFIX = "/Workspace/";

    private SparkBatchJob(Builder builder) {
        super(builder.endpoint, builder.token);
        this.setValues(builder);
    }

    private SparkBatchJob(Builder builder, String clientId, String secretId) {
        super(builder.endpoint, clientId, secretId);
        this.setValues(builder);
    }

    private void setValues(Builder builder) {
        this.mAppName = builder.appName;
        this.mjobJarName = builder.jobJarName;
        this.mJarToExecute = builder.jarToExecute;
        this.mClassToExecute = builder.classToExecute;
        this.mConf = builder.conf;
        this.mTuningConf = builder.tuningConf;
        this.mClusterId = builder.clusterId;
        this.mLibJars = builder.libJars;
        this.mFilePath = builder.filePath;
        this.mArgs = builder.args;
        this.userAgent = builder.userAgent;
        this.transientCluster = builder.transientCluster;
        this.msBeforeRequest = builder.msBeforeRequest;
        this.isRunSubmit = builder.isRunSubmit;
        this.mUserName = builder.userName;
        this.mGroupName = builder.groupName;
        this.mSPName = builder.spName;
        this.mPermissionLevel = builder.permissionLevel;
        this.mOwnerName = builder.ownerName;
        this.mJarToExecute = builder.jarToExecute;
        this.mClassToExecute = builder.classToExecute;
        this.mAppName = builder.appName;
        this.mjobJarName = builder.jobJarName;
        this.mConf = builder.conf;
        this.mTuningConf = builder.tuningConf;
        this.mClusterId = builder.clusterId;
        this.mLibJars = builder.libJars;
        this.mFilePath = builder.filePath;
        this.mArgs = builder.args;
        this.isUC = builder.isUC;
        this.isWS = builder.isWS;
        this.isACLEnabled = builder.isACLEnabled;
        this.production = builder.production;
        this.mUserName = builder.userName;
        this.mGroupName = builder.groupName;
        this.mSPName = builder.spName;
        this.mPermissionLevel = builder.permissionLevel;
        this.mOwnerName = builder.ownerName;
    }

    public String getJarToExecute() {
        return this.mJarToExecute;
    }

    public String getFilePath() {
        return this.mFilePath;
    }

    public List<String> getArgs() {
        return this.mArgs;
    }

    public boolean isUC() {
        return this.isUC;
    }

    public boolean isWS() {
        return this.isWS;
    }

    public boolean isProduction() {
        return this.production;
    }

    public static class Builder {
        private String jarToExecute;
        private String classToExecute;
        private String appName;
        private String jobJarName;
        private String endpoint;
        private String token;
        private String clientId;
        private String secretId;
        private String clusterId;
        private Map<String, String> conf;
        private Map<String, String> tuningConf;
        private String libJars;
        private String filePath;
        private List<String> args;
        private String userAgent;
        private DatabricksCluster transientCluster;
        private boolean production;
        private long msBeforeRequest;
        private boolean isRunSubmit;
        private boolean isUC = false;
        private boolean isWS = false;
        private boolean isACLEnabled;
        private String userName;
        private String groupName;
        private String spName;
        private String permissionLevel;
        private String ownerName;

        public Builder withAppName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder withJobJarName(String jobJarName) {
            this.jobJarName = jobJarName;
            return this;
        }

        public Builder withJarToExecute(String jarToExecute) {
            this.jarToExecute = jarToExecute;
            return this;
        }

        public Builder withClassToExecute(String classToExecute) {
            this.classToExecute = classToExecute;
            return this;
        }

        public Builder withEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder withConf(Map<String, String> conf) {
            this.conf = conf;
            return this;
        }

        public Builder withTuningConf(Map<String, String> conf) {
            this.tuningConf = conf;
            return this;
        }

        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        public Builder withSecretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public Builder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder withClusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder withLibJars(String libJars) {
            this.libJars = libJars;
            return this;
        }

        public Builder withFilePath(String path) {
            this.filePath = SparkBatchJob.FILESTORE_PREFIX + path;
            this.isUC = false;
            this.isWS = false;
            return this;
        }

        public Builder withFilePath(String catalog, String schema, String volume, String path) {
            this.filePath = SparkBatchJob.VOLUMES_PREFIX + catalog.concat("/") + schema.concat("/") + volume + path;
            this.isUC = true;
            this.isWS = false;
            return this;
        }

        public Builder withFilePathWS(String path) {
            this.filePath = SparkBatchJob.WORKSPACE_PREFIX + path;
            this.isUC = false;
            this.isWS = true;
            return this;
        }

        public Builder withArgs(List<String> args) {
            this.args = args;
            return this;
        }

        public Builder withUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder withTransientCluster(DatabricksCluster cluster) {
            this.transientCluster = cluster;
            return this;
        }

        public Builder withProductionMode(boolean production) {
            this.production = production;
            return this;
        }

        public Builder withCustomIntervalBetweenRequests(long msBeforeRequest) {
            this.msBeforeRequest = msBeforeRequest;
            return this;
        }

        public Builder withRunSubmit(boolean isRunSubmit) {
            this.isRunSubmit = isRunSubmit;
            return this;
        }

        public Builder withACL(boolean isACL) {
            this.isACLEnabled = isACL;
            return this;
        }

        public Builder withUser(String user) {
            this.userName = user;
            return this;
        }

        public Builder withGroup(String group) {
            this.groupName = group;
            return this;
        }

        public Builder withSP(String sp) {
            this.spName = sp;
            return this;
        }

        public Builder withPermission(String permission) {
            this.permissionLevel = permission;
            return this;
        }

        public Builder withOwner(String ownerName) {
            this.ownerName = ownerName;
            return this;
        }

        public SparkBatchJob build() {
            if (this.token != null) {
                return new SparkBatchJob(this);
            }
            return new SparkBatchJob(this, this.clientId, this.secretId);
        }
    }
}

