/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.databricks;

import java.util.List;
import java.util.Map;
import org.talend.bigdata.launcher.databricks.DatabricksCluster;
import org.talend.bigdata.launcher.databricks.DatabricksJob;
import org.talend.bigdata.launcher.security.Credentials;

public class SparkBatchJob
extends DatabricksJob {
    private SparkBatchJob(String appName, String jobJarName, String jarToExecute, String classToExecute, String endpoint, Credentials credentials, Map<String, String> conf, Map<String, String> tuningConf, String token, String clusterId, String libjars, String filePath, List<String> args, String userAgent, DatabricksCluster cluster, boolean production, long msBeforeRequest, boolean isRunSubmit) {
        super(endpoint);
        this.mAppName = appName;
        this.mjobJarName = jobJarName;
        this.mJarToExecute = jarToExecute;
        this.mClassToExecute = classToExecute;
        this.mCredentials = credentials;
        this.mConf = conf;
        this.mTuningConf = tuningConf;
        this.token = token;
        this.mClusterId = clusterId;
        this.mLibJars = libjars;
        this.mFilePath = filePath;
        this.mArgs = args;
        this.userAgent = userAgent;
        this.transientCluster = cluster;
        this.production = production;
        this.msBeforeRequest = msBeforeRequest;
        this.isRunSubmit = isRunSubmit;
    }

    public static class Builder {
        private String mJarToExecute;
        private String mClassToExecute;
        private String mAppName;
        private String mjobJarName;
        private String mEndpoint;
        private String mToken;
        private String mClusterId;
        private Credentials mCredentials;
        private Map<String, String> mConf;
        private Map<String, String> mTuningConf;
        private String mLibJars;
        private String mFilePath;
        private List<String> mArgs;
        private String mUserAgent;
        private DatabricksCluster transientCluster;
        private boolean production;
        private long msBeforeRequest;
        private boolean isRunSubmit;

        public Builder withAppName(String appName) {
            this.mAppName = appName;
            return this;
        }

        public Builder withJobJarName(String jobJarName) {
            this.mjobJarName = jobJarName;
            return this;
        }

        public Builder withJarToExecute(String jarToExecute) {
            this.mJarToExecute = jarToExecute;
            return this;
        }

        public Builder withClassToExecute(String classToExecute) {
            this.mClassToExecute = classToExecute;
            return this;
        }

        public Builder withEndpoint(String endpoint) {
            this.mEndpoint = endpoint;
            return this;
        }

        public Builder withCredentials(Credentials credentials) {
            this.mCredentials = credentials;
            return this;
        }

        public Builder withConf(Map<String, String> conf) {
            this.mConf = conf;
            return this;
        }

        public Builder withTuningConf(Map<String, String> conf) {
            this.mTuningConf = conf;
            return this;
        }

        public Builder withToken(String token) {
            this.mToken = token;
            return this;
        }

        public Builder withClusterId(String clusterId) {
            this.mClusterId = clusterId;
            return this;
        }

        public Builder withLibJars(String libjars) {
            this.mLibJars = libjars;
            return this;
        }

        public Builder withFilePath(String path) {
            this.mFilePath = "/FileStore" + path;
            return this;
        }

        public Builder withArgs(List<String> args) {
            this.mArgs = args;
            return this;
        }

        public Builder withUserAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return this;
        }

        public Builder withTransientCluster(DatabricksCluster cluster) {
            this.transientCluster = cluster;
            return this;
        }

        public Builder withProductionMode(boolean production) {
            this.production = production;
            return this;
        }

        public Builder withCustomIntervalBetweenRequests(long msBeforeRequest) {
            this.msBeforeRequest = msBeforeRequest;
            return this;
        }

        public Builder withRunSubmit(boolean isRunSubmit) {
            this.isRunSubmit = isRunSubmit;
            return this;
        }

        public SparkBatchJob build() {
            return new SparkBatchJob(this.mAppName, this.mjobJarName, this.mJarToExecute, this.mClassToExecute, this.mEndpoint, this.mCredentials, this.mConf, this.mTuningConf, this.mToken, this.mClusterId, this.mLibJars, this.mFilePath, this.mArgs, this.mUserAgent, this.transientCluster, this.production, this.msBeforeRequest, this.isRunSubmit);
        }
    }
}

