/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.http.impl.entity;

import java.io.IOException;
import java.io.OutputStream;
import org.talend.bigdata.http.HttpEntity;
import org.talend.bigdata.http.HttpException;
import org.talend.bigdata.http.HttpMessage;
import org.talend.bigdata.http.annotation.Contract;
import org.talend.bigdata.http.annotation.ThreadingBehavior;
import org.talend.bigdata.http.entity.ContentLengthStrategy;
import org.talend.bigdata.http.impl.io.ChunkedOutputStream;
import org.talend.bigdata.http.impl.io.ContentLengthOutputStream;
import org.talend.bigdata.http.impl.io.IdentityOutputStream;
import org.talend.bigdata.http.io.SessionOutputBuffer;
import org.talend.bigdata.http.util.Args;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class EntitySerializer {
    private final ContentLengthStrategy lenStrategy;

    public EntitySerializer(ContentLengthStrategy lenStrategy) {
        this.lenStrategy = Args.notNull(lenStrategy, "Content length strategy");
    }

    protected OutputStream doSerialize(SessionOutputBuffer outbuffer, HttpMessage message) throws HttpException, IOException {
        long len = this.lenStrategy.determineLength(message);
        if (len == -2L) {
            return new ChunkedOutputStream(outbuffer);
        }
        if (len == -1L) {
            return new IdentityOutputStream(outbuffer);
        }
        return new ContentLengthOutputStream(outbuffer, len);
    }

    public void serialize(SessionOutputBuffer outbuffer, HttpMessage message, HttpEntity entity) throws HttpException, IOException {
        Args.notNull(outbuffer, "Session output buffer");
        Args.notNull(message, "HTTP message");
        Args.notNull(entity, "HTTP entity");
        OutputStream outStream = this.doSerialize(outbuffer, message);
        entity.writeTo(outStream);
        outStream.close();
    }
}

