/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.http.impl.io;

import java.io.IOException;
import org.talend.bigdata.http.Header;
import org.talend.bigdata.http.HeaderIterator;
import org.talend.bigdata.http.HttpException;
import org.talend.bigdata.http.HttpMessage;
import org.talend.bigdata.http.io.HttpMessageWriter;
import org.talend.bigdata.http.io.SessionOutputBuffer;
import org.talend.bigdata.http.message.BasicLineFormatter;
import org.talend.bigdata.http.message.LineFormatter;
import org.talend.bigdata.http.params.HttpParams;
import org.talend.bigdata.http.util.Args;
import org.talend.bigdata.http.util.CharArrayBuffer;

public abstract class AbstractMessageWriter<T extends HttpMessage>
implements HttpMessageWriter<T> {
    protected final SessionOutputBuffer sessionBuffer;
    protected final CharArrayBuffer lineBuf;
    protected final LineFormatter lineFormatter;

    @Deprecated
    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter, HttpParams params) {
        Args.notNull(buffer, "Session input buffer");
        this.sessionBuffer = buffer;
        this.lineBuf = new CharArrayBuffer(128);
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
    }

    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter) {
        this.sessionBuffer = Args.notNull(buffer, "Session input buffer");
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    protected abstract void writeHeadLine(T var1) throws IOException;

    @Override
    public void write(T message) throws IOException, HttpException {
        Args.notNull(message, "HTTP message");
        this.writeHeadLine(message);
        HeaderIterator it = message.headerIterator();
        while (it.hasNext()) {
            Header header = it.nextHeader();
            this.sessionBuffer.writeLine(this.lineFormatter.formatHeader(this.lineBuf, header));
        }
        this.lineBuf.clear();
        this.sessionBuffer.writeLine(this.lineBuf);
    }
}

