/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.google.dataproc;

import com.google.api.services.dataproc.Dataproc;
import com.google.api.services.dataproc.model.HadoopJob;
import com.google.api.services.dataproc.model.Job;
import com.google.api.services.dataproc.model.JobPlacement;
import com.google.api.services.dataproc.model.JobReference;
import com.google.api.services.dataproc.model.LoggingConfig;
import com.google.api.services.dataproc.model.SubmitJobRequest;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.launcher.google.dataproc.DataprocDriver;
import org.talend.bigdata.launcher.google.dataproc.DataprocJobUtil;
import org.talend.bigdata.launcher.google.dataproc.GoogleDataprocJob;
import org.talend.bigdata.utils.DataprocBuilder;

public class DataprocMRJob
extends GoogleDataprocJob {
    private static Logger MR_LOG = LoggerFactory.getLogger(DataprocMRJob.class);
    private LoggingConfig loggingConfig;

    private DataprocMRJob(String talendJobName, String clusterName, String region, String projectId, String jarsBucket, String serviceAccountCredentialsPath, Map<String, String> conf, String mainClass, String jarToExecute, String libJars, List<String> args, String logLevel) {
        this.talendJobName = talendJobName;
        this.clusterName = clusterName;
        this.projectId = projectId;
        this.region = region;
        this.jarsBucket = jarsBucket;
        this.serviceAccountCredentialsPath = serviceAccountCredentialsPath;
        this.conf = conf;
        this.mainClass = mainClass;
        this.jarToExecute = jarToExecute;
        this.libJars = libJars;
        this.args = args;
        if (StringUtils.isNotEmpty((String)logLevel)) {
            this.loggingConfig = new LoggingConfig();
            HashMap<String, String> driverLogLevels = new HashMap<String, String>();
            driverLogLevels.put("root", logLevel);
            this.loggingConfig.setDriverLogLevels(driverLogLevels);
        }
    }

    @Override
    protected Job execute(List<String> jarsFileUris) throws IOException, GeneralSecurityException {
        Dataproc dataproc = DataprocDriver.createDataprocClient(this.talendJobName, this.serviceAccountCredentialsPath);
        List<String> remoteArgs = DataprocJobUtil.prepareArgs(this.args);
        Map<String, String> properties = DataprocJobUtil.prepareProperties(this.conf);
        HadoopJob mrJob = new HadoopJob().setMainClass(this.mainClass).setJarFileUris(jarsFileUris).setProperties(properties).setArgs(remoteArgs).setLoggingConfig(this.loggingConfig);
        Job job = new Job().setReference(new JobReference().setJobId(this.talendJobName)).setPlacement(new JobPlacement().setClusterName(this.clusterName)).setHadoopJob(mrJob);
        try {
            MR_LOG.info("Submitting job " + this.talendJobName + "to Google Dataproc...");
            return (Job)dataproc.projects().regions().jobs().submit(this.projectId, this.region, new SubmitJobRequest().setJob(job)).execute();
        }
        catch (IOException e) {
            MR_LOG.error(e.getMessage());
            MR_LOG.info("Trying to use job.");
            Job retrievedJob = (Job)dataproc.projects().regions().jobs().get(this.projectId, this.region, this.talendJobName).execute();
            MR_LOG.info("Despite exception, job was verified submitted.");
            return retrievedJob;
        }
    }

    public static class Builder
    extends DataprocBuilder<DataprocMRJob> {
        @Override
        public DataprocMRJob build() {
            return new DataprocMRJob(this.talendJobName, this.clusterName, this.region, this.projectId, this.jarsBucket, this.serviceAccountCredentialsPath, this.conf, this.mainClass, this.jarToExecute, this.libjars, this.args, this.logLevel);
        }
    }
}

