/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.manage.google.dataproc;

import com.google.api.services.dataproc.Dataproc;
import com.google.api.services.dataproc.model.Cluster;
import com.google.api.services.dataproc.model.ClusterConfig;
import com.google.api.services.dataproc.model.DiskConfig;
import com.google.api.services.dataproc.model.GceClusterConfig;
import com.google.api.services.dataproc.model.InstanceGroupConfig;
import com.google.api.services.dataproc.model.NodeInitializationAction;
import com.google.api.services.dataproc.model.Operation;
import com.google.api.services.dataproc.model.SoftwareConfig;
import com.google.api.services.dataproc.model.Status;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.launcher.google.dataproc.DataprocDriver;

public class DataprocCreateCluster {
    private static Logger LOG = LoggerFactory.getLogger(DataprocCreateCluster.class);
    private static final String ROOT_URI = "https://www.googleapis.com/compute/v1/projects/%s";
    private static final String NETWORKS_URI = "https://www.googleapis.com/compute/v1/projects/%s/global/networks/%s";
    private static final String SUBNETWORKS_URI = "https://www.googleapis.com/compute/v1/projects/%s/regions/%s/subnetworks/%s";
    private static final String ZONES_URI = "https://www.googleapis.com/compute/v1/projects/%s/zones/%s";
    private static final String MACHINE_TYPES_URI = "https://www.googleapis.com/compute/v1/projects/%s/zones/%s/machineTypes/%s";
    protected String talendJobName;
    protected String clusterName;
    protected String projectId;
    protected String zone;
    protected String region;
    protected String networkName;
    protected String subnetworkName;
    protected String serviceAccountCredentialsPath;
    protected String version;
    protected InstanceGroupHolder masterInstanceGroupHolder;
    protected InstanceGroupHolder workerInstanceGroupHolder;
    protected InstanceGroupHolder secondaryWorkerInstanceGroupHolder;
    protected List<InitializationActionHolder> initializationActions = new ArrayList<InitializationActionHolder>();
    protected List<String> tags = new ArrayList<String>();
    protected boolean waitForClusterReady;
    protected boolean internalIpOnly;

    private DataprocCreateCluster() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void run() throws IOException, GeneralSecurityException, InterruptedException {
        Dataproc dataproc = DataprocDriver.createDataprocClient(this.talendJobName, this.serviceAccountCredentialsPath);
        Cluster cluster = this.configureRequest();
        LOG.info("Sending creation request for cluster " + this.clusterName);
        Dataproc.Projects.Regions.Clusters.Create createCluster = dataproc.projects().regions().clusters().create(this.projectId, this.region, cluster);
        Operation createClusterOperation = (Operation)createCluster.execute();
        if (this.waitForClusterReady) {
            LOG.info("Waiting until the operation " + createClusterOperation.getName() + " is done.");
            boolean pollOperationState = true;
            while (pollOperationState) {
                Thread.sleep(10000L);
                LOG.info("Operation " + createClusterOperation.getName() + " is still ongoing...");
                Dataproc.Projects.Regions.Operations.Get getOperation = dataproc.projects().regions().operations().get(createClusterOperation.getName());
                createClusterOperation = (Operation)getOperation.execute();
                pollOperationState = createClusterOperation.getDone() == null || createClusterOperation.getDone() == false;
            }
            Status error = createClusterOperation.getError();
            if (error != null) {
                throw new RuntimeException("Failed to create cluster " + this.clusterName + " : [" + error.getCode() + "] " + error.getMessage());
            }
            this.checkClusterStatus(dataproc);
        } else {
            LOG.info("Not waiting until the cluster is available : fire and forget.");
        }
    }

    protected Cluster configureRequest() {
        GceClusterConfig gceClusterConfig = this.buildGceClusterConfig();
        InstanceGroupConfig masterConfig = this.buildInstanceGroupConfig(this.masterInstanceGroupHolder);
        InstanceGroupConfig workerConfig = this.buildInstanceGroupConfig(this.workerInstanceGroupHolder);
        InstanceGroupConfig secondaryWorkerConfig = this.buildInstanceGroupConfig(this.secondaryWorkerInstanceGroupHolder);
        SoftwareConfig softwareConfig = this.buildSoftwareConfig();
        List<NodeInitializationAction> nodeInitializationActions = this.buildNodeIntializationActions();
        ClusterConfig clusterConfig = new ClusterConfig();
        clusterConfig.setGceClusterConfig(gceClusterConfig);
        clusterConfig.setMasterConfig(masterConfig);
        clusterConfig.setWorkerConfig(workerConfig);
        clusterConfig.setSecondaryWorkerConfig(secondaryWorkerConfig);
        clusterConfig.setSoftwareConfig(softwareConfig);
        if (!nodeInitializationActions.isEmpty()) {
            clusterConfig.setInitializationActions(nodeInitializationActions);
        }
        Cluster cluster = new Cluster();
        cluster.setClusterName(this.clusterName);
        cluster.setProjectId(this.projectId);
        cluster.setConfig(clusterConfig);
        return cluster;
    }

    protected List<NodeInitializationAction> buildNodeIntializationActions() {
        ArrayList<NodeInitializationAction> nodeInitializationActions = new ArrayList<NodeInitializationAction>();
        if (!this.initializationActions.isEmpty()) {
            for (InitializationActionHolder initializationAction : this.initializationActions) {
                NodeInitializationAction nodeInitializationAction = new NodeInitializationAction();
                nodeInitializationAction.setExecutableFile(initializationAction.executableFile);
                if (StringUtils.isNotEmpty((String)initializationAction.executionTimeout)) {
                    nodeInitializationAction.setExecutionTimeout(initializationAction.executionTimeout);
                }
                nodeInitializationActions.add(nodeInitializationAction);
            }
        }
        return nodeInitializationActions;
    }

    protected SoftwareConfig buildSoftwareConfig() {
        SoftwareConfig softwareConfig = new SoftwareConfig();
        if (!"latest".equals(this.version)) {
            softwareConfig.setImageVersion(this.version);
        }
        return softwareConfig;
    }

    private GceClusterConfig buildGceClusterConfig() {
        GceClusterConfig gceClusterConfig = new GceClusterConfig();
        gceClusterConfig.setZoneUri(String.format(ZONES_URI, this.projectId, this.zone));
        if (StringUtils.isNotEmpty((String)this.networkName)) {
            gceClusterConfig.setNetworkUri(String.format(NETWORKS_URI, this.projectId, this.networkName));
        }
        if (StringUtils.isNotEmpty((String)this.subnetworkName)) {
            gceClusterConfig.setSubnetworkUri(String.format(SUBNETWORKS_URI, this.projectId, this.zone.substring(0, this.zone.length() - 2), this.subnetworkName));
        }
        gceClusterConfig.setInternalIpOnly(Boolean.valueOf(this.internalIpOnly));
        if (!this.tags.isEmpty()) {
            gceClusterConfig.setTags(this.tags);
        }
        return gceClusterConfig;
    }

    protected InstanceGroupConfig buildInstanceGroupConfig(InstanceGroupHolder holder) {
        InstanceGroupConfig instanceGroupConfig = new InstanceGroupConfig();
        DiskConfig diskConfig = new DiskConfig();
        if (holder.bootDiskSizeGb != null) {
            diskConfig.setBootDiskSizeGb(holder.bootDiskSizeGb);
        }
        if (holder.numLocalSsds != null) {
            diskConfig.setNumLocalSsds(holder.numLocalSsds);
        }
        instanceGroupConfig.setNumInstances(holder.numInstances);
        instanceGroupConfig.setMachineTypeUri(String.format(MACHINE_TYPES_URI, this.projectId, this.zone, holder.instanceType));
        instanceGroupConfig.setDiskConfig(diskConfig);
        instanceGroupConfig.setIsPreemptible(Boolean.valueOf(holder.isPreemptible));
        return instanceGroupConfig;
    }

    protected void checkClusterStatus(Dataproc dataproc) throws IOException {
        LOG.debug("Checking status of cluster " + this.clusterName);
        Dataproc.Projects.Regions.Clusters.Get getCluster = dataproc.projects().regions().clusters().get(this.projectId, this.region, this.clusterName);
        Cluster actualCluster = (Cluster)getCluster.execute();
        String state = actualCluster.getStatus().getState();
        String startTime = actualCluster.getStatus().getStateStartTime();
        LOG.info("Cluster " + this.clusterName + " has been created. Current state : " + state + ". Started at " + startTime);
    }

    public static class Builder {
        private DataprocCreateCluster dataprocCreateCluster = new DataprocCreateCluster();
        protected String masterInstanceType;
        protected Integer masterNumInstances;
        protected Integer masterBootDiskSizeGb;
        protected Integer masterNumLocalSsds;
        protected String workerInstanceType;
        protected Integer workerNumInstances;
        protected Integer workerBootDiskSizeGb;
        protected Integer workerNumLocalSsds;
        protected Integer secondaryWorkerNumInstances;

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder withServiceAccountCredentialsPath(String serviceAccountCredentialsPath) {
            this.dataprocCreateCluster.serviceAccountCredentialsPath = serviceAccountCredentialsPath;
            return this;
        }

        public Builder withTalendJobName(String talendJobName) {
            this.dataprocCreateCluster.talendJobName = talendJobName;
            return this;
        }

        public Builder withClusterName(String clusterName) {
            this.dataprocCreateCluster.clusterName = clusterName;
            return this;
        }

        public Builder withRegion(String region) {
            this.dataprocCreateCluster.region = region;
            return this;
        }

        public Builder withZone(String zone) {
            this.dataprocCreateCluster.zone = zone;
            return this;
        }

        public Builder withProjectId(String projectId) {
            this.dataprocCreateCluster.projectId = projectId;
            return this;
        }

        public Builder withVersion(String version) {
            this.dataprocCreateCluster.version = version;
            return this;
        }

        public Builder withMasterInstanceType(String masterInstanceType) {
            this.masterInstanceType = masterInstanceType;
            return this;
        }

        public Builder withMasterNumInstances(Integer masterNumInstances) {
            this.masterNumInstances = masterNumInstances;
            return this;
        }

        public Builder withMasterBootDiskSizeGb(Integer masterBootDiskSizeGb) {
            this.masterBootDiskSizeGb = masterBootDiskSizeGb;
            return this;
        }

        public Builder withMasterNumLocalSsds(Integer masterNumLocalSsds) {
            this.masterNumLocalSsds = masterNumLocalSsds;
            return this;
        }

        public Builder withWorkerInstanceType(String workerInstanceType) {
            this.workerInstanceType = workerInstanceType;
            return this;
        }

        public Builder withWorkerBootDiskSizeGb(Integer workerBootDiskSizeGb) {
            this.workerBootDiskSizeGb = workerBootDiskSizeGb;
            return this;
        }

        public Builder withWorkerNumLocalSsds(Integer workerNumLocalSsds) {
            this.workerNumLocalSsds = workerNumLocalSsds;
            return this;
        }

        public Builder withWorkerNumInstances(Integer workerNumInstances) {
            this.workerNumInstances = workerNumInstances;
            return this;
        }

        public Builder withSecondaryWorkerNumInstances(Integer secondaryWorkerNumInstances) {
            this.secondaryWorkerNumInstances = secondaryWorkerNumInstances;
            return this;
        }

        public Builder withWaitForClusterReady(boolean waitForClusterReady) {
            this.dataprocCreateCluster.waitForClusterReady = waitForClusterReady;
            return this;
        }

        public Builder withNetworkName(String networkName) {
            this.dataprocCreateCluster.networkName = networkName;
            return this;
        }

        public Builder withSubnetworkName(String subnetworkName) {
            this.dataprocCreateCluster.subnetworkName = subnetworkName;
            return this;
        }

        public Builder withInitializationActions(List<InitializationActionHolder> initializationActions) {
            this.dataprocCreateCluster.initializationActions = initializationActions;
            return this;
        }

        public Builder withTags(List<String> tags) {
            this.dataprocCreateCluster.tags = tags;
            return this;
        }

        public Builder withInternalIpOnly(boolean internalIpOnly) {
            this.dataprocCreateCluster.internalIpOnly = internalIpOnly;
            return this;
        }

        public DataprocCreateCluster build() {
            this.dataprocCreateCluster.masterInstanceGroupHolder = new InstanceGroupHolder(this.masterInstanceType, this.masterNumInstances, this.masterBootDiskSizeGb, this.masterNumLocalSsds, false);
            this.dataprocCreateCluster.workerInstanceGroupHolder = new InstanceGroupHolder(this.workerInstanceType, this.workerNumInstances, this.workerBootDiskSizeGb, this.workerNumLocalSsds, false);
            this.dataprocCreateCluster.secondaryWorkerInstanceGroupHolder = new InstanceGroupHolder(this.workerInstanceType, this.secondaryWorkerNumInstances);
            return this.dataprocCreateCluster;
        }
    }

    public static class InstanceGroupHolder {
        protected String instanceType;
        protected Integer numInstances;
        protected Integer bootDiskSizeGb;
        protected Integer numLocalSsds;
        protected boolean isPreemptible;

        public InstanceGroupHolder(String instanceType, Integer numInstances, Integer bootDiskSizeGb, Integer numLocalSsds, boolean isPreemptible) {
            this.instanceType = instanceType;
            this.numInstances = numInstances;
            this.bootDiskSizeGb = bootDiskSizeGb;
            this.numLocalSsds = numLocalSsds;
            this.isPreemptible = isPreemptible;
        }

        public InstanceGroupHolder(String instanceType, Integer numInstances) {
            this.instanceType = instanceType;
            this.numInstances = numInstances;
            this.isPreemptible = true;
        }
    }

    public static class InitializationActionHolder {
        protected String executableFile;
        protected String executionTimeout;

        public InitializationActionHolder(String executableFile, String executionTimeout) {
            this.executableFile = executableFile;
            this.executionTimeout = executionTimeout;
        }

        public InitializationActionHolder(String executableFile) {
            this.executableFile = executableFile;
        }
    }
}

