/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.google.dataproc;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.dataproc.Dataproc;
import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataprocDriver {
    private static Logger LOG = LoggerFactory.getLogger(DataprocDriver.class);

    public static Dataproc createDataprocClient(String applicationName, String serviceAccountCredentialsPath) throws IOException, GeneralSecurityException {
        GoogleCredential credential;
        GoogleCredential googleCredential = credential = StringUtils.isEmpty((CharSequence)serviceAccountCredentialsPath) ? GoogleCredential.getApplicationDefault() : DataprocDriver.getServiceAccountCredentialsForDataproc(serviceAccountCredentialsPath);
        if (credential.createScopedRequired()) {
            credential = credential.createScoped(Collections.singletonList("https://www.googleapis.com/auth/cloud-platform"));
        }
        NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
        LOG.info("Create dataproc object with service account (json) authentication for: " + applicationName);
        return new Dataproc.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, (HttpRequestInitializer)credential).setApplicationName(applicationName).build();
    }

    private static GoogleCredential getServiceAccountCredentialsForDataproc(String serviceAccountCredentialsPath) throws IOException {
        File serviceAccountCredentialsFile = new File(serviceAccountCredentialsPath);
        FileInputStream serviceAccountCredentialsStream = new FileInputStream(serviceAccountCredentialsFile);
        return GoogleCredential.fromStream((InputStream)serviceAccountCredentialsStream);
    }

    public static Storage createStorageService(String serviceAccountCredentialsPath, String projectId) throws IOException {
        StorageOptions.Builder builder = (StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(projectId);
        if (StringUtils.isNotEmpty((CharSequence)serviceAccountCredentialsPath)) {
            builder.setCredentials((Credentials)DataprocDriver.getServiceAccountCredentialsForStorage(serviceAccountCredentialsPath));
        }
        LOG.info("Create Storage object with service account (json)");
        return (Storage)builder.build().getService();
    }

    private static GoogleCredentials getServiceAccountCredentialsForStorage(String serviceAccountCredentialsPath) throws IOException {
        File serviceAccountCredentialsFile = new File(serviceAccountCredentialsPath);
        FileInputStream serviceAccountCredentialsStream = new FileInputStream(serviceAccountCredentialsFile);
        return GoogleCredentials.fromStream((InputStream)serviceAccountCredentialsStream);
    }

    public static Dataproc createDataprocClientWithToken(String applicationName, String accessToken) throws IOException, GeneralSecurityException {
        GoogleCredential credential = new GoogleCredential().setAccessToken(accessToken);
        if (credential.createScopedRequired()) {
            credential = credential.createScoped(Collections.singletonList("https://www.googleapis.com/auth/cloud-platform"));
        }
        NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
        return new Dataproc.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, (HttpRequestInitializer)credential).setApplicationName(applicationName).build();
    }

    public static Storage createStorageToken(String accessToken, String projectId) throws IOException {
        StorageOptions.Builder builder = (StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(projectId);
        if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
            builder.setCredentials((Credentials)DataprocDriver.getOAuthCredentialsForStorage(accessToken));
        }
        LOG.info("Create Storage object with access token");
        return (Storage)builder.build().getService();
    }

    private static GoogleCredentials getOAuthCredentialsForStorage(String accessToken) throws IOException {
        AccessToken token = new AccessToken(accessToken, null);
        GoogleCredentials credentials = new GoogleCredentials(token);
        return credentials;
    }

    public static Dataproc createDataprocClient(String applicationName, String p12KeyPath, String serviceAccountId) throws IOException, GeneralSecurityException {
        NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
        GoogleCredential credential = new GoogleCredential.Builder().setTransport((HttpTransport)httpTransport).setJsonFactory((JsonFactory)jsonFactory).setServiceAccountId(serviceAccountId).setServiceAccountPrivateKeyFromP12File((InputStream)new FileInputStream(p12KeyPath)).build();
        if (credential.createScopedRequired()) {
            credential = credential.createScoped(Collections.singletonList("https://www.googleapis.com/auth/cloud-platform"));
        }
        LOG.info("Create dataproc object with service account (p12) authentication for: " + applicationName);
        return new Dataproc.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, (HttpRequestInitializer)credential).setApplicationName(applicationName).build();
    }

    private static GoogleCredential getServiceAccountCredentialsForDataproc(String p12KeyPath, String serviceAccountId) throws IOException, GeneralSecurityException {
        NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
        GoogleCredential credential = new GoogleCredential.Builder().setTransport((HttpTransport)httpTransport).setJsonFactory((JsonFactory)jsonFactory).setServiceAccountId(serviceAccountId).setServiceAccountPrivateKeyFromP12File((InputStream)new FileInputStream(p12KeyPath)).build();
        return credential;
    }

    public static Storage createStorageService(String p12KeyPath, String serviceAccountId, String projectId) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException {
        StorageOptions.Builder builder = (StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(projectId);
        if (StringUtils.isNotEmpty((CharSequence)p12KeyPath)) {
            builder.setCredentials((Credentials)DataprocDriver.getServiceAccountCredentialsForStorage(p12KeyPath, serviceAccountId));
        }
        LOG.info("Create Storage object with service account (p12)");
        return (Storage)builder.build().getService();
    }

    private static ServiceAccountCredentials getServiceAccountCredentialsForStorage(String p12KeyPath, String serviceAccountId) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException {
        ServiceAccountCredentials credentials = ServiceAccountCredentials.newBuilder().setPrivateKey(DataprocDriver.getPrivateKey(p12KeyPath)).setClientEmail(serviceAccountId).build();
        return credentials;
    }

    private static PrivateKey getPrivateKey(String p12KeyPath) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException {
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        keystore.load(new FileInputStream(p12KeyPath), "notasecret".toCharArray());
        PrivateKey key = (PrivateKey)keystore.getKey("privatekey", "notasecret".toCharArray());
        return key;
    }
}

