/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.google.dataproc;

import com.google.api.services.dataproc.Dataproc;
import com.google.api.services.dataproc.model.Job;
import com.google.api.services.dataproc.model.JobPlacement;
import com.google.api.services.dataproc.model.JobReference;
import com.google.api.services.dataproc.model.LoggingConfig;
import com.google.api.services.dataproc.model.SparkJob;
import com.google.api.services.dataproc.model.SubmitJobRequest;
import com.google.cloud.storage.Storage;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.launcher.google.dataproc.DataprocDriver;
import org.talend.bigdata.launcher.google.dataproc.DataprocJobUtil;
import org.talend.bigdata.launcher.google.dataproc.GoogleDataprocJob;
import org.talend.bigdata.utils.DataprocBuilder;

public class DataprocSparkJob
extends GoogleDataprocJob {
    private static final Logger SPARK_LOG = LoggerFactory.getLogger(DataprocSparkJob.class);
    private LoggingConfig loggingConfig;
    private Storage storage;
    private Dataproc dataproc;

    private DataprocSparkJob(String talendJobName, String clusterName, String region, String projectId, String jarsBucket, GoogleDataprocJob.AuthType oauthType, Map<String, String> conf, String mainClass, String jarToExecute, String libJars, List<String> args, String logLevel) {
        this.talendJobName = talendJobName;
        this.clusterName = clusterName;
        this.projectId = projectId;
        this.region = region;
        this.jarsBucket = jarsBucket;
        this.oauthType = oauthType;
        this.conf = conf;
        this.mainClass = mainClass;
        this.jarToExecute = jarToExecute;
        this.libJars = libJars;
        this.args = args;
        if (StringUtils.isNotEmpty((CharSequence)logLevel)) {
            this.loggingConfig = new LoggingConfig();
            HashMap<String, String> driverLogLevels = new HashMap<String, String>();
            driverLogLevels.put("root", logLevel);
            this.loggingConfig.setDriverLogLevels(driverLogLevels);
        }
    }

    private DataprocSparkJob(String talendJobName, String clusterName, String region, String projectId, String jarsBucket, GoogleDataprocJob.AuthType oauthType, String serviceAccountCredentialsPath, String serviceAccountId, Map<String, String> conf, String mainClass, String jarToExecute, String libJars, List<String> args, String logLevel) {
        this(talendJobName, clusterName, region, projectId, jarsBucket, oauthType, conf, mainClass, jarToExecute, libJars, args, logLevel);
        this.serviceAccountCredentialsPath = serviceAccountCredentialsPath;
        this.serviceAccountId = serviceAccountId;
    }

    private DataprocSparkJob(String talendJobName, String clusterName, String region, String projectId, String jarsBucket, GoogleDataprocJob.AuthType oauthType, String accessToken, Map<String, String> conf, String mainClass, String jarToExecute, String libJars, List<String> args, String logLevel) {
        this(talendJobName, clusterName, region, projectId, jarsBucket, oauthType, conf, mainClass, jarToExecute, libJars, args, logLevel);
        this.accessToken = accessToken;
    }

    @Override
    public Storage getStorage() {
        if (this.storage == null) {
            try {
                this.storage = GoogleDataprocJob.AuthType.SERVICE_ACCOUNT.equals((Object)this.oauthType) ? (this.serviceAccountId == null ? DataprocDriver.createStorageService(this.serviceAccountCredentialsPath, this.projectId) : DataprocDriver.createStorageService(this.serviceAccountCredentialsPath, this.serviceAccountId, this.projectId)) : DataprocDriver.createStorageToken(this.accessToken, this.projectId);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create Google Storage client.", e);
            }
        }
        return this.storage;
    }

    @Override
    protected Job execute(List<String> jarsFileUris) throws IOException, GeneralSecurityException {
        this.dataproc = GoogleDataprocJob.AuthType.SERVICE_ACCOUNT.equals((Object)this.oauthType) ? (this.serviceAccountId == null ? DataprocDriver.createDataprocClient(this.talendJobName, this.serviceAccountCredentialsPath) : DataprocDriver.createDataprocClient(this.talendJobName, this.serviceAccountCredentialsPath, this.serviceAccountId)) : DataprocDriver.createDataprocClientWithToken(this.talendJobName, this.accessToken);
        List<String> remoteArgs = DataprocJobUtil.prepareArgs(this.args);
        Map<String, String> properties = DataprocJobUtil.prepareProperties(this.conf);
        SparkJob sparkJob = new SparkJob().setMainClass(this.mainClass).setJarFileUris(jarsFileUris).setProperties(properties).setArgs(remoteArgs).setLoggingConfig(this.loggingConfig);
        Job job = new Job().setReference(new JobReference().setJobId(this.talendJobName)).setPlacement(new JobPlacement().setClusterName(this.clusterName)).setSparkJob(sparkJob);
        try {
            SPARK_LOG.info("Submitting job " + this.talendJobName + "to Google Dataproc...");
            return (Job)this.dataproc.projects().regions().jobs().submit(this.projectId, this.region, new SubmitJobRequest().setJob(job)).execute();
        }
        catch (IOException e) {
            SPARK_LOG.error(e.getMessage());
            SPARK_LOG.info("Trying to use job.");
            Job retrievedJob = (Job)this.dataproc.projects().regions().jobs().get(this.projectId, this.region, this.talendJobName).execute();
            SPARK_LOG.info("Despite exception, job was verified submitted.");
            return retrievedJob;
        }
    }

    public static class Builder
    extends DataprocBuilder<DataprocSparkJob> {
        @Override
        public DataprocSparkJob build() {
            DataprocSparkJob dataprocSparkJob = null;
            dataprocSparkJob = GoogleDataprocJob.AuthType.SERVICE_ACCOUNT.name().equals(this.oauthType) ? new DataprocSparkJob(this.talendJobName, this.clusterName, this.region, this.projectId, this.jarsBucket, GoogleDataprocJob.AuthType.valueOf(this.oauthType), this.serviceAccountCredentialsPath, this.serviceAccountId, this.conf, this.mainClass, this.jarToExecute, this.libjars, this.args, this.logLevel) : new DataprocSparkJob(this.talendJobName, this.clusterName, this.region, this.projectId, this.jarsBucket, this.oauthType == null ? GoogleDataprocJob.AuthType.OAUTH_API : GoogleDataprocJob.AuthType.valueOf(this.oauthType), this.accessToken, this.conf, this.mainClass, this.jarToExecute, this.libjars, this.args, this.logLevel);
            return dataprocSparkJob;
        }
    }
}

