/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.utils;

import java.util.List;
import java.util.Map;
import org.talend.bigdata.launcher.google.dataproc.GoogleDataprocJob;

public abstract class DataprocBuilder<T extends GoogleDataprocJob> {
    protected String serviceAccountCredentialsPath;
    protected String jarsBucket;
    protected String libjars;
    protected String jarToExecute;
    protected String mainClass;
    protected List<String> args;
    protected Map<String, String> conf;
    protected String talendJobName;
    protected String clusterName;
    protected String region;
    protected String projectId;
    protected String logLevel;
    protected String oauthType;
    protected String serviceAccountId;
    protected String accessToken;

    public DataprocBuilder<T> withAuthenticationType(String oauthType) {
        this.oauthType = oauthType;
        return this;
    }

    public DataprocBuilder<T> withServiceAccountId(String serviceAccountId) {
        this.serviceAccountId = serviceAccountId;
        return this;
    }

    public DataprocBuilder<T> withAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public DataprocBuilder<T> withJarToExecute(String jarToExecute) {
        this.jarToExecute = jarToExecute;
        return this;
    }

    public DataprocBuilder<T> withMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public DataprocBuilder<T> withJarsBucket(String jarsBucket) {
        this.jarsBucket = jarsBucket;
        return this;
    }

    public DataprocBuilder<T> withLibJars(String libJars) {
        this.libjars = libJars;
        return this;
    }

    public DataprocBuilder<T> withClusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    public DataprocBuilder<T> withTalendJobName(String talendJobName) {
        this.talendJobName = talendJobName;
        return this;
    }

    public DataprocBuilder<T> withRegion(String region) {
        this.region = region;
        return this;
    }

    public DataprocBuilder<T> withProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public DataprocBuilder<T> withConf(Map<String, String> conf) {
        this.conf = conf;
        return this;
    }

    public DataprocBuilder<T> withArgs(List<String> args) {
        this.args = args;
        return this;
    }

    public DataprocBuilder<T> withServiceAccountCredentialsPath(String serviceAccountCredentialsPath) {
        this.serviceAccountCredentialsPath = serviceAccountCredentialsPath;
        return this;
    }

    public DataprocBuilder<T> withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public abstract T build();
}

