/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.livy;

import org.talend.bigdata.http.client.fluent.Request;
import org.talend.bigdata.http.entity.ContentType;
import org.talend.bigdata.http.message.BasicHeader;
import org.talend.bigdata.launcher.AbstractSparkJobRequest;

class SparkJobRequest
extends AbstractSparkJobRequest {
    private static final String LIVY_BATCHES_PATH = "/livy/batches";
    private static final String LIVY_BATCHES_PATH_WITH_SLASH = "/livy/batches/";

    private SparkJobRequest(Request request, String rootEndpoint, String apiPath) {
        super(request, rootEndpoint, apiPath);
    }

    private static SparkJobRequest Get(String rootEndpoint, String apiPath) {
        String fullEndpoint = SparkJobRequest.buildFullEndpoint(rootEndpoint, apiPath);
        return new SparkJobRequest(Request.Get(fullEndpoint), rootEndpoint, apiPath);
    }

    private static SparkJobRequest Delete(String rootEndpoint, String apiPath, String username) {
        String fullEndpoint = SparkJobRequest.buildFullEndpoint(rootEndpoint, apiPath);
        return new SparkJobRequest(Request.Delete(fullEndpoint).addHeader(new BasicHeader("X-Requested-By", username)), rootEndpoint, apiPath);
    }

    private static SparkJobRequest Post(String rootEndpoint, String apiPath, String body, String username) {
        String fullEndpoint = SparkJobRequest.buildFullEndpoint(rootEndpoint, apiPath);
        return new SparkJobRequest(Request.Post(fullEndpoint).addHeader(new BasicHeader("X-Requested-By", username)).bodyString(body, ContentType.APPLICATION_JSON), rootEndpoint, apiPath);
    }

    public static SparkJobRequest run(String rootEndpoint, String body, String username) {
        return SparkJobRequest.Post(rootEndpoint, LIVY_BATCHES_PATH, body, username);
    }

    public static SparkJobRequest log(String rootEndpoint, Long jobId) {
        return SparkJobRequest.Get(rootEndpoint, LIVY_BATCHES_PATH_WITH_SLASH + jobId + "/log");
    }

    public static SparkJobRequest state(String rootEndpoint, Long jobId) {
        return SparkJobRequest.Get(rootEndpoint, LIVY_BATCHES_PATH_WITH_SLASH + jobId + "/state");
    }

    public static SparkJobRequest cancel(String rootEndpoint, Long jobId, String username) {
        return SparkJobRequest.Delete(rootEndpoint, LIVY_BATCHES_PATH_WITH_SLASH + jobId, username);
    }
}

