/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.http.impl.io;

import org.talend.bigdata.http.HttpResponse;
import org.talend.bigdata.http.HttpResponseFactory;
import org.talend.bigdata.http.annotation.Contract;
import org.talend.bigdata.http.annotation.ThreadingBehavior;
import org.talend.bigdata.http.config.MessageConstraints;
import org.talend.bigdata.http.impl.DefaultHttpResponseFactory;
import org.talend.bigdata.http.impl.io.DefaultHttpResponseParser;
import org.talend.bigdata.http.io.HttpMessageParser;
import org.talend.bigdata.http.io.HttpMessageParserFactory;
import org.talend.bigdata.http.io.SessionInputBuffer;
import org.talend.bigdata.http.message.BasicLineParser;
import org.talend.bigdata.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

