/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.fs;

import com.microsoft.azure.datalake.store.ADLFileOutputStream;
import com.microsoft.azure.datalake.store.ADLStoreClient;
import com.microsoft.azure.datalake.store.IfExists;
import com.microsoft.azure.datalake.store.oauth2.AccessTokenProvider;
import com.microsoft.azure.datalake.store.oauth2.ClientCredsTokenProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.talend.bigdata.launcher.fs.FileSystem;

public class AzureDataLakeStorage
extends FileSystem {
    private final String account;
    private final String appId;
    private final String authTokenEndpoint;
    private final String appKey;
    private final AccessTokenProvider provider;
    private final ADLStoreClient client;

    public AzureDataLakeStorage(String account, String appId, String authTokenEndpoint, String appKey) {
        this.account = account;
        this.appId = appId;
        this.authTokenEndpoint = authTokenEndpoint;
        this.appKey = appKey;
        this.provider = new ClientCredsTokenProvider(this.authTokenEndpoint, this.appId, this.appKey);
        this.client = ADLStoreClient.createClient((String)account, (AccessTokenProvider)this.provider);
    }

    @Override
    public boolean exists(String file) {
        try {
            return this.client.checkExists(file);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            return false;
        }
    }

    @Override
    public InputStream open(String file) {
        try {
            return this.client.getReadStream(file);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    @Override
    public void delete(String folder) {
        try {
            this.client.deleteRecursive(folder);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    @Override
    public void mkdir(String folder) {
        try {
            this.client.createDirectory(folder);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    @Override
    public void copyFromLocal(String localFilePath, String targetFolder) {
        FileInputStream is = null;
        ADLFileOutputStream os = null;
        IfExists overWriteMode = IfExists.FAIL;
        if (this.overwrite) {
            overWriteMode = IfExists.OVERWRITE;
        }
        try {
            int length;
            this.client.createDirectory(targetFolder);
            File localFile = new File(localFilePath);
            is = new FileInputStream(localFile);
            os = this.client.createFile(targetFolder + "/" + localFile.getName(), overWriteMode);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)is).read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
            ((InputStream)is).close();
            os.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    @Override
    public String getFileSystemPrefix() {
        return "adl://" + this.account;
    }
}

