/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.http.impl.client;

import org.talend.bigdata.http.HeaderElement;
import org.talend.bigdata.http.HttpResponse;
import org.talend.bigdata.http.annotation.Contract;
import org.talend.bigdata.http.annotation.ThreadingBehavior;
import org.talend.bigdata.http.conn.ConnectionKeepAliveStrategy;
import org.talend.bigdata.http.message.BasicHeaderElementIterator;
import org.talend.bigdata.http.protocol.HttpContext;
import org.talend.bigdata.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

