/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.fs;

import com.azure.storage.blob.BlobContainerClientBuilder;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobInputStream;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.launcher.fs.FileSystem;

public class AzureFileSystem
extends FileSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureFileSystem.class);
    protected CloudBlobContainer mContainer;
    protected boolean useTLS;

    public AzureFileSystem(CloudBlobContainer container) {
        this.mContainer = container;
    }

    public AzureFileSystem(String endpoint, String sasToken, String container) throws URISyntaxException, StorageException, InvalidKeyException {
        new BlobContainerClientBuilder().endpoint(endpoint).sasToken(sasToken).buildClient();
        String sasConnString = this.sasConnection(endpoint, sasToken);
        CloudStorageAccount connection = AzureFileSystem.getConnection(sasConnString);
        this.mContainer = connection.createCloudBlobClient().getContainerReference(container);
    }

    public AzureFileSystem(String connectionString, String container) throws IOException {
        try {
            this.overwrite = false;
            CloudStorageAccount connection = AzureFileSystem.getConnection(connectionString);
            this.mContainer = connection.createCloudBlobClient().getContainerReference(container);
        }
        catch (URISyntaxException | InvalidKeyException e) {
            LOGGER.error("connection can not be established. Please, ensure the connection string is valid: " + connectionString, (Throwable)e);
            throw new IOException("connection can not be established. Please, ensure the connection string is valid: " + connectionString, e);
        }
        catch (StorageException e) {
            LOGGER.error("container can not be found. Please, ensure the container exist: " + container + " in this connection", (Throwable)e);
            throw new IOException("container can not be found. Please, ensure the container exist: " + container + " in this connection", e);
        }
    }

    public static CloudStorageAccount getConnection(String connectionString) throws InvalidKeyException, URISyntaxException {
        return CloudStorageAccount.parse((String)connectionString);
    }

    public void deleteFolder(String folder, CloudBlobContainer container) throws StorageException, URISyntaxException {
        for (ListBlobItem blobItem : container.listBlobs(folder)) {
            if (blobItem instanceof CloudBlob) {
                CloudBlob blob = (CloudBlob)blobItem;
                blob.delete();
                continue;
            }
            if (!(blobItem instanceof CloudBlobDirectory)) continue;
            this.deleteFolder(((CloudBlobDirectory)blobItem).getPrefix(), container);
        }
    }

    @Override
    public boolean exists(String file) {
        boolean doesExist = false;
        try {
            CloudBlockBlob blob = this.mContainer.getBlockBlobReference(file);
            doesExist = blob.exists();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return doesExist;
    }

    @Override
    public InputStream open(String file) {
        BlobInputStream is = null;
        try {
            CloudBlockBlob blob = this.mContainer.getBlockBlobReference(file);
            is = blob.openInputStream();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return is;
    }

    @Override
    public void delete(String folder) {
        try {
            this.deleteFolder(folder, this.mContainer);
        }
        catch (Exception e) {
            LOGGER.error("failed to delete directory '" + folder + "'", (Throwable)e);
        }
    }

    @Override
    public void mkdir(String folder) {
        LOGGER.info("create directory '" + folder + "'");
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(new String().getBytes());
            this.mContainer.getBlockBlobReference(folder).upload((InputStream)in, 0L);
        }
        catch (Exception e) {
            LOGGER.error("failed to create directory '" + folder + "'", (Throwable)e);
        }
    }

    @Override
    public void copyFromLocal(String localFile, String targetFolder) {
        if (localFile == null) {
            LOGGER.warn("try to copy null. ignored");
            return;
        }
        if (targetFolder == null) {
            LOGGER.debug("try to copy to nowhere. ignored");
            return;
        }
        File file = new File(localFile);
        try {
            if (!file.exists()) {
                throw new FileNotFoundException("File not found: " + localFile);
            }
            CloudBlockBlob remotefile = this.mContainer.getBlockBlobReference(targetFolder + "/" + file.getName());
            if (remotefile.exists()) {
                LOGGER.info("file already existing on remote file system");
                if (this.overwrite) {
                    LOGGER.info("overwriting the file as requested");
                }
            }
            if (!remotefile.exists() || this.overwrite) {
                LOGGER.info("copying local file " + file.getCanonicalPath() + " to Azure Storage FileSystem '" + this.mContainer.getName() + "'");
                remotefile.upload((InputStream)new FileInputStream(file), file.length());
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to copy file '" + localFile + "'", (Throwable)e);
        }
    }

    @Override
    public String getFileSystemPrefix() {
        return "wasb" + (this.useTLS ? "s" : "") + "://" + this.mContainer.getName() + "@" + this.mContainer.getStorageUri().getPrimaryUri().getHost() + "/";
    }

    private String sasConnection(String endpoint, String sasToken) {
        return "BlobEndpoint=" + endpoint + ";QueueEndpoint=" + endpoint + ";FileEndpoint=" + endpoint + ";TableEndpoint=" + endpoint + ";SharedAccessSignature=" + sasToken;
    }
}

