/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.webhcat;

import com.microsoft.azure.storage.StorageException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.List;
import org.talend.bigdata.http.HttpResponse;
import org.talend.bigdata.http.NameValuePair;
import org.talend.bigdata.http.client.entity.UrlEncodedFormEntity;
import org.talend.bigdata.http.client.fluent.Executor;
import org.talend.bigdata.http.client.fluent.Request;
import org.talend.bigdata.http.message.BasicNameValuePair;
import org.talend.bigdata.launcher.fs.FileSystem;
import org.talend.bigdata.launcher.utils.Utils;
import org.talend.bigdata.launcher.webhcat.WebHCatJob;

public class MapReduceJob
extends WebHCatJob {
    protected String mJarToExecute;
    protected String mClassToExecute;

    public MapReduceJob(FileSystem fs) {
        this.mFileSystem = fs;
    }

    @Override
    public int callWS(String libjars) throws IOException, URISyntaxException {
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient();
        }
        URI apiEndpoint = MapReduceJob.createURIBuilder(this.mWebhcatEndpoint, "/templeton/v1/mapreduce/jar").build();
        File jarToExecute = new File(this.mJarToExecute);
        ArrayList<BasicNameValuePair> form = new ArrayList<BasicNameValuePair>(3);
        form.add(new BasicNameValuePair("user.name", this.mUsername));
        form.add(new BasicNameValuePair("jar", this.mFileSystem.getFileSystemPrefix() + "/" + this.mRemoteFolder + "/file/" + jarToExecute.getName()));
        form.add(new BasicNameValuePair("class", this.mClassToExecute));
        form.add(new BasicNameValuePair("statusdir", "/" + this.mStatusFolder));
        form.add(new BasicNameValuePair("libjars", libjars));
        form.add(new BasicNameValuePair("arg", "-calledByTempleton"));
        if (this.mArgs != null && this.mArgs.size() > 0) {
            for (String mArg : this.mArgs) {
                form.add(new BasicNameValuePair("arg", mArg));
            }
        }
        UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity((List<? extends NameValuePair>)form);
        Request request = Request.Post(apiEndpoint).body(urlEncodedFormEntity);
        Executor executor = Executor.newInstance(this.httpClient).authPreemptive(apiEndpoint.getAuthority());
        HttpResponse response = executor.execute(request).returnResponse();
        return response.getStatusLine().getStatusCode();
    }

    @Override
    public String sendFiles() throws IOException, InvalidKeyException, URISyntaxException, StorageException {
        return Utils.sendFiles(this.mRemoteFolder, this.mStatusFolder, this.mFileSystem, this.mJarToExecute, this.mLibjars);
    }

    public void setClassToExecute(String clazz) {
        this.mClassToExecute = clazz;
    }

    public void setJarToExecute(String jar) {
        this.mJarToExecute = jar;
    }
}

