/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.webhcat;

import com.microsoft.azure.storage.StorageException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.http.HttpHost;
import org.talend.bigdata.http.HttpRequestInterceptor;
import org.talend.bigdata.http.auth.AuthScope;
import org.talend.bigdata.http.client.utils.URIBuilder;
import org.talend.bigdata.http.impl.client.BasicCredentialsProvider;
import org.talend.bigdata.http.impl.client.CloseableHttpClient;
import org.talend.bigdata.http.impl.client.HttpClientBuilder;
import org.talend.bigdata.http.message.BasicHeader;
import org.talend.bigdata.launcher.Job;
import org.talend.bigdata.launcher.fs.FileSystem;

public abstract class WebHCatJob
extends Job {
    protected FileSystem mFileSystem;
    protected String mStatusFolder;
    protected String mRemoteFolder;
    protected String mUserAgent;
    protected String mWebhcatEndpoint;
    protected CloseableHttpClient httpClient;
    protected String mLibjars;
    protected String mUsername;
    protected List<String> mArgs;
    protected static final Logger LOGGER = LoggerFactory.getLogger(WebHCatJob.class);

    protected CloseableHttpClient createHttpClient() throws URISyntaxException {
        HttpRequestInterceptor logInterceptor = (request, context) -> {
            LOGGER.info("###");
            LOGGER.info(request.getRequestLine().toString());
            LOGGER.debug("");
            Arrays.stream(request.getAllHeaders()).map(Object::toString).forEach(arg_0 -> ((Logger)LOGGER).debug(arg_0));
            LOGGER.debug("");
            LOGGER.info("###");
        };
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(HttpHost.create(new URI(this.mWebhcatEndpoint).getAuthority())), this.mCredentials);
        return HttpClientBuilder.create().addInterceptorLast(logInterceptor).disableContentCompression().setUserAgent(this.mUserAgent).setDefaultHeaders(Arrays.asList(new BasicHeader("Accept", "*/*"), new BasicHeader("Cache-Control", "no-cache"), new BasicHeader("Pragma", "no-cache"))).setDefaultCredentialsProvider(credentialsProvider).build();
    }

    protected static URIBuilder createURIBuilder(String endpoint, String apiPath) throws URISyntaxException {
        URI baseURI = new URI(endpoint);
        URIBuilder builder = new URIBuilder(endpoint);
        String path = baseURI.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 2);
        }
        if (apiPath.startsWith("/")) {
            apiPath = apiPath.substring(1);
        }
        builder.setPath(path + "/" + apiPath);
        return builder;
    }

    public abstract String sendFiles() throws IOException, InvalidKeyException, URISyntaxException, StorageException;

    public abstract int callWS(String var1) throws IOException, URISyntaxException;

    public Integer execute() throws IOException, InterruptedException, InvalidKeyException, URISyntaxException, StorageException {
        String status = this.mStatusFolder;
        String exitCode = status + "/exit";
        final String stderr = status + "/stderr";
        final FileSystem fs = this.mFileSystem;
        class StreamStrErr
        implements Runnable {
            StreamStrErr() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStream is = null;
                BufferedReader d = null;
                try {
                    String s;
                    while (!fs.exists(stderr)) {
                        Thread.sleep(2000L);
                    }
                    is = fs.open(stderr);
                    d = new BufferedReader(new InputStreamReader(is));
                    while ((s = d.readLine()) == null) {
                        if (is != null) {
                            is.close();
                        }
                        if (d != null) {
                            d.close();
                        }
                        is = fs.open(stderr);
                        d = new BufferedReader(new InputStreamReader(is));
                    }
                    do {
                        System.err.println(s);
                    } while ((s = d.readLine()) != null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (d != null) {
                        try {
                            d.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        StreamStrErr stream = new StreamStrErr();
        stream.run();
        while (!fs.exists(exitCode)) {
            Thread.sleep(2000L);
        }
        InputStream is = fs.open(exitCode);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String r = br.readLine();
        try {
            return Integer.parseInt(r);
        }
        catch (Exception e) {
            return 1;
        }
    }

    public InputStream getStdOut() throws InvalidKeyException, URISyntaxException, StorageException {
        String stdout = this.mStatusFolder + "/stdout";
        if (!this.mFileSystem.exists(stdout)) {
            return null;
        }
        return this.mFileSystem.open(stdout);
    }

    public void setStatusFolder(String folder) {
        this.mStatusFolder = folder;
    }

    public void setRemoteFolder(String folder) {
        this.mRemoteFolder = folder;
    }

    public void setLibJars(String libjars) {
        this.mLibjars = libjars;
    }

    public void setArgs(List<String> args) {
        this.mArgs = args;
    }

    public void setWebhcatEndpoint(String endpoint) {
        this.mWebhcatEndpoint = endpoint;
    }

    public String getStatusFolder() {
        return this.mStatusFolder;
    }

    public String getRemoteFolder() {
        return this.mRemoteFolder;
    }

    public void setUsername(String username) {
        this.mUsername = username;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public FileSystem getFileSystem() {
        return this.mFileSystem;
    }
}

