/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.jobserver;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.talend.bigdata.launcher.EndpointDescriptor;

class JobServerRequest
implements EndpointDescriptor {
    HttpClient httpClient;
    Request request;
    URI uri;

    private static JobServerRequest Get(URI uri) {
        return new JobServerRequest(Request.Get((URI)uri), uri);
    }

    private static JobServerRequest Post(URI uri, File file) {
        return new JobServerRequest(Request.Post((URI)uri).bodyFile(file, ContentType.APPLICATION_FORM_URLENCODED), uri);
    }

    public static JobServerRequest sendJar(String rootEndpoint, String appName, File jarFile) throws URISyntaxException {
        String apiPath = "/sparkjobserver/jars/" + appName;
        URI uri = JobServerRequest.createURIBuilder(rootEndpoint, apiPath).build();
        return JobServerRequest.Post(uri, jarFile);
    }

    public static JobServerRequest run(String rootEndpoint, String appName, String mainClass, String body) throws URISyntaxException {
        String apiPath = "/sparkjobserver/jobs";
        URI uri = JobServerRequest.createURIBuilder(rootEndpoint, apiPath).setParameter("appName", appName).setParameter("classPath", mainClass).build();
        Request request = Request.Post((URI)uri).bodyString(body, ContentType.APPLICATION_FORM_URLENCODED);
        return new JobServerRequest(request, uri);
    }

    public static JobServerRequest state(String rootEndpoint, String appName, String mainClass, String jobId) throws URISyntaxException {
        String apiPath = "/sparkjobserver/jobs/" + jobId;
        URI uri = JobServerRequest.createURIBuilder(rootEndpoint, apiPath).build();
        return JobServerRequest.Get(uri);
    }

    private static URIBuilder createURIBuilder(String endpoint, String apiPath) throws URISyntaxException {
        URI baseURI = new URI(endpoint);
        URIBuilder builder = new URIBuilder(endpoint);
        String path = baseURI.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 2);
        }
        if (apiPath.startsWith("/")) {
            apiPath = apiPath.substring(1);
        }
        builder.setPath(path + "/" + apiPath);
        return builder;
    }

    private JobServerRequest(Request request, URI uri) {
        this.request = request;
        this.uri = uri;
    }

    public JobServerRequest withHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public HttpResponse executeWith(Executor executor) throws IOException {
        return executor.execute(this.request).returnResponse();
    }

    public HttpResponse execute() throws IOException {
        Executor executor = Executor.newInstance((HttpClient)this.httpClient).authPreemptive(this.uri.getAuthority());
        return executor.execute(this.request).returnResponse();
    }

    public String getFullEndpoint() {
        return this.uri.toString();
    }
}

