/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.jobserver;

import java.net.URISyntaxException;
import java.util.Map;
import org.talend.bigdata.launcher.jobserver.JobServerJob;
import org.talend.bigdata.launcher.security.Credentials;

public class SparkBatchJob
extends JobServerJob {
    private SparkBatchJob(String appName, String jarToExecute, String classToExecute, String endpoint, Credentials credentials, Map<String, String> conf, Map<String, String> tuningConf) throws URISyntaxException {
        super(appName, jarToExecute, classToExecute, endpoint, credentials, conf, tuningConf);
    }

    public static class Builder {
        private String mJarToExecute;
        private String mClassToExecute;
        private String mAppName;
        private String mEndpoint;
        private Credentials mCredentials;
        private Map<String, String> mConf;
        private Map<String, String> mTuningConf;

        public Builder withAppName(String appName) {
            this.mAppName = appName;
            return this;
        }

        public Builder withJarToExecute(String jarToExecute) {
            this.mJarToExecute = jarToExecute;
            return this;
        }

        public Builder withClassToExecute(String classToExecute) {
            this.mClassToExecute = classToExecute;
            return this;
        }

        public Builder withEndpoint(String endpoint) {
            this.mEndpoint = endpoint;
            return this;
        }

        public Builder withCredentials(Credentials credentials) {
            this.mCredentials = credentials;
            return this;
        }

        public Builder withConf(Map<String, String> conf) {
            this.mConf = conf;
            return this;
        }

        public Builder withTuningConf(Map<String, String> conf) {
            this.mTuningConf = conf;
            return this;
        }

        public SparkBatchJob build() throws URISyntaxException {
            return new SparkBatchJob(this.mAppName, this.mJarToExecute, this.mClassToExecute, this.mEndpoint, this.mCredentials, this.mConf, this.mTuningConf);
        }
    }
}

