/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.knox.gateway.shell.BasicResponse;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.hdfs.Hdfs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.launcher.fs.FileSystem;
import org.talend.bigdata.launcher.utils.Utils;

public class KnoxWebHDFS
extends FileSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnoxWebHDFS.class);
    private static final int DEFAULT_TIMEOUT = 120;
    private static final int REPEAT = 3;
    private final String user;
    private final String password;
    private final String endpoint;
    private final String hdfsHost;
    private final int port;
    private final int timeout;
    private KnoxSession session;

    public KnoxWebHDFS(String user, String password, String endpoint) throws URISyntaxException {
        this(user, password, endpoint, 8020, 120);
    }

    public KnoxWebHDFS(String user, String password, String endpoint, int timeout) throws URISyntaxException {
        this(user, password, endpoint, 8020, timeout);
    }

    public KnoxWebHDFS(String user, String password, String endpoint, int port, int timeout) throws URISyntaxException {
        this.user = user;
        this.password = password;
        endpoint = Utils.removeLastSlash((String)endpoint);
        endpoint = Utils.removeAPIend((String)endpoint);
        this.endpoint = Utils.removeLastSlash((String)endpoint);
        this.hdfsHost = endpoint.replace("https://", "").split("/")[0];
        this.port = port;
        this.session = KnoxSession.login((String)this.endpoint, (String)this.user, (String)this.password);
        this.timeout = timeout;
    }

    public boolean exists(String file) {
        boolean doesExist = false;
        try (BasicResponse response = (BasicResponse)Hdfs.status((KnoxSession)this.session).file(Utils.appendFirstSlash((String)file)).now();){
            LOGGER.debug("{} - status: {}", (Object)response.getString(), (Object)response.getStatusCode());
            if (200 == response.getStatusCode()) {
                doesExist = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
        return doesExist;
    }

    public BasicResponse checkService() {
        return (BasicResponse)Hdfs.status((KnoxSession)this.session).file("/").now();
    }

    public InputStream open(String file) {
        InputStream is = null;
        return is;
    }

    public void delete(String folder) {
        try (BasicResponse response = (BasicResponse)Hdfs.rm((KnoxSession)this.session).file(folder).recursive().now();){
            LOGGER.debug("{} - status: {}", (Object)response.getString(), (Object)response.getStatusCode());
        }
        catch (Exception e) {
            LOGGER.error("failed to delete directory '" + folder + "'", (Throwable)e);
        }
    }

    public void mkdir(String folder) {
        LOGGER.info("create directory '" + folder + "'");
        try (BasicResponse response = (BasicResponse)Hdfs.mkdir((KnoxSession)this.session).dir(Utils.appendFirstSlash((String)folder)).now();){
            LOGGER.debug("{} - status: {}", (Object)response.getString(), (Object)response.getStatusCode());
        }
        catch (Exception e) {
            LOGGER.error("failed to create directory '" + folder + "'", (Throwable)e);
        }
    }

    public void copyFromLocal(String localFile, String targetFolder) {
        block13: {
            if (localFile == null) {
                LOGGER.warn("try to copy null. ignored");
                return;
            }
            if (targetFolder == null) {
                LOGGER.warn("try to copy to nowhere. ignored");
                return;
            }
            Path path = Paths.get(localFile, new String[0]);
            try {
                if (!Files.exists(path, new LinkOption[0])) {
                    throw new FileNotFoundException("File not found: " + localFile);
                }
                String to = Utils.appendFirstSlash((String)targetFolder) + "/" + path.getFileName();
                boolean exist = this.exists(to);
                if (exist) {
                    LOGGER.warn("{} file already existing on remote file system", (Object)to);
                    if (this.overwrite) {
                        LOGGER.warn("Overwriting the file as requested");
                    }
                }
                if (exist && !this.overwrite) break block13;
                LOGGER.info("copying local file " + localFile + " to WebHDFS path " + targetFolder);
                try (BasicResponse response = this.putFile(path, to, new AtomicInteger(3));){
                    LOGGER.debug("{} - status: {}", (Object)response.getString(), (Object)response.getStatusCode());
                }
            }
            catch (Exception e) {
                LOGGER.error("failed to copy file '" + localFile + "'", (Throwable)e);
            }
        }
    }

    private BasicResponse putFile(Path from, String to, AtomicInteger number) throws Exception {
        LOGGER.debug("timeout=: {}", (Object)this.timeout);
        try {
            return (BasicResponse)Hdfs.put((KnoxSession)this.session).overwrite(true).file(from.toString()).to(to).later().get(this.timeout, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            this.relogin();
            if (number.decrementAndGet() == 0) {
                throw timeoutException;
            }
            return this.putFile(from, to, number);
        }
    }

    private void relogin() throws IOException, InterruptedException, URISyntaxException {
        this.session.shutdown();
        this.session = KnoxSession.login((String)this.endpoint, (String)this.user, (String)this.password);
    }

    public String getFileSystemPrefix() {
        return "hdfs://";
    }
}

