/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.fs;

import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.knox.gateway.shell.BasicResponse;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.hdfs.Hdfs;
import org.talend.bigdata.launcher.fs.HdfsOperations;
import org.talend.bigdata.launcher.utils.Utils;

public class DefaultHdfsOperations
implements HdfsOperations {
    @Override
    public BasicResponse status(KnoxSession session, String file) {
        return (BasicResponse)Hdfs.status((KnoxSession)session).file(Utils.appendFirstSlash((String)file)).now();
    }

    @Override
    public BasicResponse put(KnoxSession session, Path localFile, String remotePath, int timeout) throws ExecutionException, InterruptedException, TimeoutException {
        return (BasicResponse)Hdfs.put((KnoxSession)session).overwrite(true).file(localFile.toString()).to(remotePath).later().get(timeout, TimeUnit.SECONDS);
    }

    @Override
    public BasicResponse remove(KnoxSession session, String folder) {
        return (BasicResponse)Hdfs.rm((KnoxSession)session).file(folder).recursive().now();
    }

    @Override
    public BasicResponse mkdir(KnoxSession session, String folder) {
        return (BasicResponse)Hdfs.mkdir((KnoxSession)session).dir(Utils.appendFirstSlash((String)folder)).now();
    }

    @Override
    public BasicResponse ls(KnoxSession session, String folder) {
        return (BasicResponse)Hdfs.ls((KnoxSession)session).dir(folder).now();
    }

    @Override
    public BasicResponse get(KnoxSession session, String remotePath, Path localFile, int timeout) throws ExecutionException, InterruptedException, TimeoutException {
        return (BasicResponse)Hdfs.get((KnoxSession)session).from(remotePath).file(localFile.toString()).later().get(timeout, TimeUnit.SECONDS);
    }

    @Override
    public BasicResponse rename(KnoxSession session, String source, String destination) {
        return (BasicResponse)Hdfs.rename((KnoxSession)session).file(source).to(destination).now();
    }
}

