/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.fs;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.knox.gateway.shell.BasicResponse;
import org.apache.knox.gateway.shell.KnoxSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.launcher.fs.DefaultHdfsOperations;
import org.talend.bigdata.launcher.fs.FileStatus;
import org.talend.bigdata.launcher.fs.FileSystem;
import org.talend.bigdata.launcher.fs.HdfsOperations;
import org.talend.bigdata.launcher.utils.Utils;

public class KnoxWebHDFS
extends FileSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnoxWebHDFS.class);
    private static final int DEFAULT_TIMEOUT = 120;
    private static final int REPEAT = 3;
    private static final String FAILED_TO_COPY_FILE_MSG = "failed to copy file '";
    private static final String HDFS_SEPARATOR = "/";
    private static final String FILE_TYPE_DIRECTORY = "DIRECTORY";
    private final String user;
    private final String password;
    private final String endpoint;
    private final int timeout;
    private KnoxSession session;
    private final HdfsOperations hdfsOperations;

    public KnoxWebHDFS(String user, String password, String endpoint) throws URISyntaxException {
        this(user, password, endpoint, 120);
    }

    public KnoxWebHDFS(String user, String password, String endpoint, int timeout) throws URISyntaxException {
        this(user, password, endpoint, timeout, new DefaultHdfsOperations());
    }

    KnoxWebHDFS(String user, String password, String endpoint, int timeout, HdfsOperations hdfsOperations) throws URISyntaxException {
        this.user = user;
        this.password = password;
        endpoint = Utils.removeLastSlash((String)endpoint);
        endpoint = Utils.removeAPIend((String)endpoint);
        this.endpoint = Utils.removeLastSlash((String)endpoint);
        this.session = KnoxSession.login((String)this.endpoint, (String)this.user, (String)this.password);
        this.timeout = timeout;
        this.hdfsOperations = hdfsOperations;
    }

    KnoxWebHDFS(String user, String password, String endpoint, int timeout, HdfsOperations hdfsOperations, KnoxSession session) {
        this.user = user;
        this.password = password;
        endpoint = Utils.removeLastSlash((String)endpoint);
        endpoint = Utils.removeAPIend((String)endpoint);
        this.endpoint = Utils.removeLastSlash((String)endpoint);
        this.session = session;
        this.timeout = timeout;
        this.hdfsOperations = hdfsOperations;
    }

    public boolean exists(String file) {
        boolean doesExist = false;
        try (BasicResponse response = this.hdfsOperations.status(this.session, file);){
            this.logDebugResponse(response);
            if (200 == response.getStatusCode()) {
                doesExist = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
        return doesExist;
    }

    public InputStream open(String file) {
        InputStream is = null;
        return is;
    }

    public void delete(String folder) {
        try (BasicResponse response = this.hdfsOperations.remove(this.session, folder);){
            this.logDebugResponse(response);
        }
        catch (Exception e) {
            LOGGER.error("failed to delete directory '" + folder + "'", (Throwable)e);
        }
    }

    public boolean deleteAndReturnStatus(String folder) {
        boolean bl;
        block8: {
            BasicResponse response = this.hdfsOperations.remove(this.session, folder);
            try {
                this.logDebugResponse(response);
                boolean bl2 = bl = response.getStatusCode() == 200;
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("failed to delete directory '" + folder + "'", (Throwable)e);
                    return false;
                }
            }
            response.close();
        }
        return bl;
    }

    public void mkdir(String folder) {
        LOGGER.info("create directory '" + folder + "'");
        try (BasicResponse response = this.hdfsOperations.mkdir(this.session, folder);){
            this.logDebugResponse(response);
        }
        catch (Exception e) {
            LOGGER.error("failed to create directory '{}'", (Object)folder, (Object)e);
        }
    }

    public void copyFromLocal(String localFile, String targetFolder, boolean overwrite) throws IOException {
        this.overwrite = overwrite;
        this.copyLocalFileToRemoteWithException(localFile, targetFolder);
    }

    private void copyLocalFileToRemoteWithException(String localFile, String targetFolder) throws IOException {
        this.validateLocalFileExists(localFile);
        String remotePath = this.buildRemotePath(localFile, targetFolder);
        this.handleRemoteFileConflict(remotePath);
        this.uploadFile(localFile, remotePath);
    }

    private void validateLocalFileExists(String localFile) throws FileNotFoundException {
        if (!Files.exists(Paths.get(localFile, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException("File not found: " + localFile);
        }
    }

    private String buildRemotePath(String localFile, String targetFolder) {
        String fileName = Paths.get(localFile, new String[0]).getFileName().toString();
        return Utils.appendFirstSlash((String)targetFolder) + HDFS_SEPARATOR + fileName;
    }

    private void handleRemoteFileConflict(String remotePath) throws IOException {
        if (!this.exists(remotePath)) {
            return;
        }
        LOGGER.warn("{} file already existing on remote file system", (Object)remotePath);
        if (!this.overwrite) {
            throw new IOException("File already exists and overwrite is set to false: " + remotePath);
        }
        LOGGER.warn("Overwriting the file as requested");
    }

    private void uploadFile(String localFile, String remotePath) throws IOException {
        LOGGER.info("copying local file {} to WebHDFS path {}", (Object)localFile, (Object)remotePath);
        try (BasicResponse response = this.putFile(Paths.get(localFile, new String[0]), remotePath, new AtomicInteger(3));){
            this.logDebugResponse(response);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void copyFromLocal(String localFile, String targetFolder) {
        if (localFile == null) {
            LOGGER.warn("try to copy null. ignored");
            return;
        }
        if (targetFolder == null) {
            LOGGER.warn("try to copy to nowhere. ignored");
            return;
        }
        try {
            this.copyLocalFileToRemoteWithException(localFile, targetFolder);
        }
        catch (Exception e) {
            LOGGER.error(FAILED_TO_COPY_FILE_MSG + localFile + "'", (Throwable)e);
        }
    }

    public void copyFromLocalFile(String localFile, String targetFile, boolean overwrite) throws IOException {
        if (localFile == null) {
            throw new IllegalArgumentException("localFile cannot be null");
        }
        if (targetFile == null) {
            throw new IllegalArgumentException("targetFile cannot be null");
        }
        this.overwrite = overwrite;
        this.validateLocalFileExists(localFile);
        this.handleRemoteFileConflict(targetFile);
        this.uploadFile(localFile, targetFile);
    }

    public boolean copyToLocal(String remoteFile, String localFile, boolean overwrite) throws IOException {
        return this.copyToLocal(remoteFile, localFile, overwrite, false, false);
    }

    public boolean copyToLocal(String remoteFile, String localFile, boolean overwrite, boolean copyDirectory) throws IOException {
        return this.copyToLocal(remoteFile, localFile, overwrite, false, copyDirectory);
    }

    public boolean copyToLocal(String remoteFile, String localFile, boolean overwrite, boolean append, boolean copyDirectory) throws IOException {
        if (remoteFile == null) {
            throw new IllegalArgumentException("remoteFile cannot be null");
        }
        if (localFile == null) {
            throw new IllegalArgumentException("localFile cannot be null");
        }
        this.validateRemoteFileExists(remoteFile);
        boolean srcIsDir = this.isRemoteDirectory(remoteFile);
        if (srcIsDir && !copyDirectory) {
            LOGGER.warn("Remote path is a directory but copyDirectory is false: {}", (Object)remoteFile);
            return false;
        }
        File dst = this.checkDest(srcIsDir, new File(localFile), overwrite);
        if (dst == null) {
            return false;
        }
        return srcIsDir ? this.copyRemoteDirectoryToLocal(remoteFile, dst, overwrite, append, copyDirectory) : this.copySingleFileToLocal(remoteFile, dst);
    }

    private boolean copyRemoteDirectoryToLocal(String remoteDir, File localDir, boolean overwrite, boolean append, boolean copyDirectory) {
        org.apache.hadoop.fs.FileStatus[] contents;
        if (!localDir.exists() && !localDir.mkdirs()) {
            LOGGER.error("Failed to create local directory: {}", (Object)localDir.getAbsolutePath());
            return false;
        }
        for (org.apache.hadoop.fs.FileStatus fileStatus : contents = this.listStatus(new Path(remoteDir))) {
            String remotePath = Utils.appendFirstSlash((String)remoteDir) + HDFS_SEPARATOR + fileStatus.getPath().getName();
            String localPath = localDir.getAbsolutePath() + File.separator + fileStatus.getPath().getName();
            try {
                if (this.copyToLocal(remotePath, localPath, overwrite, append, copyDirectory)) continue;
                LOGGER.warn("Failed to copy: {}", (Object)remotePath);
                return false;
            }
            catch (IOException e) {
                LOGGER.error("Error copying {}: {}", (Object)remotePath, (Object)e.getMessage());
                return false;
            }
        }
        return true;
    }

    private boolean copySingleFileToLocal(String remoteFile, File localFile) throws IOException {
        try {
            this.downloadFileToLocalFile(remoteFile, localFile);
            return true;
        }
        catch (Exception e) {
            throw new IOException(FAILED_TO_COPY_FILE_MSG + remoteFile + "'", e);
        }
    }

    private File checkDest(boolean srcIsDir, File dst, boolean overwrite) throws IOException {
        if (dst.exists()) {
            if (!overwrite) {
                LOGGER.warn("Destination already exists and overwrite is false: {}", (Object)dst.getAbsolutePath());
                return null;
            }
            if (dst.isFile() && srcIsDir) {
                throw new IOException("Cannot copy directory to file: " + dst.getAbsolutePath());
            }
        }
        return dst;
    }

    private void downloadFileToLocalFile(String remoteFile, File localFile) throws Exception {
        LOGGER.info("copying remote file {} to local file {}", (Object)remoteFile, (Object)localFile.getAbsolutePath());
        try (BasicResponse response = this.getFile(remoteFile, localFile.toPath(), new AtomicInteger(3));){
            this.logDebugResponse(response);
        }
    }

    public boolean isRemoteDirectory(String remoteFile) {
        List<FileStatus> contents = this.ls(remoteFile);
        if (contents == null) {
            return false;
        }
        if (contents.isEmpty()) {
            return true;
        }
        if (contents.size() == 1) {
            FileStatus status = contents.get(0);
            return !"FILE".equalsIgnoreCase(status.getType()) || !"".equals(status.getPathSuffix());
        }
        return true;
    }

    private void validateRemoteFileExists(String remoteFile) throws FileNotFoundException {
        if (!this.exists(remoteFile)) {
            throw new FileNotFoundException("Remote file not found: " + remoteFile);
        }
    }

    private BasicResponse putFile(java.nio.file.Path from, String to, AtomicInteger number) throws Exception {
        LOGGER.debug("timeout=: {}", (Object)this.timeout);
        try {
            return this.hdfsOperations.put(this.session, from, to, this.timeout);
        }
        catch (TimeoutException timeoutException) {
            this.relogin();
            if (number.decrementAndGet() == 0) {
                throw timeoutException;
            }
            return this.putFile(from, to, number);
        }
    }

    private BasicResponse getFile(String from, java.nio.file.Path to, AtomicInteger number) throws Exception {
        LOGGER.debug("timeout=: {}", (Object)this.timeout);
        try {
            return this.hdfsOperations.get(this.session, from, to, this.timeout);
        }
        catch (TimeoutException timeoutException) {
            this.relogin();
            if (number.decrementAndGet() == 0) {
                throw timeoutException;
            }
            return this.getFile(from, to, number);
        }
    }

    private void relogin() throws IOException, InterruptedException, URISyntaxException {
        this.session.shutdown();
        this.session = KnoxSession.login((String)this.endpoint, (String)this.user, (String)this.password);
    }

    public String getFileSystemPrefix() {
        return "hdfs://";
    }

    private void logDebugResponse(BasicResponse response) throws IOException {
        LOGGER.debug("{} - status: {}", (Object)response.getString(), (Object)response.getStatusCode());
    }

    public List<FileStatus> ls(String folder) {
        ArrayList<FileStatus> fileStatuses = new ArrayList<FileStatus>();
        try (BasicResponse response = this.hdfsOperations.ls(this.session, folder);){
            this.logDebugResponse(response);
            String text = response.getString();
            LOGGER.info("ls of folder '{}':\n{}", (Object)folder, (Object)text);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = mapper.readTree(text);
            JsonNode fileStatusArray = root.path("FileStatuses").path("FileStatus");
            for (JsonNode fileStatusNode : fileStatusArray) {
                FileStatus fileStatus = (FileStatus)mapper.treeToValue((TreeNode)fileStatusNode, FileStatus.class);
                fileStatuses.add(fileStatus);
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to ls directory '" + folder + "'", (Throwable)e);
        }
        return fileStatuses;
    }

    public Path[] lsPaths(String folder) {
        List<FileStatus> fileStatuses = this.ls(folder);
        ArrayList<Path> paths = new ArrayList<Path>();
        for (FileStatus status : fileStatuses) {
            paths.add(new Path(folder + HDFS_SEPARATOR + status.getPathSuffix()));
        }
        return paths.toArray(new Path[0]);
    }

    public boolean rename(String source, String destination) throws IOException {
        boolean bl;
        block10: {
            BasicResponse response = this.hdfsOperations.rename(this.session, source, destination);
            try {
                boolean success;
                this.logDebugResponse(response);
                boolean bl2 = success = response.getStatusCode() == 200;
                if (success) {
                    LOGGER.info("Successfully renamed '{}' to '{}'", (Object)source, (Object)destination);
                } else {
                    LOGGER.warn("Failed to rename '{}' to '{}': status code {}", new Object[]{source, destination, response.getStatusCode()});
                }
                bl = success;
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException("failed to rename '" + source + "' to '" + destination + "'", e);
                }
            }
            response.close();
        }
        return bl;
    }

    public org.apache.hadoop.fs.FileStatus[] listStatus(Path path) {
        String folder = path.toUri().getPath();
        List<FileStatus> fileStatuses = this.ls(folder);
        ArrayList<org.apache.hadoop.fs.FileStatus> hadoopStatuses = new ArrayList<org.apache.hadoop.fs.FileStatus>();
        for (FileStatus status : fileStatuses) {
            Path filePath = new Path(folder + HDFS_SEPARATOR + status.getPathSuffix());
            boolean isDir = FILE_TYPE_DIRECTORY.equals(status.getType());
            org.apache.hadoop.fs.FileStatus hadoopStatus = new org.apache.hadoop.fs.FileStatus(status.getLength(), isDir, status.getReplication(), status.getBlockSize(), status.getModificationTime(), status.getAccessTime(), null, status.getOwner(), status.getGroup(), filePath);
            hadoopStatuses.add(hadoopStatus);
        }
        return hadoopStatuses.toArray(new org.apache.hadoop.fs.FileStatus[0]);
    }

    public org.apache.hadoop.fs.FileStatus[] listStatus(Path path, PathFilter filter) {
        org.apache.hadoop.fs.FileStatus[] allStatuses = this.listStatus(path);
        if (filter == null) {
            return allStatuses;
        }
        ArrayList<org.apache.hadoop.fs.FileStatus> filteredStatuses = new ArrayList<org.apache.hadoop.fs.FileStatus>();
        for (org.apache.hadoop.fs.FileStatus status : allStatuses) {
            if (!filter.accept(status.getPath())) continue;
            filteredStatuses.add(status);
        }
        return filteredStatuses.toArray(new org.apache.hadoop.fs.FileStatus[0]);
    }

    public org.apache.hadoop.fs.FileStatus getFileStatus(Path path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        String pathStr = path.toUri().getPath();
        if (!this.exists(pathStr)) {
            throw new FileNotFoundException("File not found: " + pathStr);
        }
        try {
            Path parentPath = new Path(pathStr).getParent();
            String fileName = new Path(pathStr).getName();
            if (parentPath == null) {
                throw new FileNotFoundException("Cannot determine parent path for: " + pathStr);
            }
            String parentPathStr = parentPath.toUri().getPath();
            List<FileStatus> statuses = this.ls(parentPathStr);
            for (FileStatus status : statuses) {
                if (!status.getPathSuffix().equals(fileName)) continue;
                boolean isDir = FILE_TYPE_DIRECTORY.equals(status.getType());
                return new org.apache.hadoop.fs.FileStatus(status.getLength(), isDir, status.getReplication(), status.getBlockSize(), status.getModificationTime(), status.getAccessTime(), null, status.getOwner(), status.getGroup(), path);
            }
            throw new FileNotFoundException("File not found in parent directory listing: " + pathStr);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("failed to get file status for '" + pathStr + "'", e);
        }
    }
}

