/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.livy;

import java.util.Base64;
import org.apache.http.Header;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.launcher.AbstractSparkJobRequest;

class SparkJobRequest
extends AbstractSparkJobRequest {
    private static final String BATCHES_PATH = "/batches";
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkJobRequest.class);

    private SparkJobRequest(Request request, String rootEndpoint, String apiPath) {
        super(request, rootEndpoint, apiPath);
    }

    private static SparkJobRequest Get(String rootEndpoint, String apiPath) {
        String fullEndpoint = AbstractSparkJobRequest.buildFullEndpoint((String)rootEndpoint, (String)apiPath);
        return new SparkJobRequest(Request.Get((String)fullEndpoint), rootEndpoint, apiPath);
    }

    private static SparkJobRequest Delete(String rootEndpoint, String apiPath, String username) {
        String fullEndpoint = AbstractSparkJobRequest.buildFullEndpoint((String)rootEndpoint, (String)apiPath);
        return new SparkJobRequest(Request.Delete((String)fullEndpoint).addHeader((Header)new BasicHeader("X-Requested-By", username)), rootEndpoint, apiPath);
    }

    private static SparkJobRequest Post(String rootEndpoint, String apiPath, String body, String username, String password) {
        String auth = Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
        String fullEndpoint = AbstractSparkJobRequest.buildFullEndpoint((String)rootEndpoint, (String)apiPath);
        LOGGER.debug("Full endpoint to call: {} Authorization: ", (Object)fullEndpoint, (Object)auth);
        return new SparkJobRequest(Request.Post((String)fullEndpoint).addHeader((Header)new BasicHeader("X-Requested-By", username)).bodyString(body, ContentType.APPLICATION_JSON), rootEndpoint, apiPath);
    }

    public static SparkJobRequest run(String rootEndpoint, String body, String username, String password, String livyVersion) {
        return SparkJobRequest.Post(rootEndpoint, livyVersion + BATCHES_PATH, body, username, password);
    }

    public static SparkJobRequest log(String rootEndpoint, Long jobId, String livyVersion) {
        LOGGER.info("<<<<<<<<<<LOG: endpoint = {}/{}{}/{}/log", new Object[]{rootEndpoint, livyVersion, BATCHES_PATH, jobId});
        return SparkJobRequest.Get(rootEndpoint, livyVersion + BATCHES_PATH + "/" + jobId + "/log");
    }

    public static SparkJobRequest state(String rootEndpoint, Long jobId, String livyVersion) {
        LOGGER.info("<<<<<<<<<<STATE: endpoint = {}/{}{}/{}/state", new Object[]{rootEndpoint, livyVersion, BATCHES_PATH, jobId});
        return SparkJobRequest.Get(rootEndpoint, livyVersion + BATCHES_PATH + "/" + jobId + "/state");
    }

    public static SparkJobRequest cancel(String rootEndpoint, Long jobId, String username, String livyVersion) {
        LOGGER.info("<<<<<<<<<<CANCEL: endpoint = {}/{}{}/{}", new Object[]{rootEndpoint, livyVersion, BATCHES_PATH, jobId});
        return SparkJobRequest.Delete(rootEndpoint, livyVersion + BATCHES_PATH + "/" + jobId, username);
    }
}

