/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.qubole;

import com.qubole.qds.sdk.java.api.PigCommandBuilder;
import com.qubole.qds.sdk.java.api.ShellCommandBuilder;
import com.qubole.qds.sdk.java.api.SparkCommandBuilder;
import com.qubole.qds.sdk.java.client.DefaultQdsConfiguration;
import com.qubole.qds.sdk.java.client.QdsClient;
import com.qubole.qds.sdk.java.client.QdsClientFactory;
import com.qubole.qds.sdk.java.client.QdsConfiguration;
import com.qubole.qds.sdk.java.client.ResultLatch;
import com.qubole.qds.sdk.java.entities.CommandResponse;
import com.qubole.qds.sdk.java.entities.ResultValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QuboleClient
implements AutoCloseable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected QdsClient client;

    QuboleClient(String apiKey, String apiEndpoint) {
        DefaultQdsConfiguration conf = new DefaultQdsConfiguration(apiEndpoint, apiKey);
        this.client = QdsClientFactory.newClient((QdsConfiguration)conf);
    }

    public CommandResponse execShellAsync(String command) throws Exception {
        return (CommandResponse)this.getShellBuilder().inline(command).invoke().get();
    }

    public CommandResponse execShellAsync(String command, String clusterLabel) throws Exception {
        return (CommandResponse)this.getShellBuilder().inline(command).clusterLabel(clusterLabel).invoke().get();
    }

    public ResultValue execShell(String command) throws Exception {
        ResultLatch latch = new ResultLatch(this.client, this.execShellAsync(command).getId());
        return latch.awaitResult();
    }

    public ResultValue execShell(String command, String clusterLabel) throws Exception {
        ResultLatch latch = new ResultLatch(this.client, this.execShellAsync(command, clusterLabel).getId());
        return latch.awaitResult();
    }

    public String waitForResults(String queryId) throws Exception {
        ResultLatch latch = new ResultLatch(this.client, queryId);
        return latch.awaitResult().getResults();
    }

    public ShutdownHook getShutdownHook(String queryId) {
        return new ShutdownHook(queryId);
    }

    protected ShellCommandBuilder getShellBuilder() {
        return this.client.command().shell();
    }

    protected SparkCommandBuilder getSparkBuilder() {
        return this.client.command().spark();
    }

    protected PigCommandBuilder getPigBuilder() {
        return this.client.command().pig();
    }

    public void cancel(String queryId) {
        this.client.command().cancel(queryId);
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    private class ShutdownHook
    extends Thread {
        private String queryId;

        ShutdownHook(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public void run() {
            QuboleClient.this.logger.info("terminating job by shutdown hook");
            QuboleClient.this.cancel(this.queryId);
        }
    }
}

