/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.qubole;

import com.qubole.qds.sdk.java.api.HiveCommandBuilder;
import com.qubole.qds.sdk.java.client.ResultLatch;
import com.qubole.qds.sdk.java.entities.CommandResponse;
import com.qubole.qds.sdk.java.entities.ResultValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.launcher.qubole.QuboleClient;
import org.talend.bigdata.launcher.qubole.QuboleJob;

public class QuboleHiveClient
extends QuboleClient {
    private QuboleHiveClient(String apiKey, String apiEndpoint) {
        super(apiKey, apiEndpoint);
    }

    public CommandResponse executeAsync(Job job) throws Exception {
        HiveCommandBuilder builder = this.getHiveBuilder().query(job.query);
        job.clusterLabel.ifPresent(arg_0 -> ((HiveCommandBuilder)builder).clusterLabel(arg_0));
        job.jobName.ifPresent(arg_0 -> ((HiveCommandBuilder)builder).name(arg_0));
        job.userAgent.ifPresent(tags -> builder.tags(new String[]{tags}));
        return (CommandResponse)builder.invoke().get();
    }

    public String execute(Job job) throws Exception {
        ResultLatch latch = new ResultLatch(this.client, this.executeAsync(job).getId());
        this.logger.info("job [" + job.jobName.orElse("name_missing") + "] sent to cluster, with query: \"" + job.getLoggingQuery() + "\"");
        this.logger.info("waiting for execution results ...");
        String results = latch.awaitResult().getResults();
        this.logger.info("execution finished");
        return results;
    }

    @Deprecated
    public CommandResponse executeAsync(String query) throws Exception {
        HiveCommandBuilder builder = this.getHiveBuilder().query(query);
        return (CommandResponse)builder.invoke().get();
    }

    @Deprecated
    public CommandResponse executeAsync(String query, String clusterLabel) throws Exception {
        return (CommandResponse)this.getHiveBuilder().query(query).clusterLabel(clusterLabel).invoke().get();
    }

    @Deprecated
    public ResultValue execute(String query) throws Exception {
        ResultLatch latch = new ResultLatch(this.client, this.executeAsync(query).getId());
        return latch.awaitResult();
    }

    @Deprecated
    public ResultValue execute(String query, String clusterLabel) throws Exception {
        ResultLatch latch = new ResultLatch(this.client, this.executeAsync(query, clusterLabel).getId());
        return latch.awaitResult();
    }

    private HiveCommandBuilder getHiveBuilder() {
        return this.client.command().hive();
    }

    public static class Job
    extends QuboleJob {
        private static final Logger logger = LoggerFactory.getLogger(Job.class);
        private String query;

        public Job(String query) {
            this.query = this.wipeS3Credentials(query.trim().replaceAll("\\s+", " "));
            logger.info("A qubole hive job created with query: \"" + this.getLoggingQuery() + "\"");
        }

        private String getLoggingQuery() {
            return this.query;
        }
    }

    public static final class Builder {
        private String apiEndpoint = "https://api.qubole.com/api";
        private String apiKey;

        public Builder setApiEndpoint(String apiEndpoint) {
            this.apiEndpoint = apiEndpoint;
            return this;
        }

        public Builder setApiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public QuboleHiveClient build() {
            return new QuboleHiveClient(this.apiKey, this.apiEndpoint);
        }
    }
}

