/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.qubole;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.qubole.qds.sdk.java.api.SparkCommandBuilder;
import com.qubole.qds.sdk.java.client.ResultLatch;
import com.qubole.qds.sdk.java.entities.CommandResponse;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.launcher.qubole.QuboleClient;
import org.talend.bigdata.launcher.qubole.QuboleJob;

public class QuboleSparkClient
extends QuboleClient {
    private Job job;

    public QuboleSparkClient(String apiKey) {
        this(apiKey, "https://api.qubole.com/api");
    }

    public QuboleSparkClient(String apiKey, String apiEndpoint) {
        super(apiKey, apiEndpoint);
    }

    public CommandResponse executeAsync(Job job) throws Exception {
        this.setJob(job);
        job.uploadJarsToS3();
        SparkCommandBuilder builder = this.getSparkBuilder();
        builder.language("command_line");
        builder.cmdLine(job.submitCommand());
        job.clusterLabel.ifPresent(label -> builder.clusterLabel(label));
        job.jobName.ifPresent(name -> builder.name(name));
        job.userAgent.ifPresent(useragent -> builder.tags(new String[]{useragent}));
        this.logger.info("spark-submit command: " + job.submitCommand());
        return (CommandResponse)builder.invoke().get();
    }

    public String execute(Job job) throws Exception {
        ResultLatch latch = new ResultLatch(this.client, this.executeAsync(job).getId());
        return latch.awaitResult().getResults();
    }

    private void setJob(Job job) {
        this.job = job;
    }

    private Job getJob() {
        if (!this.hasJob()) {
            throw new NoSuchElementException("Qubole spark client doesn't contain any job.");
        }
        return this.job;
    }

    private boolean hasJob() {
        return this.job != null;
    }

    @Override
    public void close() throws Exception {
        if (this.hasJob()) {
            this.getJob().cleanJarsOnS3();
        }
        super.close();
    }

    public static class Job
    extends QuboleJob {
        private static final Logger logger = LoggerFactory.getLogger(Job.class);
        private static final String LANGUAGE = "command_line";
        private static final String SPARK_SUBMIT_BIN = "/usr/lib/spark/bin/spark-submit";
        private static final String SPARK_SUBMIT_QUBOLE_FLAG = "-calledByQubole";
        private String talendJobName;
        private String talendJobVersion;
        private List<String> jars;
        private String master;
        private String mainClass;
        private Optional<String> deployMode = Optional.empty();
        private Optional<Map<String, String>> configs = Optional.empty();
        private S3Account s3Account;
        private AmazonS3 s3Client;
        private Function<Boolean, Function<String, String>> jarProcessFuncGenerator = withCredentials -> jar -> {
            String jarName = jar.split("/")[jar.split("/").length - 1];
            String fullBucketKey = this.s3Account.bucketKey + "/" + jarName;
            String fullS3Path = "s3://" + (withCredentials != false ? this.s3Account.accessKey + ":" + this.s3Account.secretKey + "@" : "") + this.s3Account.bucketName + "/" + fullBucketKey;
            return fullS3Path;
        };

        public Job(String talendJobName, String talendJobVersion, List<String> jars, String master, String mainClass, S3Account s3Account) {
            this.talendJobName = talendJobName;
            this.talendJobVersion = talendJobVersion;
            this.jars = jars;
            this.master = master;
            this.mainClass = mainClass;
            this.s3Account = s3Account;
        }

        private void uploadJarsToS3() {
            logger.info("preparing resource jars on s3.");
            BasicAWSCredentials awsCredentials = new BasicAWSCredentials(this.s3Account.accessKey, this.s3Account.secretKey);
            this.s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(this.s3Account.region)).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials))).build();
            for (String jar : this.jars) {
                String jarBucketKey = this.s3Account.bucketKey.replaceAll("^/+|/+$", "") + "/" + jar.split("/")[jar.split("/").length - 1];
                logger.info("uploading jar: s3://" + this.s3Account.bucketName + "/" + jarBucketKey);
                this.s3Client.putObject(this.s3Account.bucketName, jarBucketKey, new File(jar));
            }
        }

        private void cleanJarsOnS3() {
            if (this.s3Client != null) {
                for (String jar : this.jars) {
                    String jarBucketKey = this.s3Account.bucketKey.replaceAll("^/+|/+$", "") + "/" + jar.split("/")[jar.split("/").length - 1];
                    logger.info("deleting jar: s3://" + this.s3Account.bucketName + "/" + jarBucketKey);
                    this.s3Client.deleteObject(new DeleteObjectRequest(this.s3Account.bucketName, jarBucketKey));
                }
            }
        }

        String submitCommand() {
            return this.submitCommand(false);
        }

        String submitCommand(boolean explicitCredentials) {
            StringJoiner stringJoiner = new StringJoiner(" ");
            stringJoiner.add(SPARK_SUBMIT_BIN);
            stringJoiner.add("--class " + this.mainClass);
            stringJoiner.add("--master " + this.master);
            this.deployMode.ifPresent(deployMode -> stringJoiner.add("--deploy-mode " + deployMode));
            this.configs.ifPresent(configs -> configs.forEach((k, v) -> {
                if (explicitCredentials || !explicitCredentials && !k.contains("awsSecretAccessKey")) {
                    stringJoiner.add("--conf \"" + k + "=" + v + "\"");
                }
            }));
            List processedJars = this.jars.stream().map(this.jarProcessFuncGenerator.apply(explicitCredentials)).collect(Collectors.toList());
            String appJar = processedJars.stream().filter(jar -> jar.contains(this.talendJobName.toLowerCase() + "_" + this.talendJobVersion.replace(".", "_"))).findAny().orElseThrow(() -> new IllegalArgumentException("application jar [" + this.talendJobName.toLowerCase() + "_" + this.talendJobVersion.replace(".", "_") + ".jar] not found in " + this.jars.toString()));
            List additionalJars = processedJars.stream().filter(jar -> !jar.contains(this.talendJobName.toLowerCase() + "_" + this.talendJobVersion.replace(".", "_"))).collect(Collectors.toList());
            StringJoiner jarsJoiner = new StringJoiner(",");
            for (String jar2 : additionalJars) {
                jarsJoiner.add(jar2);
            }
            stringJoiner.add("--jars " + jarsJoiner.toString());
            stringJoiner.add(appJar);
            stringJoiner.add(SPARK_SUBMIT_QUBOLE_FLAG);
            return stringJoiner.toString();
        }

        public void setDeployMode(String deployMode) {
            this.deployMode = Optional.ofNullable(deployMode);
        }

        public void setConfigs(Map<String, String> configs) {
            this.configs = Optional.ofNullable(configs);
        }
    }

    public static class S3Account {
        private String accessKey;
        private String secretKey;
        private String bucketName;
        private String bucketKey;
        private String region;

        public S3Account(String accessKey, String secretKey, String bucketName, String bucketKey, String region) {
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            this.bucketName = bucketName;
            this.bucketKey = bucketKey.replaceAll("^/+|/+$", "");
            this.region = region;
        }
    }
}

