/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.http.impl.cookie;

import org.talend.bigdata.http.annotation.Contract;
import org.talend.bigdata.http.annotation.ThreadingBehavior;
import org.talend.bigdata.http.cookie.CommonCookieAttributeHandler;
import org.talend.bigdata.http.cookie.Cookie;
import org.talend.bigdata.http.cookie.CookieOrigin;
import org.talend.bigdata.http.cookie.MalformedCookieException;
import org.talend.bigdata.http.cookie.SetCookie;
import org.talend.bigdata.http.impl.cookie.AbstractCookieAttributeHandler;
import org.talend.bigdata.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

