/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.livy;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.http.client.fluent.Request;
import org.talend.bigdata.http.entity.ContentType;
import org.talend.bigdata.launcher.AbstractSparkJobRequest;

class SparkJobRequest
extends AbstractSparkJobRequest {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER_PREFIX = "Bearer ";
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkJobRequest.class);

    private static String getApiPath(String sparkPoolsName) {
        String versions = "2019-01-01";
        return "/livyApi/versions/" + versions + "/sparkPools/" + sparkPoolsName + "/batches";
    }

    private static SparkJobRequest Get(String rootEndpoint, String apiPath, String token) {
        String fullEndpoint = SparkJobRequest.buildFullEndpoint(rootEndpoint, apiPath);
        return new SparkJobRequest(Request.Get(fullEndpoint).addHeader(AUTHORIZATION_HEADER, BEARER_PREFIX + token), rootEndpoint, apiPath);
    }

    private static SparkJobRequest Delete(String rootEndpoint, String apiPath, String token) {
        String fullEndpoint = SparkJobRequest.buildFullEndpoint(rootEndpoint, apiPath);
        return new SparkJobRequest(Request.Delete(fullEndpoint).addHeader(AUTHORIZATION_HEADER, BEARER_PREFIX + token), rootEndpoint, apiPath);
    }

    private static SparkJobRequest Post(String rootEndpoint, String apiPath, String token, String body) {
        String fullEndpoint = SparkJobRequest.buildFullEndpoint(rootEndpoint, apiPath);
        return new SparkJobRequest(Request.Post(fullEndpoint).addHeader(AUTHORIZATION_HEADER, BEARER_PREFIX + token).bodyString(body, ContentType.APPLICATION_JSON), rootEndpoint, "");
    }

    public static SparkJobRequest run(String rootEndpoint, String sparkPoolsName, String token, String body) {
        return SparkJobRequest.Post(rootEndpoint, SparkJobRequest.getApiPath(sparkPoolsName), token, body);
    }

    public static SparkJobRequest get(String rootEndpoint, String sparkPoolsName, Long jobId, String token) {
        return SparkJobRequest.Get(rootEndpoint, SparkJobRequest.getApiPath(sparkPoolsName) + "/" + jobId, token);
    }

    public static SparkJobRequest cancel(String rootEndpoint, String sparkPoolsName, Long jobId, String token) {
        return SparkJobRequest.Delete(rootEndpoint, SparkJobRequest.getApiPath(sparkPoolsName) + "/" + jobId, token);
    }

    private SparkJobRequest(Request request, String rootEndpoint, String apiPath) {
        super(request, rootEndpoint, apiPath);
    }

    public String toString() {
        return this.request.toString();
    }
}

