/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.http.protocol;

import java.io.IOException;
import org.talend.bigdata.http.HttpException;
import org.talend.bigdata.http.HttpRequest;
import org.talend.bigdata.http.HttpRequestInterceptor;
import org.talend.bigdata.http.annotation.Contract;
import org.talend.bigdata.http.annotation.ThreadingBehavior;
import org.talend.bigdata.http.params.HttpParams;
import org.talend.bigdata.http.protocol.HttpContext;
import org.talend.bigdata.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s = (String)params.getParameter("http.useragent");
            }
            if (s == null) {
                s = this.userAgent;
            }
            if (s != null) {
                request.addHeader("User-Agent", s);
            }
        }
    }
}

