/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.http.protocol;

import java.io.IOException;
import java.net.InetAddress;
import org.talend.bigdata.http.HttpConnection;
import org.talend.bigdata.http.HttpException;
import org.talend.bigdata.http.HttpHost;
import org.talend.bigdata.http.HttpInetConnection;
import org.talend.bigdata.http.HttpRequest;
import org.talend.bigdata.http.HttpRequestInterceptor;
import org.talend.bigdata.http.HttpVersion;
import org.talend.bigdata.http.ProtocolException;
import org.talend.bigdata.http.ProtocolVersion;
import org.talend.bigdata.http.annotation.Contract;
import org.talend.bigdata.http.annotation.ThreadingBehavior;
import org.talend.bigdata.http.protocol.HttpContext;
import org.talend.bigdata.http.protocol.HttpCoreContext;
import org.talend.bigdata.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext coreContext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targetHost = coreContext.getTargetHost();
            if (targetHost == null) {
                HttpConnection conn = coreContext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targetHost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targetHost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targetHost.toHostString());
        }
    }
}

