/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.fs;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientCertificateCredential;
import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.file.datalake.DataLakeDirectoryClient;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.DataLakeServiceClientBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.launcher.fs.FileSystem;

public class ADLSGen2FileSystem
extends FileSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(ADLSGen2FileSystem.class);
    protected DataLakeServiceClient dataLakeServiceClient;
    protected DataLakeFileSystemClient dataLakeFileSystemClient;
    protected DataLakeDirectoryClient dataLakeDirectoryClient;
    protected String rootDir;

    protected ADLSGen2FileSystem(DataLakeServiceClient dataLakeServiceClient, String fileSystemName, String directoryName) {
        this.overwrite = false;
        this.dataLakeServiceClient = dataLakeServiceClient;
        this.dataLakeFileSystemClient = dataLakeServiceClient.getFileSystemClient(fileSystemName);
        this.dataLakeDirectoryClient = this.dataLakeFileSystemClient.createDirectory(directoryName);
        this.rootDir = directoryName;
    }

    public ADLSGen2FileSystem(String accountName, String accountKey, String fileSystemName, String directoryName) {
        this(ADLSGen2FileSystem.createDataLakeServiceClient(new StorageSharedKeyCredential(accountName, accountKey), accountName), fileSystemName, directoryName);
    }

    public ADLSGen2FileSystem(String directoryId, String appId, boolean useCertificate, String aadCredentials, String endpoint, String fileSystemName, String directoryName) {
        this(ADLSGen2FileSystem.createDataLakeServiceClient(directoryId, appId, useCertificate, aadCredentials, endpoint), fileSystemName, directoryName);
    }

    private static DataLakeServiceClient createDataLakeServiceClient(String directoryId, String appId, boolean useCertificate, String aadCredentials, String endpoint) {
        return new DataLakeServiceClientBuilder().credential((TokenCredential)(useCertificate ? ADLSGen2FileSystem.aadClientCertificateBuilder(directoryId, appId, aadCredentials) : ADLSGen2FileSystem.aadClientCredentialBuilder(directoryId, appId, aadCredentials))).endpoint(endpoint).buildClient();
    }

    private static DataLakeServiceClient createDataLakeServiceClient(StorageSharedKeyCredential credentials, String accountName) {
        return new DataLakeServiceClientBuilder().credential(credentials).endpoint("https://" + accountName + ".dfs.core.windows.net").buildClient();
    }

    private static ClientSecretCredential aadClientCredentialBuilder(String tenantId, String clientId, String clientSecret) {
        return ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().tenantId(tenantId)).clientId(clientId)).clientSecret(clientSecret).build();
    }

    private static ClientCertificateCredential aadClientCertificateBuilder(String tenantId, String clientId, String pemCertificate) {
        return ((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().tenantId(tenantId)).clientId(clientId)).pemCertificate(pemCertificate).build();
    }

    @Override
    public boolean exists(String file) {
        boolean doesExist = false;
        try {
            doesExist = this.dataLakeDirectoryClient.getFileClient(file).exists();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return doesExist;
    }

    @Override
    public InputStream open(String file) {
        InputStream is = null;
        try {
            DataLakeFileClient fileClient = this.dataLakeDirectoryClient.getFileClient(file);
            File tmpFile = File.createTempFile("adlsgen2", null);
            OutputStream targetStream = Files.newOutputStream(tmpFile.toPath(), new OpenOption[0]);
            fileClient.read(targetStream);
            targetStream.close();
            is = Files.newInputStream(tmpFile.toPath(), new OpenOption[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return is;
    }

    @Override
    public void delete(String folder) {
        try {
            this.dataLakeDirectoryClient.deleteWithResponse(true, null, null, null);
        }
        catch (Exception e) {
            LOGGER.error("failed to delete directory '" + folder + "'", (Throwable)e);
        }
    }

    @Override
    public void mkdir(String folder) {
        LOGGER.info("create directory '{}'", (Object)folder);
        try {
            this.dataLakeFileSystemClient.createDirectory(folder);
        }
        catch (Exception e) {
            LOGGER.error("failed to create directory '{}'", (Object)folder, (Object)e);
        }
    }

    @Override
    public void copyFromLocal(String localFile, String targetFolder) {
        if (localFile == null) {
            LOGGER.debug("try to copy null. ignored");
            return;
        }
        if (targetFolder == null) {
            LOGGER.debug("try to copy to nowhere. ignored");
            return;
        }
        File file = new File(localFile);
        try {
            if (!file.exists()) {
                throw new FileNotFoundException("File not found: " + localFile);
            }
            DataLakeFileClient remoteFile = this.dataLakeDirectoryClient.getFileClient((targetFolder = targetFolder.substring(this.rootDir.length() + 1)) + "/" + file.getName());
            if (remoteFile.exists().booleanValue()) {
                LOGGER.debug("file already existing on remote file system");
                if (this.overwrite) {
                    LOGGER.debug("overwriting the file as requested");
                }
            }
            if (!remoteFile.exists().booleanValue() || this.overwrite) {
                LOGGER.info("copying local file {} to ADSLGen2 FileSystem '{}'", (Object)file.getCanonicalPath(), (Object)this.dataLakeFileSystemClient.getFileSystemName());
                remoteFile.uploadFromFile(file.getPath(), true);
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to copy file '" + localFile + "'", (Throwable)e);
        }
    }

    @Override
    public String getFileSystemPrefix() {
        return "abfss://" + this.dataLakeFileSystemClient.getFileSystemName() + "@" + this.dataLakeFileSystemClient.getAccountName() + ".dfs.core.windows.net";
    }
}

