/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.livy;

import java.util.List;
import java.util.Map;
import org.talend.bigdata.http.impl.client.CloseableHttpClient;
import org.talend.bigdata.jackson.core.JsonProcessingException;
import org.talend.bigdata.jackson.databind.ObjectMapper;
import org.talend.bigdata.jackson.databind.node.ArrayNode;
import org.talend.bigdata.jackson.databind.node.ObjectNode;
import org.talend.bigdata.launcher.SparkBaseJob;
import org.talend.bigdata.launcher.fs.FileSystem;
import org.talend.bigdata.launcher.livy.SparkJobRequest;
import org.talend.bigdata.launcher.utils.BaseBuilder;

public class SparkJob
extends SparkBaseJob {
    protected String mToken;
    protected String mSparkPoolsName;
    protected CloseableHttpClient httpClient;
    int returnCode;

    private SparkJob(FileSystem fs, String token, String userAgent, String remoteFolder, String livyEndpoint, String libJars, String sparkPoolsName, String classToExecute, String jarToExecute, Map<String, String> conf, String appName, String driverMemory, String executorMemory, Integer driverCore, Integer executorCore, List<String> args, Integer pollingIntervalDuration, Integer maxMissingStatuses, int connectionTimeout, int socketTimeout) {
        this.mClassToExecute = classToExecute;
        this.userAgent = userAgent;
        this.mFileSystem = fs;
        this.mToken = token;
        this.mJarToExecute = jarToExecute;
        this.mLibjars = libJars;
        this.mLivyEndpoint = livyEndpoint;
        this.mRemoteFolder = remoteFolder;
        this.mSparkPoolsName = sparkPoolsName;
        this.mConf = conf;
        this.mAppName = appName;
        this.mDriverCore = driverCore;
        this.mDriverMemory = driverMemory;
        this.mExecutorCore = executorCore;
        this.mExecutorMemory = executorMemory;
        this.mArgs = args;
        this.pollingIntervalDuration = pollingIntervalDuration;
        this.maxMissingStatuses = maxMissingStatuses;
        this.returnCode = -1;
        if (this.mLivyEndpoint != null) {
            this.httpClient = this.createHttpClientLivy(connectionTimeout, socketTimeout);
        }
    }

    @Override
    protected String createExecuteBody(ObjectMapper mapper, String remoteLibJars) throws JsonProcessingException {
        ObjectNode executeBodyObjectNode = this.createExecuteBodyObjectNode(mapper);
        if (remoteLibJars != null) {
            ArrayNode jars = mapper.createArrayNode();
            for (String jar : remoteLibJars.split(",")) {
                if (jar.contains("log4j-1.2-api")) continue;
                jars.add(jar);
            }
            executeBodyObjectNode.set("jars", jars);
        }
        executeBodyObjectNode.put("NumExecutors", "3");
        return mapper.writeValueAsString(executeBodyObjectNode);
    }

    @Override
    public int executeJob() throws Exception {
        String remoteLibJars = this.sendFiles();
        ObjectMapper mapper = new ObjectMapper();
        String body = this.createExecuteBody(mapper, remoteLibJars);
        this.jobId = this.start(mapper, body, 200, SparkJobRequest.run(this.mLivyEndpoint, this.mSparkPoolsName, this.mToken, body).withHttpClient(this.httpClient));
        this.returnCode = this.waitStatus(new ObjectMapper(), SparkJobRequest.get(this.mLivyEndpoint, this.mSparkPoolsName, this.jobId, this.mToken).withHttpClient(this.httpClient));
        this.log = this.generateLog(new ObjectMapper(), SparkJobRequest.get(this.mLivyEndpoint, this.mSparkPoolsName, this.jobId, this.mToken).withHttpClient(this.httpClient));
        return this.getReturnCode();
    }

    @Override
    public void cancelJob() throws Exception {
        this.cancelJob(() -> SparkJobRequest.cancel(this.mLivyEndpoint, this.mSparkPoolsName, this.jobId, this.mToken).withHttpClient(this.httpClient));
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public static class Builder
    extends BaseBuilder<SparkJob> {
        @Override
        public SparkJob build() {
            return new SparkJob(this.fileSystem, this.token, this.userAgent, this.remoteFolder, this.livyEndpoint, this.libJars, this.sparkPoolsName, this.classToExecute, this.jarToExecute, this.configuration, this.applicationName, this.driverMemory, this.executorMemory, this.driverCore, this.executorCore, this.arguments, this.intervalPollingDuration, this.maxMissingStatuses, this.connectionTimeout, this.socketTimeout);
        }
    }
}

