/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.livy;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.http.HttpResponse;
import org.talend.bigdata.http.client.HttpClient;
import org.talend.bigdata.http.client.fluent.Executor;
import org.talend.bigdata.http.client.fluent.Request;
import org.talend.bigdata.http.entity.ContentType;
import org.talend.bigdata.lang3.StringUtils;
import org.talend.bigdata.launcher.EndpointDescriptor;

class SparkJobRequest
implements EndpointDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkJobRequest.class);
    HttpClient httpClient;
    Request request;
    String rootEndpoint;
    String apiPath;

    private static String getApiPath(String sparkPoolsName) {
        String versions = "2019-01-01";
        return "/livyApi/versions/" + versions + "/sparkPools/" + sparkPoolsName + "/batches";
    }

    private static SparkJobRequest Get(String rootEndpoint, String apiPath, String token) {
        String fullEndpoint = rootEndpoint.endsWith("/") ? rootEndpoint + StringUtils.removeStart(apiPath, "/") : rootEndpoint + apiPath;
        return new SparkJobRequest(Request.Get(fullEndpoint).addHeader("Authorization", "Bearer " + token), rootEndpoint, apiPath);
    }

    private static SparkJobRequest Delete(String rootEndpoint, String apiPath, String token) {
        String fullEndpoint = rootEndpoint.endsWith("/") ? rootEndpoint + StringUtils.removeStart(apiPath, "/") : rootEndpoint + apiPath;
        return new SparkJobRequest(Request.Delete(fullEndpoint).addHeader("Authorization", "Bearer " + token), rootEndpoint, apiPath);
    }

    private static SparkJobRequest Post(String rootEndpoint, String apiPath, String token, String body) {
        String fullEndpoint = rootEndpoint.endsWith("/") ? rootEndpoint + StringUtils.removeStart(apiPath, "/") : rootEndpoint + apiPath;
        return new SparkJobRequest(Request.Post(fullEndpoint).addHeader("Authorization", "Bearer " + token).bodyString(body, ContentType.APPLICATION_JSON), rootEndpoint, "");
    }

    public static SparkJobRequest run(String rootEndpoint, String sparkPoolsName, String token, String body) {
        return SparkJobRequest.Post(rootEndpoint, SparkJobRequest.getApiPath(sparkPoolsName), token, body);
    }

    public static SparkJobRequest get(String rootEndpoint, String sparkPoolsName, Long jobId, String token) {
        return SparkJobRequest.Get(rootEndpoint, SparkJobRequest.getApiPath(sparkPoolsName) + "/" + jobId, token);
    }

    public static SparkJobRequest cancel(String rootEndpoint, String sparkPoolsName, Long jobId, String token) {
        return SparkJobRequest.Delete(rootEndpoint, SparkJobRequest.getApiPath(sparkPoolsName) + "/" + jobId, token);
    }

    public SparkJobRequest withHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    private SparkJobRequest(Request request, String rootEndpoint, String apiPath) {
        this.request = request;
        this.rootEndpoint = StringUtils.removeEnd(rootEndpoint, "/");
        this.apiPath = apiPath;
    }

    @Override
    public HttpResponse execute() throws IOException {
        Executor executor = Executor.newInstance(this.httpClient).authPreemptive(this.rootEndpoint);
        return executor.execute(this.request).returnResponse();
    }

    @Override
    public String getFullEndpoint() {
        String fullEndpoint = this.rootEndpoint.endsWith("/") ? this.rootEndpoint + StringUtils.removeStart(this.apiPath, "/") : this.rootEndpoint + this.apiPath;
        return fullEndpoint;
    }

    public String toString() {
        return this.request.toString();
    }
}

