/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.misc.tlogrow;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeoutException;
import java.util.stream.IntStream;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.talend.bigdata.common.TestData;
import org.talend.bigdata.common.testutils.TestUtils;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.ImmutableTLogRow;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.ImmutableTLogRowForEachBatchWriter;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.TLogRowForEachBatchWriter;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.mode.ImmutableBasicLoggerMode;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.mode.ImmutableTableLoggerMode;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.mode.ImmutableVerticalTableLoggerMode;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.mode.VerticalTableLoggerMode;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.mode.WithLoggerMode;
import org.talend.bigdata.structuredstreaming.parquet.ImmutableTFileInputParquet;
import org.talend.bigdata.structuredstreaming.utils.ConsoleLinesCaptor;
import org.talend.bigdata.structuredstreaming.utils.TestUtil;

public class TLogRowTest {
    public static final String DATAFILES_PARQUET = "datafiles/parquet";
    private static SparkSession sparkSession;
    @TempDir
    Path testWorkingFolder;
    TimeZone originalTZ = TimeZone.getDefault();

    @BeforeAll
    static void setupAll() {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        System.setProperty("hadoop.home.dir", new File("src/test/resources/winutils/").getAbsolutePath());
        sparkSession = TestData.SPARK.sparkSessionWithUTCConf((boolean)false);
    }

    @AfterAll
    static void tearDownAll() {
        if (sparkSession != null) {
            sparkSession.stop();
        }
    }

    @BeforeEach
    void setUp() throws Exception {
        Path parquetDir = this.testWorkingFolder.resolve("datafiles/parquet/");
        TestUtil.createTempDirectory(parquetDir);
    }

    @Test
    void test_log_basicMode() throws IOException, URISyntaxException {
        Path parquetDir = this.testWorkingFolder.resolve("");
        TestUtils.getResourceFileUrlInsideTempFolder((String)"datafiles/parquet/testFile_1.parquet", (String)parquetDir.toString(), this.getClass());
        Dataset inputDataframe = ImmutableTFileInputParquet.builder().sparkSession(sparkSession).addAllSchemaFieldDescriptions(TestUtil.immutableSchemaStructureFieldDescriptionList).addPaths(parquetDir.resolve(DATAFILES_PARQUET).toAbsolutePath() + File.separator).build().read();
        ImmutableBasicLoggerMode basicLoggerMode = ImmutableBasicLoggerMode.builder().addAllSchemaFieldDescriptions(TestUtil.immutableSchemaStructureFieldDescriptionList).fieldSeparator("|").build();
        ImmutableTLogRowForEachBatchWriter tLogRowForEachBatchWriter = ImmutableTLogRowForEachBatchWriter.builder().loggerMode((WithLoggerMode)basicLoggerMode).build();
        ImmutableTLogRow.Dataframe tLogRow = ImmutableTLogRow.Dataframe.builder().input(inputDataframe).tLogRowForEachBatchWriter((TLogRowForEachBatchWriter)tLogRowForEachBatchWriter).build();
        List<String> collectedStringList = ConsoleLinesCaptor.getCapturedLinesList(() -> {
            try {
                tLogRow.start().awaitTermination(10000L);
            }
            catch (TimeoutException | StreamingQueryException e) {
                throw new RuntimeException(e);
            }
        });
        Assertions.assertEquals((int)2, (int)collectedStringList.size());
        Assertions.assertEquals((Object)"true|1|123|05-06-2020|2020-06-05 12:00:00|1.0|1.0|1|1|1|abc|a", (Object)collectedStringList.get(0));
        Assertions.assertEquals((Object)"false|9|789|06-06-2020|2020-06-06 12:00:00|9.0|9.0|9|9|9|xyz|z", (Object)collectedStringList.get(1));
    }

    @Test
    void test_log_basicMode_useLocalTimeZone() throws IOException, URISyntaxException {
        TimeZone.setDefault(TimeZone.getTimeZone("Europe/Paris"));
        Path parquetDir = this.testWorkingFolder.resolve("datafiles/parquet/");
        TestUtils.getResourceFileUrlInsideTempFolder((String)"datafiles/parquet/testFile_1.parquet", (String)parquetDir.toString(), this.getClass());
        Dataset inputDataframe = ImmutableTFileInputParquet.builder().sparkSession(sparkSession).addAllSchemaFieldDescriptions(TestUtil.immutableSchemaStructureFieldDescriptionList).addPaths(parquetDir.resolve(DATAFILES_PARQUET).toAbsolutePath() + File.separator).build().read();
        ImmutableBasicLoggerMode basicLoggerMode = ImmutableBasicLoggerMode.builder().addAllSchemaFieldDescriptions(TestUtil.immutableSchemaStructureFieldDescriptionList).fieldSeparator("|").useLocalTimeZone(true).build();
        ImmutableTLogRowForEachBatchWriter tLogRowForEachBatchWriter = ImmutableTLogRowForEachBatchWriter.builder().loggerMode((WithLoggerMode)basicLoggerMode).build();
        ImmutableTLogRow.Dataframe tLogRow = ImmutableTLogRow.Dataframe.builder().input(inputDataframe).tLogRowForEachBatchWriter((TLogRowForEachBatchWriter)tLogRowForEachBatchWriter).build();
        List<String> collectedStringList = ConsoleLinesCaptor.getCapturedLinesList(() -> {
            try {
                tLogRow.start().awaitTermination(10000L);
            }
            catch (TimeoutException | StreamingQueryException e) {
                throw new RuntimeException(e);
            }
        });
        TimeZone.setDefault(this.originalTZ);
        Assertions.assertEquals((int)2, (int)collectedStringList.size());
        Assertions.assertEquals((Object)"true|1|123|05-06-2020|2020-06-05 14:00:00|1.0|1.0|1|1|1|abc|a", (Object)collectedStringList.get(0));
        Assertions.assertEquals((Object)"false|9|789|06-06-2020|2020-06-06 14:00:00|9.0|9.0|9|9|9|xyz|z", (Object)collectedStringList.get(1));
    }

    @Test
    void test_log_basicMode_printHeader() throws IOException, URISyntaxException {
        Path parquetDir = this.testWorkingFolder.resolve("datafiles/parquet/");
        TestUtils.getResourceFileUrlInsideTempFolder((String)"datafiles/parquet/testFile_1.parquet", (String)parquetDir.toString(), this.getClass());
        Dataset inputDataframe = ImmutableTFileInputParquet.builder().sparkSession(sparkSession).addAllSchemaFieldDescriptions(TestUtil.immutableSchemaStructureFieldDescriptionList).addPaths(parquetDir.resolve(DATAFILES_PARQUET).toAbsolutePath() + File.separator).build().read();
        ImmutableBasicLoggerMode basicLoggerMode = ImmutableBasicLoggerMode.builder().addAllSchemaFieldDescriptions(TestUtil.immutableSchemaStructureFieldDescriptionList).fieldSeparator("|").printHeader(true).build();
        ImmutableTLogRowForEachBatchWriter tLogRowForEachBatchWriter = ImmutableTLogRowForEachBatchWriter.builder().loggerMode((WithLoggerMode)basicLoggerMode).build();
        ImmutableTLogRow.Dataframe tLogRow = ImmutableTLogRow.Dataframe.builder().input(inputDataframe).tLogRowForEachBatchWriter((TLogRowForEachBatchWriter)tLogRowForEachBatchWriter).build();
        List<String> collectedStringList = ConsoleLinesCaptor.getCapturedLinesList(() -> {
            try {
                tLogRow.start().awaitTermination(10000L);
            }
            catch (TimeoutException | StreamingQueryException e) {
                throw new RuntimeException(e);
            }
        });
        Assertions.assertEquals((int)3, (int)collectedStringList.size());
        Assertions.assertEquals((Object)"t_Boolean\tt_Byte\tt_byteArray\tt_Date\tt_TimeStamp\tt_Double\tt_Float\tt_Integer\tt_Long\tt_Short\tt_String\tt_Char", (Object)collectedStringList.get(0));
        Assertions.assertEquals((Object)"true|1|123|05-06-2020|2020-06-05 12:00:00|1.0|1.0|1|1|1|abc|a", (Object)collectedStringList.get(1));
        Assertions.assertEquals((Object)"false|9|789|06-06-2020|2020-06-06 12:00:00|9.0|9.0|9|9|9|xyz|z", (Object)collectedStringList.get(2));
    }

    @Test
    void test_log_basicMode_printHeader_printComponentName() throws IOException, URISyntaxException {
        Path parquetDir = this.testWorkingFolder.resolve("datafiles/parquet/");
        TestUtils.getResourceFileUrlInsideTempFolder((String)"datafiles/parquet/testFile_1.parquet", (String)parquetDir.toString(), this.getClass());
        Dataset inputDataframe = ImmutableTFileInputParquet.builder().sparkSession(sparkSession).addAllSchemaFieldDescriptions(TestUtil.immutableSchemaStructureFieldDescriptionList).addPaths(parquetDir.resolve(DATAFILES_PARQUET).toAbsolutePath() + File.separator).build().read();
        ImmutableBasicLoggerMode basicLoggerMode = ImmutableBasicLoggerMode.builder().addAllSchemaFieldDescriptions(TestUtil.immutableSchemaStructureFieldDescriptionList).fieldSeparator("|").printHeader(true).printComponentUniqueName(true).componentName("tLogRow_1").build();
        ImmutableTLogRowForEachBatchWriter tLogRowForEachBatchWriter = ImmutableTLogRowForEachBatchWriter.builder().loggerMode((WithLoggerMode)basicLoggerMode).build();
        ImmutableTLogRow.Dataframe tLogRow = ImmutableTLogRow.Dataframe.builder().input(inputDataframe).tLogRowForEachBatchWriter((TLogRowForEachBatchWriter)tLogRowForEachBatchWriter).build();
        List<String> collectedStringList = ConsoleLinesCaptor.getCapturedLinesList(() -> {
            try {
                tLogRow.start().awaitTermination(10000L);
            }
            catch (TimeoutException | StreamingQueryException e) {
                throw new RuntimeException(e);
            }
        });
        collectedStringList.forEach(System.out::println);
        Assertions.assertEquals((int)3, (int)collectedStringList.size());
        Assertions.assertEquals((Object)"t_Boolean\tt_Byte\tt_byteArray\tt_Date\tt_TimeStamp\tt_Double\tt_Float\tt_Integer\tt_Long\tt_Short\tt_String\tt_Char", (Object)collectedStringList.get(0));
        Assertions.assertEquals((Object)"[tLogRow_1] true|1|123|05-06-2020|2020-06-05 12:00:00|1.0|1.0|1|1|1|abc|a", (Object)collectedStringList.get(1));
        Assertions.assertEquals((Object)"[tLogRow_1] false|9|789|06-06-2020|2020-06-06 12:00:00|9.0|9.0|9|9|9|xyz|z", (Object)collectedStringList.get(2));
    }

    @Test
    void test_log_basicMode_printSchemaColumnName() throws IOException, URISyntaxException {
        Path parquetDir = this.testWorkingFolder.resolve("datafiles/parquet/");
        TestUtils.getResourceFileUrlInsideTempFolder((String)"datafiles/parquet/testFile_1.parquet", (String)parquetDir.toString(), this.getClass());
        Dataset inputDataframe = ImmutableTFileInputParquet.builder().sparkSession(sparkSession).addAllSchemaFieldDescriptions(TestUtil.immutableSchemaStructureFieldDescriptionList).addPaths(parquetDir.resolve(DATAFILES_PARQUET).toAbsolutePath() + File.separator).build().read();
        ImmutableBasicLoggerMode basicLoggerMode = ImmutableBasicLoggerMode.builder().addAllSchemaFieldDescriptions(TestUtil.immutableSchemaStructureFieldDescriptionList).fieldSeparator("|").printSchemaColumnName(true).build();
        ImmutableTLogRowForEachBatchWriter tLogRowForEachBatchWriter = ImmutableTLogRowForEachBatchWriter.builder().loggerMode((WithLoggerMode)basicLoggerMode).build();
        ImmutableTLogRow.Dataframe tLogRow = ImmutableTLogRow.Dataframe.builder().input(inputDataframe).tLogRowForEachBatchWriter((TLogRowForEachBatchWriter)tLogRowForEachBatchWriter).build();
        List<String> collectedStringList = ConsoleLinesCaptor.getCapturedLinesList(() -> {
            try {
                tLogRow.start().awaitTermination(10000L);
            }
            catch (TimeoutException | StreamingQueryException e) {
                throw new RuntimeException(e);
            }
        });
        collectedStringList.forEach(System.out::println);
        Assertions.assertEquals((int)2, (int)collectedStringList.size());
        Assertions.assertEquals((Object)"t_Boolean: true|t_Byte: 1|t_byteArray: 123|t_Date: 05-06-2020|t_TimeStamp: 2020-06-05 12:00:00|t_Double: 1.0|t_Float: 1.0|t_Integer: 1|t_Long: 1|t_Short: 1|t_String: abc|t_Char: a", (Object)collectedStringList.get(0));
        Assertions.assertEquals((Object)"t_Boolean: false|t_Byte: 9|t_byteArray: 789|t_Date: 06-06-2020|t_TimeStamp: 2020-06-06 12:00:00|t_Double: 9.0|t_Float: 9.0|t_Integer: 9|t_Long: 9|t_Short: 9|t_String: xyz|t_Char: z", (Object)collectedStringList.get(1));
    }

    @Test
    void test_log_basicMode_useFixedLengths() throws IOException, URISyntaxException {
        HashMap<String, Integer> useFixedLengthsMap = new HashMap<String, Integer>(){
            {
                this.put("t_Boolean", 10);
                this.put("t_Byte", 10);
                this.put("t_byteArray", 10);
                this.put("t_Date", 10);
                this.put("t_TimeStamp", 10);
                this.put("t_Double", 10);
                this.put("t_Float", 10);
                this.put("t_Integer", 10);
                this.put("t_Long", 10);
                this.put("t_Short", 10);
                this.put("t_String", 10);
                this.put("t_Char", 10);
            }
        };
        Path parquetDir = this.testWorkingFolder.resolve("datafiles/parquet/");
        TestUtils.getResourceFileUrlInsideTempFolder((String)"datafiles/parquet/testFile_1.parquet", (String)parquetDir.toString(), this.getClass());
        Dataset inputDataframe = ImmutableTFileInputParquet.builder().sparkSession(sparkSession).addAllSchemaFieldDescriptions(TestUtil.immutableSchemaStructureFieldDescriptionList).addPaths(parquetDir.resolve(DATAFILES_PARQUET).toAbsolutePath() + File.separator).build().read();
        ImmutableBasicLoggerMode basicLoggerMode = ImmutableBasicLoggerMode.builder().addAllSchemaFieldDescriptions(TestUtil.immutableSchemaStructureFieldDescriptionList).fieldSeparator("|").useFixedLengthForValues(true).fixedLengthValuesMap((Map)useFixedLengthsMap).build();
        ImmutableTLogRowForEachBatchWriter tLogRowForEachBatchWriter = ImmutableTLogRowForEachBatchWriter.builder().loggerMode((WithLoggerMode)basicLoggerMode).build();
        ImmutableTLogRow.Dataframe tLogRow = ImmutableTLogRow.Dataframe.builder().input(inputDataframe).tLogRowForEachBatchWriter((TLogRowForEachBatchWriter)tLogRowForEachBatchWriter).build();
        List<String> collectedStringList = ConsoleLinesCaptor.getCapturedLinesList(() -> {
            try {
                tLogRow.start().awaitTermination(10000L);
            }
            catch (TimeoutException | StreamingQueryException e) {
                throw new RuntimeException(e);
            }
        });
        collectedStringList.forEach(System.out::println);
        Assertions.assertEquals((int)2, (int)collectedStringList.size());
        Assertions.assertEquals((Object)"      true|         1|       123|05-06-2020|2020-06-05 12:00:00|       1.0|       1.0|         1|         1|         1|       abc|         a", (Object)collectedStringList.get(0));
        Assertions.assertEquals((Object)"     false|         9|       789|06-06-2020|2020-06-06 12:00:00|       9.0|       9.0|         9|         9|         9|       xyz|         z", (Object)collectedStringList.get(1));
    }

    @Test
    void test_log_tableMode() throws IOException, URISyntaxException {
        Path parquetDir = this.testWorkingFolder.resolve("datafiles/parquet/");
        TestUtils.getResourceFileUrlInsideTempFolder((String)"datafiles/parquet/testFile_1.parquet", (String)parquetDir.toString(), this.getClass());
        Dataset inputDataframe = ImmutableTFileInputParquet.builder().sparkSession(sparkSession).addAllSchemaFieldDescriptions(TestUtil.immutableSchemaStructureFieldDescriptionList).addPaths(parquetDir.resolve(DATAFILES_PARQUET).toAbsolutePath() + File.separator).build().read();
        ImmutableTableLoggerMode tableLoggerMode = ImmutableTableLoggerMode.builder().addAllSchemaFieldDescriptions(TestUtil.immutableSchemaStructureFieldDescriptionList).componentName("tLogRow_1").build();
        ImmutableTLogRowForEachBatchWriter tLogRowForEachBatchWriter = ImmutableTLogRowForEachBatchWriter.builder().loggerMode((WithLoggerMode)tableLoggerMode).build();
        ImmutableTLogRow.Dataframe tLogRow = ImmutableTLogRow.Dataframe.builder().input(inputDataframe).tLogRowForEachBatchWriter((TLogRowForEachBatchWriter)tLogRowForEachBatchWriter).build();
        List<String> collectedStringList = ConsoleLinesCaptor.getCapturedTableLinesList(() -> {
            try {
                tLogRow.start().awaitTermination(10000L);
            }
            catch (TimeoutException | StreamingQueryException e) {
                throw new RuntimeException(e);
            }
        });
        IntStream.range(0, collectedStringList.size()).forEach(i -> {
            String s = (String)collectedStringList.get(i);
            System.out.println("Line " + i + ": " + s);
        });
        Assertions.assertEquals((int)1, (int)collectedStringList.size());
        Assertions.assertEquals((Object)".---------+------+-----------+----------+-------------------+--------+-------+---------+------+-------+--------+------.\n|                                                      tLogRow_1                                                      |\n|=--------+------+-----------+----------+-------------------+--------+-------+---------+------+-------+--------+-----=|\n|t_Boolean|t_Byte|t_byteArray|t_Date    |t_TimeStamp        |t_Double|t_Float|t_Integer|t_Long|t_Short|t_String|t_Char|\n|=--------+------+-----------+----------+-------------------+--------+-------+---------+------+-------+--------+-----=|\n|true     |1     |123        |05-06-2020|2020-06-05 12:00:00|1.0     |1.0    |1        |1     |1      |abc     |a     |\n|false    |9     |789        |06-06-2020|2020-06-06 12:00:00|9.0     |9.0    |9        |9     |9      |xyz     |z     |\n'---------+------+-----------+----------+-------------------+--------+-------+---------+------+-------+--------+------'\n", (Object)collectedStringList.get(0));
    }

    @Test
    void test_log_verticalMode_printUniqueName() throws IOException, URISyntaxException {
        Path parquetDir = this.testWorkingFolder.resolve("datafiles/parquet/");
        TestUtils.getResourceFileUrlInsideTempFolder((String)"datafiles/parquet/testFile_1.parquet", (String)parquetDir.toString(), this.getClass());
        Dataset inputDataframe = ImmutableTFileInputParquet.builder().sparkSession(sparkSession).addAllSchemaFieldDescriptions(TestUtil.immutableSchemaStructureFieldDescriptionList).addPaths(parquetDir.resolve(DATAFILES_PARQUET).toAbsolutePath() + File.separator).build().read();
        ImmutableVerticalTableLoggerMode verticalTableLoggerMode = ImmutableVerticalTableLoggerMode.builder().addAllSchemaFieldDescriptions(TestUtil.immutableSchemaStructureFieldDescriptionList).verticalTitlePrintOption(VerticalTableLoggerMode.VerticalTitlePrintOptions.UNIQUE_NAME).componentName("tLogRow_1").componentLabel("notPrinted").build();
        ImmutableTLogRowForEachBatchWriter tLogRowForEachBatchWriter = ImmutableTLogRowForEachBatchWriter.builder().loggerMode((WithLoggerMode)verticalTableLoggerMode).build();
        ImmutableTLogRow.Dataframe tLogRow = ImmutableTLogRow.Dataframe.builder().input(inputDataframe).tLogRowForEachBatchWriter((TLogRowForEachBatchWriter)tLogRowForEachBatchWriter).build();
        List<String> collectedStringList = ConsoleLinesCaptor.getCapturedTableLinesList(() -> {
            try {
                tLogRow.start().awaitTermination(10000L);
            }
            catch (TimeoutException | StreamingQueryException e) {
                throw new RuntimeException(e);
            }
        });
        collectedStringList.forEach(System.out::println);
        Assertions.assertEquals((int)2, (int)collectedStringList.size());
        Assertions.assertEquals((Object)".--------------------------------.\n|         #12. tLogRow_1         |\n+----------+---------------------+\n| key      | value               |\n+----------+---------------------+\n| t_Boolean| true                |\n| t_Byte   | 1                   |\n| t_byteArray| 123                 |\n| t_Date   | 05-06-2020          |\n| t_TimeStamp| 2020-06-05 12:00:00 |\n| t_Double | 1.0                 |\n| t_Float  | 1.0                 |\n| t_Integer| 1                   |\n| t_Long   | 1                   |\n| t_Short  | 1                   |\n| t_String | abc                 |\n| t_Char   | a                   |\n+----------+---------------------+\n", (Object)collectedStringList.get(0));
        Assertions.assertEquals((Object)".--------------------------------.\n|         #12. tLogRow_1         |\n+----------+---------------------+\n| key      | value               |\n+----------+---------------------+\n| t_Boolean| false               |\n| t_Byte   | 9                   |\n| t_byteArray| 789                 |\n| t_Date   | 06-06-2020          |\n| t_TimeStamp| 2020-06-06 12:00:00 |\n| t_Double | 9.0                 |\n| t_Float  | 9.0                 |\n| t_Integer| 9                   |\n| t_Long   | 9                   |\n| t_Short  | 9                   |\n| t_String | xyz                 |\n| t_Char   | z                   |\n+----------+---------------------+\n", (Object)collectedStringList.get(1));
    }

    @Test
    void test_log_verticalMode_printLabel() throws IOException, URISyntaxException {
        Path parquetDir = this.testWorkingFolder.resolve("datafiles/parquet/");
        TestUtils.getResourceFileUrlInsideTempFolder((String)"datafiles/parquet/testFile_1.parquet", (String)parquetDir.toString(), this.getClass());
        Dataset inputDataframe = ImmutableTFileInputParquet.builder().sparkSession(sparkSession).addAllSchemaFieldDescriptions(TestUtil.immutableSchemaStructureFieldDescriptionList).addPaths(parquetDir.resolve(DATAFILES_PARQUET).toAbsolutePath() + File.separator).build().read();
        ImmutableVerticalTableLoggerMode verticalTableLoggerMode = ImmutableVerticalTableLoggerMode.builder().addAllSchemaFieldDescriptions(TestUtil.immutableSchemaStructureFieldDescriptionList).verticalTitlePrintOption(VerticalTableLoggerMode.VerticalTitlePrintOptions.LABEL).componentLabel("tLogRow_1").componentName("notPrinted").build();
        ImmutableTLogRowForEachBatchWriter tLogRowForEachBatchWriter = ImmutableTLogRowForEachBatchWriter.builder().loggerMode((WithLoggerMode)verticalTableLoggerMode).build();
        ImmutableTLogRow.Dataframe tLogRow = ImmutableTLogRow.Dataframe.builder().input(inputDataframe).tLogRowForEachBatchWriter((TLogRowForEachBatchWriter)tLogRowForEachBatchWriter).build();
        List<String> collectedStringList = ConsoleLinesCaptor.getCapturedTableLinesList(() -> {
            try {
                tLogRow.start().awaitTermination(10000L);
            }
            catch (TimeoutException | StreamingQueryException e) {
                throw new RuntimeException(e);
            }
        });
        collectedStringList.forEach(System.out::println);
        Assertions.assertEquals((int)2, (int)collectedStringList.size());
        Assertions.assertEquals((Object)".--------------------------------.\n|         #12. tLogRow_1         |\n+----------+---------------------+\n| key      | value               |\n+----------+---------------------+\n| t_Boolean| true                |\n| t_Byte   | 1                   |\n| t_byteArray| 123                 |\n| t_Date   | 05-06-2020          |\n| t_TimeStamp| 2020-06-05 12:00:00 |\n| t_Double | 1.0                 |\n| t_Float  | 1.0                 |\n| t_Integer| 1                   |\n| t_Long   | 1                   |\n| t_Short  | 1                   |\n| t_String | abc                 |\n| t_Char   | a                   |\n+----------+---------------------+\n", (Object)collectedStringList.get(0));
        Assertions.assertEquals((Object)".--------------------------------.\n|         #12. tLogRow_1         |\n+----------+---------------------+\n| key      | value               |\n+----------+---------------------+\n| t_Boolean| false               |\n| t_Byte   | 9                   |\n| t_byteArray| 789                 |\n| t_Date   | 06-06-2020          |\n| t_TimeStamp| 2020-06-06 12:00:00 |\n| t_Double | 9.0                 |\n| t_Float  | 9.0                 |\n| t_Integer| 9                   |\n| t_Long   | 9                   |\n| t_Short  | 9                   |\n| t_String | xyz                 |\n| t_Char   | z                   |\n+----------+---------------------+\n", (Object)collectedStringList.get(1));
    }

    @Test
    void test_log_verticalMode_printBothLabelName() throws IOException, URISyntaxException {
        Path parquetDir = this.testWorkingFolder.resolve("datafiles/parquet/");
        TestUtils.getResourceFileUrlInsideTempFolder((String)"datafiles/parquet/testFile_1.parquet", (String)parquetDir.toString(), this.getClass());
        Dataset inputDataframe = ImmutableTFileInputParquet.builder().sparkSession(sparkSession).addAllSchemaFieldDescriptions(TestUtil.immutableSchemaStructureFieldDescriptionList).addPaths(parquetDir.resolve(DATAFILES_PARQUET).toAbsolutePath() + File.separator).build().read();
        ImmutableVerticalTableLoggerMode verticalTableLoggerMode = ImmutableVerticalTableLoggerMode.builder().addAllSchemaFieldDescriptions(TestUtil.immutableSchemaStructureFieldDescriptionList).verticalTitlePrintOption(VerticalTableLoggerMode.VerticalTitlePrintOptions.BOTH).componentLabel("tLogRow_1_label").componentName("tLogRow_1_name").build();
        ImmutableTLogRowForEachBatchWriter tLogRowForEachBatchWriter = ImmutableTLogRowForEachBatchWriter.builder().loggerMode((WithLoggerMode)verticalTableLoggerMode).build();
        ImmutableTLogRow.Dataframe tLogRow = ImmutableTLogRow.Dataframe.builder().input(inputDataframe).tLogRowForEachBatchWriter((TLogRowForEachBatchWriter)tLogRowForEachBatchWriter).build();
        List<String> collectedStringList = ConsoleLinesCaptor.getCapturedTableLinesList(() -> {
            try {
                tLogRow.start().awaitTermination(10000L);
            }
            catch (TimeoutException | StreamingQueryException e) {
                throw new RuntimeException(e);
            }
        });
        collectedStringList.forEach(System.out::println);
        Assertions.assertEquals((int)2, (int)collectedStringList.size());
        Assertions.assertEquals((Object)".--------------------------------.\n|#12. tLogRow_1_name--tLogRow_1_label|\n+----------+---------------------+\n| key      | value               |\n+----------+---------------------+\n| t_Boolean| true                |\n| t_Byte   | 1                   |\n| t_byteArray| 123                 |\n| t_Date   | 05-06-2020          |\n| t_TimeStamp| 2020-06-05 12:00:00 |\n| t_Double | 1.0                 |\n| t_Float  | 1.0                 |\n| t_Integer| 1                   |\n| t_Long   | 1                   |\n| t_Short  | 1                   |\n| t_String | abc                 |\n| t_Char   | a                   |\n+----------+---------------------+\n", (Object)collectedStringList.get(0));
        Assertions.assertEquals((Object)".--------------------------------.\n|#12. tLogRow_1_name--tLogRow_1_label|\n+----------+---------------------+\n| key      | value               |\n+----------+---------------------+\n| t_Boolean| false               |\n| t_Byte   | 9                   |\n| t_byteArray| 789                 |\n| t_Date   | 06-06-2020          |\n| t_TimeStamp| 2020-06-06 12:00:00 |\n| t_Double | 9.0                 |\n| t_Float  | 9.0                 |\n| t_Integer| 9                   |\n| t_Long   | 9                   |\n| t_Short  | 9                   |\n| t_String | xyz                 |\n| t_Char   | z                   |\n+----------+---------------------+\n", (Object)collectedStringList.get(1));
    }
}

