/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.processing.fields;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import org.immutables.value.Generated;
import org.talend.bigdata.common.Component;
import org.talend.bigdata.structuredstreaming.processing.fields.TWriteAvroFields;

@ParametersAreNonnullByDefault
@Generated(from="TWriteAvroFields", generator="Immutables")
public final class ImmutableTWriteAvroFields {
    private ImmutableTWriteAvroFields() {
    }

    @CheckReturnValue
    @Generated(from="TWriteAvroFields.Dataframe", generator="Immutables")
    @Immutable
    public static final class Dataframe<T extends SpecificRecordBase>
    extends TWriteAvroFields.Dataframe<T> {
        private final ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions;
        private final StructType outputRowStruct;
        private final Map<String, Component.SchemaFieldDescription> schemaFieldDescriptionsMap;
        private final T avroRecord;
        private final Dataset<Row> inputDataset;
        private final Dataset<Row> binaryRecordFromAvro;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private Dataframe(Builder<T> builder) {
            this.schemaFieldDescriptions = builder.schemaFieldDescriptions.build();
            this.avroRecord = builder.avroRecord;
            this.inputDataset = builder.inputDataset;
            if (builder.binaryRecordFromAvro != null) {
                this.initShim.binaryRecordFromAvro(builder.binaryRecordFromAvro);
            }
            this.outputRowStruct = this.initShim.getOutputRowStruct();
            this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
            this.binaryRecordFromAvro = this.initShim.getBinaryRecordFromAvro();
            this.initShim = null;
        }

        private Dataframe(ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions, T avroRecord, Dataset<Row> inputDataset, Dataset<Row> binaryRecordFromAvro) {
            this.schemaFieldDescriptions = schemaFieldDescriptions;
            this.avroRecord = avroRecord;
            this.inputDataset = inputDataset;
            this.initShim.binaryRecordFromAvro(binaryRecordFromAvro);
            this.outputRowStruct = this.initShim.getOutputRowStruct();
            this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
            this.binaryRecordFromAvro = this.initShim.getBinaryRecordFromAvro();
            this.initShim = null;
        }

        public ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions() {
            return this.schemaFieldDescriptions;
        }

        public StructType getOutputRowStruct() {
            InitShim shim = this.initShim;
            return shim != null ? shim.getOutputRowStruct() : this.outputRowStruct;
        }

        public Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMap() {
            InitShim shim = this.initShim;
            return shim != null ? shim.getSchemaFieldDescriptionsMap() : this.schemaFieldDescriptionsMap;
        }

        @Override
        public T avroRecord() {
            return this.avroRecord;
        }

        @Override
        Dataset<Row> inputDataset() {
            return this.inputDataset;
        }

        @Override
        public Dataset<Row> getBinaryRecordFromAvro() {
            InitShim shim = this.initShim;
            return shim != null ? shim.getBinaryRecordFromAvro() : this.binaryRecordFromAvro;
        }

        public final Dataframe<T> withSchemaFieldDescriptions(Component.SchemaFieldDescription ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new Dataframe<T>((ImmutableList<Component.SchemaFieldDescription>)newValue, this.avroRecord, this.inputDataset, this.binaryRecordFromAvro);
        }

        public final Dataframe<T> withSchemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
            if (this.schemaFieldDescriptions == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new Dataframe<T>((ImmutableList<Component.SchemaFieldDescription>)newValue, this.avroRecord, this.inputDataset, this.binaryRecordFromAvro);
        }

        public final Dataframe<T> withAvroRecord(T value) {
            if (this.avroRecord == value) {
                return this;
            }
            SpecificRecordBase newValue = (SpecificRecordBase)Objects.requireNonNull(value, "avroRecord");
            return new Dataframe<SpecificRecordBase>(this.schemaFieldDescriptions, newValue, this.inputDataset, this.binaryRecordFromAvro);
        }

        public final Dataframe<T> withInputDataset(Dataset<Row> value) {
            if (this.inputDataset == value) {
                return this;
            }
            Dataset<Row> newValue = Objects.requireNonNull(value, "inputDataset");
            return new Dataframe<T>(this.schemaFieldDescriptions, this.avroRecord, newValue, this.binaryRecordFromAvro);
        }

        public final Dataframe<T> withBinaryRecordFromAvro(Dataset<Row> value) {
            if (this.binaryRecordFromAvro == value) {
                return this;
            }
            Dataset<Row> newValue = Objects.requireNonNull(value, "binaryRecordFromAvro");
            return new Dataframe<T>(this.schemaFieldDescriptions, this.avroRecord, this.inputDataset, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Dataframe && this.equalTo(0, (Dataframe)another);
        }

        private boolean equalTo(int synthetic, Dataframe<?> another) {
            return this.schemaFieldDescriptions.equals(another.schemaFieldDescriptions) && this.outputRowStruct.equals((Object)another.outputRowStruct) && this.schemaFieldDescriptionsMap.equals(another.schemaFieldDescriptionsMap) && this.avroRecord.equals(another.avroRecord) && this.inputDataset.equals(another.inputDataset) && this.binaryRecordFromAvro.equals(another.binaryRecordFromAvro);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.schemaFieldDescriptions.hashCode();
            h += (h << 5) + this.outputRowStruct.hashCode();
            h += (h << 5) + this.schemaFieldDescriptionsMap.hashCode();
            h += (h << 5) + this.avroRecord.hashCode();
            h += (h << 5) + this.inputDataset.hashCode();
            h += (h << 5) + this.binaryRecordFromAvro.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Dataframe").omitNullValues().add("schemaFieldDescriptions", this.schemaFieldDescriptions).add("outputRowStruct", (Object)this.outputRowStruct).add("schemaFieldDescriptionsMap", this.schemaFieldDescriptionsMap).add("avroRecord", this.avroRecord).add("inputDataset", this.inputDataset).add("binaryRecordFromAvro", this.binaryRecordFromAvro).toString();
        }

        public static <T extends SpecificRecordBase> Dataframe<T> copyOf(TWriteAvroFields.Dataframe<T> instance) {
            if (instance instanceof Dataframe) {
                return (Dataframe)instance;
            }
            return Dataframe.builder().from(instance).build();
        }

        public static <T extends SpecificRecordBase> Builder<T> builder() {
            return new Builder();
        }

        @Generated(from="TWriteAvroFields.Dataframe", generator="Immutables")
        private final class InitShim {
            private byte outputRowStructBuildStage = 0;
            private StructType outputRowStruct;
            private byte schemaFieldDescriptionsMapBuildStage = 0;
            private Map<String, Component.SchemaFieldDescription> schemaFieldDescriptionsMap;
            private byte binaryRecordFromAvroBuildStage = 0;
            private Dataset<Row> binaryRecordFromAvro;

            private InitShim() {
            }

            StructType getOutputRowStruct() {
                if (this.outputRowStructBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.outputRowStructBuildStage == 0) {
                    this.outputRowStructBuildStage = (byte)-1;
                    this.outputRowStruct = Objects.requireNonNull(Dataframe.super.getOutputRowStruct(), "outputRowStruct");
                    this.outputRowStructBuildStage = 1;
                }
                return this.outputRowStruct;
            }

            Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMap() {
                if (this.schemaFieldDescriptionsMapBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.schemaFieldDescriptionsMapBuildStage == 0) {
                    this.schemaFieldDescriptionsMapBuildStage = (byte)-1;
                    this.schemaFieldDescriptionsMap = Objects.requireNonNull(Dataframe.super.getSchemaFieldDescriptionsMap(), "schemaFieldDescriptionsMap");
                    this.schemaFieldDescriptionsMapBuildStage = 1;
                }
                return this.schemaFieldDescriptionsMap;
            }

            Dataset<Row> getBinaryRecordFromAvro() {
                if (this.binaryRecordFromAvroBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.binaryRecordFromAvroBuildStage == 0) {
                    this.binaryRecordFromAvroBuildStage = (byte)-1;
                    this.binaryRecordFromAvro = Objects.requireNonNull(Dataframe.super.getBinaryRecordFromAvro(), "binaryRecordFromAvro");
                    this.binaryRecordFromAvroBuildStage = 1;
                }
                return this.binaryRecordFromAvro;
            }

            void binaryRecordFromAvro(Dataset<Row> binaryRecordFromAvro) {
                this.binaryRecordFromAvro = binaryRecordFromAvro;
                this.binaryRecordFromAvroBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.outputRowStructBuildStage == -1) {
                    attributes.add("outputRowStruct");
                }
                if (this.schemaFieldDescriptionsMapBuildStage == -1) {
                    attributes.add("schemaFieldDescriptionsMap");
                }
                if (this.binaryRecordFromAvroBuildStage == -1) {
                    attributes.add("binaryRecordFromAvro");
                }
                return "Cannot build Dataframe, attribute initializers form cycle " + attributes;
            }
        }

        @Generated(from="TWriteAvroFields.Dataframe", generator="Immutables")
        @NotThreadSafe
        public static final class Builder<T extends SpecificRecordBase> {
            private static final long INIT_BIT_AVRO_RECORD = 1L;
            private static final long INIT_BIT_INPUT_DATASET = 2L;
            private long initBits = 3L;
            private ImmutableList.Builder<Component.SchemaFieldDescription> schemaFieldDescriptions = ImmutableList.builder();
            @Nullable
            private T avroRecord;
            @Nullable
            private Dataset<Row> inputDataset;
            @Nullable
            private Dataset<Row> binaryRecordFromAvro;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder<T> from(Component.WithSchemaDescription instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder<T> from(TWriteAvroFields.Dataframe<T> instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                Component.WithSchemaDescription instance;
                long bits = 0L;
                if (object instanceof Component.WithSchemaDescription) {
                    instance = (Component.WithSchemaDescription)object;
                    if ((bits & 1L) == 0L) {
                        this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                        bits |= 1L;
                    }
                }
                if (object instanceof TWriteAvroFields.Dataframe) {
                    instance = (TWriteAvroFields.Dataframe)object;
                    this.binaryRecordFromAvro(instance.getBinaryRecordFromAvro());
                    if ((bits & 1L) == 0L) {
                        this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                        bits |= 1L;
                    }
                    this.inputDataset(instance.inputDataset());
                    this.avroRecord(instance.avroRecord());
                }
            }

            @CanIgnoreReturnValue
            public final Builder<T> addSchemaFieldDescriptions(Component.SchemaFieldDescription element) {
                this.schemaFieldDescriptions.add((Object)element);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder<T> addSchemaFieldDescriptions(Component.SchemaFieldDescription ... elements) {
                this.schemaFieldDescriptions.add((Object[])elements);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder<T> schemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
                this.schemaFieldDescriptions = ImmutableList.builder();
                return this.addAllSchemaFieldDescriptions(elements);
            }

            @CanIgnoreReturnValue
            public final Builder<T> addAllSchemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
                this.schemaFieldDescriptions.addAll(elements);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder<T> avroRecord(T avroRecord) {
                this.avroRecord = (SpecificRecordBase)Objects.requireNonNull(avroRecord, "avroRecord");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder<T> inputDataset(Dataset<Row> inputDataset) {
                this.inputDataset = Objects.requireNonNull(inputDataset, "inputDataset");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder<T> binaryRecordFromAvro(Dataset<Row> binaryRecordFromAvro) {
                this.binaryRecordFromAvro = Objects.requireNonNull(binaryRecordFromAvro, "binaryRecordFromAvro");
                return this;
            }

            public Dataframe<T> build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Dataframe(this);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("avroRecord");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("inputDataset");
                }
                return "Cannot build Dataframe, some of required attributes are not set " + attributes;
            }
        }
    }
}

