/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.common;

import java.util.List;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.talend.bigdata.common.Component;

public class SchemaUtil {
    public static StructType generateStructType(List<Component.SchemaFieldDescription> schemaFieldDescriptions) {
        StructField[] fields = (StructField[])schemaFieldDescriptions.stream().map(desc -> new StructField(desc.name(), SchemaUtil.mapToSparkType(desc.type(), desc.precision(), desc.scale()), desc.isNullable(), Metadata.empty())).toArray(StructField[]::new);
        return new StructType(fields);
    }

    private static DataType mapToSparkType(String type, int precision, int scale) {
        return switch (type) {
            case "java.lang.String" -> DataTypes.StringType;
            case "java.lang.Integer", "java.lang.Long" -> DataTypes.LongType;
            case "java.lang.Float" -> DataTypes.FloatType;
            case "java.lang.Double" -> DataTypes.DoubleType;
            case "java.lang.Boolean" -> DataTypes.BooleanType;
            case "java.sql.Timestamp" -> DataTypes.TimestampType;
            case "byte[]" -> DataTypes.BinaryType;
            case "java.lang.Byte" -> DataTypes.ByteType;
            case "java.lang.Short" -> DataTypes.ShortType;
            case "java.math.BigDecimal" -> DataTypes.createDecimalType((int)precision, (int)scale);
            default -> throw new IllegalArgumentException("Unsupported field type: " + type);
        };
    }
}

