/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.common.output;

import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.DataStreamWriter;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.immutables.value.Value;
import org.talend.bigdata.structuredstreaming.common.output.StreamWriter;

public interface FileWriter
extends StreamWriter {
    @Value.Parameter
    public SparkSession sparkSession();

    @Value.Parameter
    public String path();

    @Value.Parameter
    public FileFormat format();

    @Override
    @Value.Derived
    default public OutputMode outputMode() {
        return OutputMode.Append();
    }

    @Override
    default public DataStreamWriter<Row> writer() {
        return StreamWriter.super.writer().format(this.format().getFormatName());
    }

    @Override
    default public DataStreamWriter<Row> writer(Dataset<Row> input) {
        return StreamWriter.super.writer(input).format(this.format().getFormatName());
    }

    default public String resolveOutputPath() {
        String path = this.path();
        if (path == null || path.isBlank()) {
            throw new IllegalArgumentException("Output path is empty");
        }
        if (path.matches("^[a-zA-Z][a-zA-Z0-9+.-]*://.*")) {
            return path;
        }
        Object base = this.sparkSession().sparkContext().hadoopConfiguration().get("fs.defaultFS");
        if (base == null || ((String)base).isBlank()) {
            return path;
        }
        if (!((String)base).endsWith("/")) {
            base = (String)base + "/";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return (String)base + path;
    }

    default public StreamingQuery start(DataStreamWriter<Row> dataStreamWriter) {
        return dataStreamWriter.start(this.path());
    }

    public static enum FileFormat {
        PARQUET("parquet"),
        JSON("json"),
        CSV("csv"),
        ORC("orc"),
        TEXT("text"),
        AVRO("avro");

        private final String formatName;

        private FileFormat(String formatName) {
            this.formatName = formatName;
        }

        public String getFormatName() {
            return this.formatName;
        }
    }
}

