/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.parquet;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.api.java.UDF2;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataTypes;
import org.immutables.value.Value;
import org.talend.bigdata.common.Component;
import org.talend.bigdata.common.tfileinput.parquet.tFileInputParquetBase;
import org.talend.bigdata.structuredstreaming.common.input.StreamReader;

@Value.Immutable
public interface TFileInputParquet
extends tFileInputParquetBase,
StreamReader {
    default public Dataset<Row> read() throws IOException, URISyntaxException {
        this.sparkSession().udf().register("forceTimeZone", (UDF2)new tFileInputParquetBase.ForceTimeZone(), DataTypes.TimestampType);
        Dataset<Row> ds = this.dataStreamReader().parquet((String)this.pathsWithPrefix().get(0));
        ds = this.applyLocalTimezoneIfNeeded(ds);
        return this.withWatermarking(ds);
    }

    default public Dataset<Row> applyLocalTimezoneIfNeeded(Dataset<Row> dataset) {
        List<Component.SchemaFieldDescription> dateFields;
        if (this.readDatesInLocalTimeZone() && !(dateFields = this.schemaFieldDescriptions().stream().filter(schemaFieldDescription -> schemaFieldDescription.type().equals("org.apache.spark.sql.types.DataTypes.TimestampType")).toList()).isEmpty()) {
            String sessionTimeZone = this.sparkSession().conf().get("spark.sql.session.timeZone");
            for (Component.SchemaFieldDescription schemaFieldDescription2 : dateFields) {
                dataset = dataset.withColumn(schemaFieldDescription2.name(), functions.callUDF((String)"forceTimeZone", (Column[])new Column[]{functions.col((String)schemaFieldDescription2.name()), functions.lit((Object)sessionTimeZone)}));
            }
        }
        return dataset;
    }
}

