/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.technical.tcollectandcheck;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.spark.api.java.function.VoidFunction2;
import org.apache.spark.sql.Dataset;
import org.immutables.value.Value;

@Value.Immutable
public abstract class TCollectAndCheckWriter
implements VoidFunction2<Dataset<String>, Long> {
    abstract Logger getLogger();

    @Value.Default
    String componentName() {
        return "TCollectAndCheck";
    }

    @Value.Default
    List<String> referenceDataList() {
        return new ArrayList<String>();
    }

    public void call(Dataset<String> stringDataset, Long aLong) throws Exception {
        System.out.println("REFERENCES : ");
        this.referenceDataList().forEach(System.out::println);
        if (stringDataset.isEmpty()) {
            this.getLogger().info("{} batch' was empty", (Object)this.componentName());
        }
        List incomingDataList = stringDataset.collectAsList();
        if (this.referenceDataList().size() != incomingDataList.size()) {
            throw new LogicalException("number of lines do not match, " + this.referenceDataList().size() + " lines expected but " + incomingDataList.size() + " lines found");
        }
        incomingDataList.forEach(incomingLine -> {
            if (!this.referenceDataList().contains(incomingLine)) {
                throw new LogicalException("this line was not expected : " + incomingLine);
            }
        });
        this.referenceDataList().forEach(referenceLine -> {
            if (!incomingDataList.contains(referenceLine)) {
                System.out.println("this line was expected " + referenceLine);
                throw new LogicalException("references are missing");
            }
        });
        this.getLogger().info("{} batch' data is correct", (Object)this.componentName());
    }

    @Value.Default
    boolean keepReferenceOrder() {
        return false;
    }

    public static class LogicalException
    extends RuntimeException {
        public LogicalException(String errorMessage) {
            super(errorMessage);
        }
    }
}

