/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.kafka;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.avro.Schema;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import org.immutables.value.Generated;
import org.talend.bigdata.common.Component;
import org.talend.bigdata.structuredstreaming.common.input.StreamReader;
import org.talend.bigdata.structuredstreaming.kafka.TKafkaConfiguration;
import org.talend.bigdata.structuredstreaming.kafka.TKafkaInputAvro;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TKafkaInputAvro", generator="Immutables")
@Immutable
public final class ImmutableTKafkaInputAvro
extends TKafkaInputAvro {
    private final ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions;
    private final StructType outputRowStruct;
    private final Map<String, Component.SchemaFieldDescription> schemaFieldDescriptionsMap;
    private final Class<Row> rowClass;
    private final Encoder<Row> encoder;
    private final JavaSparkContext context;
    private final ImmutableMap<String, String> options;
    @Nullable
    private final StreamReader.WatermarkingType enableWatermarking;
    @Nullable
    private final String watermarkColumn;
    @Nullable
    private final String watermarkDelay;
    @Nullable
    private final String format;
    private final SparkSession sparkSession;
    private final TKafkaConfiguration tKafkaConfiguration;
    private final ImmutableMap<String, String> mappings;
    private final String topic;
    private final String groupId;
    private final String startingOffset;
    private final boolean isSetNumberOfRecordsPerSecond;
    private final int numberOfRecordsPerSecond;
    private final ImmutableMap<String, String> kafKaPropertiesMap;
    private final boolean useHierarchicalMode;
    private final boolean failOnDataLoss;
    private final Schema specificRecordSchema;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTKafkaInputAvro(Builder builder) {
        this.schemaFieldDescriptions = builder.schemaFieldDescriptions.build();
        this.enableWatermarking = builder.enableWatermarking;
        this.watermarkColumn = builder.watermarkColumn;
        this.watermarkDelay = builder.watermarkDelay;
        this.format = builder.format;
        this.sparkSession = builder.sparkSession;
        this.tKafkaConfiguration = builder.tKafkaConfiguration;
        this.mappings = builder.mappings.build();
        this.specificRecordSchema = builder.specificRecordSchema;
        if (builder.rowClass != null) {
            this.initShim.rowClass(builder.rowClass);
        }
        if (builder.encoder != null) {
            this.initShim.encoder(builder.encoder);
        }
        if (builder.optionsIsSet()) {
            this.initShim.options((ImmutableMap<String, String>)builder.options.build());
        }
        if (builder.topic != null) {
            this.initShim.topic(builder.topic);
        }
        if (builder.groupId != null) {
            this.initShim.groupId(builder.groupId);
        }
        if (builder.startingOffset != null) {
            this.initShim.startingOffset(builder.startingOffset);
        }
        if (builder.isSetNumberOfRecordsPerSecondIsSet()) {
            this.initShim.isSetNumberOfRecordsPerSecond(builder.isSetNumberOfRecordsPerSecond);
        }
        if (builder.numberOfRecordsPerSecondIsSet()) {
            this.initShim.numberOfRecordsPerSecond(builder.numberOfRecordsPerSecond);
        }
        if (builder.kafKaPropertiesMapIsSet()) {
            this.initShim.kafKaPropertiesMap((ImmutableMap<String, String>)builder.kafKaPropertiesMap.build());
        }
        if (builder.useHierarchicalModeIsSet()) {
            this.initShim.useHierarchicalMode(builder.useHierarchicalMode);
        }
        if (builder.failOnDataLossIsSet()) {
            this.initShim.failOnDataLoss(builder.failOnDataLoss);
        }
        this.outputRowStruct = this.initShim.getOutputRowStruct();
        this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
        this.rowClass = this.initShim.rowClass();
        this.encoder = this.initShim.encoder();
        this.context = this.initShim.context();
        this.options = this.initShim.options();
        this.topic = this.initShim.topic();
        this.groupId = this.initShim.groupId();
        this.startingOffset = this.initShim.startingOffset();
        this.isSetNumberOfRecordsPerSecond = this.initShim.isSetNumberOfRecordsPerSecond();
        this.numberOfRecordsPerSecond = this.initShim.numberOfRecordsPerSecond();
        this.kafKaPropertiesMap = this.initShim.kafKaPropertiesMap();
        this.useHierarchicalMode = this.initShim.useHierarchicalMode();
        this.failOnDataLoss = this.initShim.failOnDataLoss();
        this.initShim = null;
    }

    private ImmutableTKafkaInputAvro(ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions, Class<Row> rowClass, Encoder<Row> encoder, ImmutableMap<String, String> options, @Nullable StreamReader.WatermarkingType enableWatermarking, @Nullable String watermarkColumn, @Nullable String watermarkDelay, @Nullable String format, SparkSession sparkSession, TKafkaConfiguration tKafkaConfiguration, ImmutableMap<String, String> mappings, String topic, String groupId, String startingOffset, boolean isSetNumberOfRecordsPerSecond, int numberOfRecordsPerSecond, ImmutableMap<String, String> kafKaPropertiesMap, boolean useHierarchicalMode, boolean failOnDataLoss, Schema specificRecordSchema) {
        this.schemaFieldDescriptions = schemaFieldDescriptions;
        this.initShim.rowClass(rowClass);
        this.initShim.encoder(encoder);
        this.initShim.options(options);
        this.enableWatermarking = enableWatermarking;
        this.watermarkColumn = watermarkColumn;
        this.watermarkDelay = watermarkDelay;
        this.format = format;
        this.sparkSession = sparkSession;
        this.tKafkaConfiguration = tKafkaConfiguration;
        this.mappings = mappings;
        this.initShim.topic(topic);
        this.initShim.groupId(groupId);
        this.initShim.startingOffset(startingOffset);
        this.initShim.isSetNumberOfRecordsPerSecond(isSetNumberOfRecordsPerSecond);
        this.initShim.numberOfRecordsPerSecond(numberOfRecordsPerSecond);
        this.initShim.kafKaPropertiesMap(kafKaPropertiesMap);
        this.initShim.useHierarchicalMode(useHierarchicalMode);
        this.initShim.failOnDataLoss(failOnDataLoss);
        this.specificRecordSchema = specificRecordSchema;
        this.outputRowStruct = this.initShim.getOutputRowStruct();
        this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
        this.rowClass = this.initShim.rowClass();
        this.encoder = this.initShim.encoder();
        this.context = this.initShim.context();
        this.options = this.initShim.options();
        this.topic = this.initShim.topic();
        this.groupId = this.initShim.groupId();
        this.startingOffset = this.initShim.startingOffset();
        this.isSetNumberOfRecordsPerSecond = this.initShim.isSetNumberOfRecordsPerSecond();
        this.numberOfRecordsPerSecond = this.initShim.numberOfRecordsPerSecond();
        this.kafKaPropertiesMap = this.initShim.kafKaPropertiesMap();
        this.useHierarchicalMode = this.initShim.useHierarchicalMode();
        this.failOnDataLoss = this.initShim.failOnDataLoss();
        this.initShim = null;
    }

    public ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions() {
        return this.schemaFieldDescriptions;
    }

    public StructType getOutputRowStruct() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOutputRowStruct() : this.outputRowStruct;
    }

    public Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSchemaFieldDescriptionsMap() : this.schemaFieldDescriptionsMap;
    }

    public Class<Row> rowClass() {
        InitShim shim = this.initShim;
        return shim != null ? shim.rowClass() : this.rowClass;
    }

    public Encoder<Row> encoder() {
        InitShim shim = this.initShim;
        return shim != null ? shim.encoder() : this.encoder;
    }

    public JavaSparkContext context() {
        InitShim shim = this.initShim;
        return shim != null ? shim.context() : this.context;
    }

    public ImmutableMap<String, String> options() {
        InitShim shim = this.initShim;
        return shim != null ? shim.options() : this.options;
    }

    @Override
    public Optional<StreamReader.WatermarkingType> enableWatermarking() {
        return Optional.ofNullable(this.enableWatermarking);
    }

    @Override
    public Optional<String> watermarkColumn() {
        return Optional.ofNullable(this.watermarkColumn);
    }

    @Override
    public Optional<String> watermarkDelay() {
        return Optional.ofNullable(this.watermarkDelay);
    }

    @Override
    public Optional<String> format() {
        return Optional.ofNullable(this.format);
    }

    @Override
    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    @Override
    public TKafkaConfiguration tKafkaConfiguration() {
        return this.tKafkaConfiguration;
    }

    public ImmutableMap<String, String> mappings() {
        return this.mappings;
    }

    @Override
    String topic() {
        InitShim shim = this.initShim;
        return shim != null ? shim.topic() : this.topic;
    }

    @Override
    String groupId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.groupId() : this.groupId;
    }

    @Override
    String startingOffset() {
        InitShim shim = this.initShim;
        return shim != null ? shim.startingOffset() : this.startingOffset;
    }

    @Override
    boolean isSetNumberOfRecordsPerSecond() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isSetNumberOfRecordsPerSecond() : this.isSetNumberOfRecordsPerSecond;
    }

    @Override
    int numberOfRecordsPerSecond() {
        InitShim shim = this.initShim;
        return shim != null ? shim.numberOfRecordsPerSecond() : this.numberOfRecordsPerSecond;
    }

    ImmutableMap<String, String> kafKaPropertiesMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.kafKaPropertiesMap() : this.kafKaPropertiesMap;
    }

    @Override
    boolean useHierarchicalMode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useHierarchicalMode() : this.useHierarchicalMode;
    }

    @Override
    boolean failOnDataLoss() {
        InitShim shim = this.initShim;
        return shim != null ? shim.failOnDataLoss() : this.failOnDataLoss;
    }

    @Override
    public Schema specificRecordSchema() {
        return this.specificRecordSchema;
    }

    public final ImmutableTKafkaInputAvro withSchemaFieldDescriptions(Component.SchemaFieldDescription ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTKafkaInputAvro((ImmutableList<Component.SchemaFieldDescription>)newValue, this.rowClass, this.encoder, this.options, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.sparkSession, this.tKafkaConfiguration, this.mappings, this.topic, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withSchemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
        if (this.schemaFieldDescriptions == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTKafkaInputAvro((ImmutableList<Component.SchemaFieldDescription>)newValue, this.rowClass, this.encoder, this.options, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.sparkSession, this.tKafkaConfiguration, this.mappings, this.topic, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withRowClass(Class<Row> value) {
        if (this.rowClass == value) {
            return this;
        }
        Class<Row> newValue = Objects.requireNonNull(value, "rowClass");
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, newValue, this.encoder, this.options, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.sparkSession, this.tKafkaConfiguration, this.mappings, this.topic, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withEncoder(Encoder<Row> value) {
        if (this.encoder == value) {
            return this;
        }
        Encoder<Row> newValue = Objects.requireNonNull(value, "encoder");
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, newValue, this.options, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.sparkSession, this.tKafkaConfiguration, this.mappings, this.topic, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withOptions(Map<String, ? extends String> entries) {
        if (this.options == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, this.encoder, (ImmutableMap<String, String>)newValue, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.sparkSession, this.tKafkaConfiguration, this.mappings, this.topic, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withEnableWatermarking(StreamReader.WatermarkingType value) {
        StreamReader.WatermarkingType newValue = Objects.requireNonNull(value, "enableWatermarking");
        if (this.enableWatermarking == newValue) {
            return this;
        }
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, this.encoder, this.options, newValue, this.watermarkColumn, this.watermarkDelay, this.format, this.sparkSession, this.tKafkaConfiguration, this.mappings, this.topic, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withEnableWatermarking(Optional<? extends StreamReader.WatermarkingType> optional) {
        StreamReader.WatermarkingType value = optional.orElse(null);
        if (this.enableWatermarking == value) {
            return this;
        }
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, this.encoder, this.options, value, this.watermarkColumn, this.watermarkDelay, this.format, this.sparkSession, this.tKafkaConfiguration, this.mappings, this.topic, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withWatermarkColumn(String value) {
        String newValue = Objects.requireNonNull(value, "watermarkColumn");
        if (Objects.equals(this.watermarkColumn, newValue)) {
            return this;
        }
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, this.encoder, this.options, this.enableWatermarking, newValue, this.watermarkDelay, this.format, this.sparkSession, this.tKafkaConfiguration, this.mappings, this.topic, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withWatermarkColumn(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.watermarkColumn, value)) {
            return this;
        }
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, this.encoder, this.options, this.enableWatermarking, value, this.watermarkDelay, this.format, this.sparkSession, this.tKafkaConfiguration, this.mappings, this.topic, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withWatermarkDelay(String value) {
        String newValue = Objects.requireNonNull(value, "watermarkDelay");
        if (Objects.equals(this.watermarkDelay, newValue)) {
            return this;
        }
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, this.encoder, this.options, this.enableWatermarking, this.watermarkColumn, newValue, this.format, this.sparkSession, this.tKafkaConfiguration, this.mappings, this.topic, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withWatermarkDelay(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.watermarkDelay, value)) {
            return this;
        }
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, this.encoder, this.options, this.enableWatermarking, this.watermarkColumn, value, this.format, this.sparkSession, this.tKafkaConfiguration, this.mappings, this.topic, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withFormat(String value) {
        String newValue = Objects.requireNonNull(value, "format");
        if (Objects.equals(this.format, newValue)) {
            return this;
        }
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, this.encoder, this.options, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, newValue, this.sparkSession, this.tKafkaConfiguration, this.mappings, this.topic, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withFormat(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.format, value)) {
            return this;
        }
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, this.encoder, this.options, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, value, this.sparkSession, this.tKafkaConfiguration, this.mappings, this.topic, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withSparkSession(SparkSession value) {
        if (this.sparkSession == value) {
            return this;
        }
        SparkSession newValue = Objects.requireNonNull(value, "sparkSession");
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, this.encoder, this.options, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, newValue, this.tKafkaConfiguration, this.mappings, this.topic, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withTKafkaConfiguration(TKafkaConfiguration value) {
        if (this.tKafkaConfiguration == value) {
            return this;
        }
        TKafkaConfiguration newValue = Objects.requireNonNull(value, "tKafkaConfiguration");
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, this.encoder, this.options, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.sparkSession, newValue, this.mappings, this.topic, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withMappings(Map<String, ? extends String> entries) {
        if (this.mappings == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, this.encoder, this.options, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.sparkSession, this.tKafkaConfiguration, (ImmutableMap<String, String>)newValue, this.topic, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withTopic(String value) {
        String newValue = Objects.requireNonNull(value, "topic");
        if (this.topic.equals(newValue)) {
            return this;
        }
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, this.encoder, this.options, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.sparkSession, this.tKafkaConfiguration, this.mappings, newValue, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withGroupId(String value) {
        String newValue = Objects.requireNonNull(value, "groupId");
        if (this.groupId.equals(newValue)) {
            return this;
        }
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, this.encoder, this.options, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.sparkSession, this.tKafkaConfiguration, this.mappings, this.topic, newValue, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withStartingOffset(String value) {
        String newValue = Objects.requireNonNull(value, "startingOffset");
        if (this.startingOffset.equals(newValue)) {
            return this;
        }
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, this.encoder, this.options, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.sparkSession, this.tKafkaConfiguration, this.mappings, this.topic, this.groupId, newValue, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withIsSetNumberOfRecordsPerSecond(boolean value) {
        if (this.isSetNumberOfRecordsPerSecond == value) {
            return this;
        }
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, this.encoder, this.options, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.sparkSession, this.tKafkaConfiguration, this.mappings, this.topic, this.groupId, this.startingOffset, value, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withNumberOfRecordsPerSecond(int value) {
        if (this.numberOfRecordsPerSecond == value) {
            return this;
        }
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, this.encoder, this.options, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.sparkSession, this.tKafkaConfiguration, this.mappings, this.topic, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, value, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withKafKaPropertiesMap(Map<String, ? extends String> entries) {
        if (this.kafKaPropertiesMap == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, this.encoder, this.options, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.sparkSession, this.tKafkaConfiguration, this.mappings, this.topic, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, (ImmutableMap<String, String>)newValue, this.useHierarchicalMode, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withUseHierarchicalMode(boolean value) {
        if (this.useHierarchicalMode == value) {
            return this;
        }
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, this.encoder, this.options, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.sparkSession, this.tKafkaConfiguration, this.mappings, this.topic, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, value, this.failOnDataLoss, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withFailOnDataLoss(boolean value) {
        if (this.failOnDataLoss == value) {
            return this;
        }
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, this.encoder, this.options, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.sparkSession, this.tKafkaConfiguration, this.mappings, this.topic, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, value, this.specificRecordSchema);
    }

    public final ImmutableTKafkaInputAvro withSpecificRecordSchema(Schema value) {
        if (this.specificRecordSchema == value) {
            return this;
        }
        Schema newValue = Objects.requireNonNull(value, "specificRecordSchema");
        return new ImmutableTKafkaInputAvro(this.schemaFieldDescriptions, this.rowClass, this.encoder, this.options, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.sparkSession, this.tKafkaConfiguration, this.mappings, this.topic, this.groupId, this.startingOffset, this.isSetNumberOfRecordsPerSecond, this.numberOfRecordsPerSecond, this.kafKaPropertiesMap, this.useHierarchicalMode, this.failOnDataLoss, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTKafkaInputAvro && this.equalTo(0, (ImmutableTKafkaInputAvro)another);
    }

    private boolean equalTo(int synthetic, ImmutableTKafkaInputAvro another) {
        return this.schemaFieldDescriptions.equals(another.schemaFieldDescriptions) && this.outputRowStruct.equals((Object)another.outputRowStruct) && this.schemaFieldDescriptionsMap.equals(another.schemaFieldDescriptionsMap) && this.rowClass.equals(another.rowClass) && this.encoder.equals(another.encoder) && this.context.equals(another.context) && this.options.equals(another.options) && Objects.equals((Object)this.enableWatermarking, (Object)another.enableWatermarking) && Objects.equals(this.watermarkColumn, another.watermarkColumn) && Objects.equals(this.watermarkDelay, another.watermarkDelay) && Objects.equals(this.format, another.format) && this.sparkSession.equals(another.sparkSession) && this.tKafkaConfiguration.equals(another.tKafkaConfiguration) && this.mappings.equals(another.mappings) && this.topic.equals(another.topic) && this.groupId.equals(another.groupId) && this.startingOffset.equals(another.startingOffset) && this.isSetNumberOfRecordsPerSecond == another.isSetNumberOfRecordsPerSecond && this.numberOfRecordsPerSecond == another.numberOfRecordsPerSecond && this.kafKaPropertiesMap.equals(another.kafKaPropertiesMap) && this.useHierarchicalMode == another.useHierarchicalMode && this.failOnDataLoss == another.failOnDataLoss && this.specificRecordSchema.equals((Object)another.specificRecordSchema);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.schemaFieldDescriptions.hashCode();
        h += (h << 5) + this.outputRowStruct.hashCode();
        h += (h << 5) + this.schemaFieldDescriptionsMap.hashCode();
        h += (h << 5) + this.rowClass.hashCode();
        h += (h << 5) + this.encoder.hashCode();
        h += (h << 5) + this.context.hashCode();
        h += (h << 5) + this.options.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.enableWatermarking);
        h += (h << 5) + Objects.hashCode(this.watermarkColumn);
        h += (h << 5) + Objects.hashCode(this.watermarkDelay);
        h += (h << 5) + Objects.hashCode(this.format);
        h += (h << 5) + this.sparkSession.hashCode();
        h += (h << 5) + this.tKafkaConfiguration.hashCode();
        h += (h << 5) + this.mappings.hashCode();
        h += (h << 5) + this.topic.hashCode();
        h += (h << 5) + this.groupId.hashCode();
        h += (h << 5) + this.startingOffset.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.isSetNumberOfRecordsPerSecond);
        h += (h << 5) + this.numberOfRecordsPerSecond;
        h += (h << 5) + this.kafKaPropertiesMap.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.useHierarchicalMode);
        h += (h << 5) + Booleans.hashCode((boolean)this.failOnDataLoss);
        h += (h << 5) + this.specificRecordSchema.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TKafkaInputAvro").omitNullValues().add("schemaFieldDescriptions", this.schemaFieldDescriptions).add("outputRowStruct", (Object)this.outputRowStruct).add("schemaFieldDescriptionsMap", this.schemaFieldDescriptionsMap).add("rowClass", this.rowClass).add("encoder", this.encoder).add("context", (Object)this.context).add("options", this.options).add("enableWatermarking", (Object)this.enableWatermarking).add("watermarkColumn", (Object)this.watermarkColumn).add("watermarkDelay", (Object)this.watermarkDelay).add("format", (Object)this.format).add("sparkSession", (Object)this.sparkSession).add("tKafkaConfiguration", (Object)this.tKafkaConfiguration).add("mappings", this.mappings).add("topic", (Object)this.topic).add("groupId", (Object)this.groupId).add("startingOffset", (Object)this.startingOffset).add("isSetNumberOfRecordsPerSecond", this.isSetNumberOfRecordsPerSecond).add("numberOfRecordsPerSecond", this.numberOfRecordsPerSecond).add("kafKaPropertiesMap", this.kafKaPropertiesMap).add("useHierarchicalMode", this.useHierarchicalMode).add("failOnDataLoss", this.failOnDataLoss).add("specificRecordSchema", (Object)this.specificRecordSchema).toString();
    }

    public static ImmutableTKafkaInputAvro copyOf(TKafkaInputAvro instance) {
        if (instance instanceof ImmutableTKafkaInputAvro) {
            return (ImmutableTKafkaInputAvro)instance;
        }
        return ImmutableTKafkaInputAvro.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TKafkaInputAvro", generator="Immutables")
    private final class InitShim {
        private byte outputRowStructBuildStage = 0;
        private StructType outputRowStruct;
        private byte schemaFieldDescriptionsMapBuildStage = 0;
        private Map<String, Component.SchemaFieldDescription> schemaFieldDescriptionsMap;
        private byte rowClassBuildStage = 0;
        private Class<Row> rowClass;
        private byte encoderBuildStage = 0;
        private Encoder<Row> encoder;
        private byte contextBuildStage = 0;
        private JavaSparkContext context;
        private byte optionsBuildStage = 0;
        private ImmutableMap<String, String> options;
        private byte topicBuildStage = 0;
        private String topic;
        private byte groupIdBuildStage = 0;
        private String groupId;
        private byte startingOffsetBuildStage = 0;
        private String startingOffset;
        private byte isSetNumberOfRecordsPerSecondBuildStage = 0;
        private boolean isSetNumberOfRecordsPerSecond;
        private byte numberOfRecordsPerSecondBuildStage = 0;
        private int numberOfRecordsPerSecond;
        private byte kafKaPropertiesMapBuildStage = 0;
        private ImmutableMap<String, String> kafKaPropertiesMap;
        private byte useHierarchicalModeBuildStage = 0;
        private boolean useHierarchicalMode;
        private byte failOnDataLossBuildStage = 0;
        private boolean failOnDataLoss;

        private InitShim() {
        }

        StructType getOutputRowStruct() {
            if (this.outputRowStructBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outputRowStructBuildStage == 0) {
                this.outputRowStructBuildStage = (byte)-1;
                this.outputRowStruct = Objects.requireNonNull(ImmutableTKafkaInputAvro.super.getOutputRowStruct(), "outputRowStruct");
                this.outputRowStructBuildStage = 1;
            }
            return this.outputRowStruct;
        }

        Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMap() {
            if (this.schemaFieldDescriptionsMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.schemaFieldDescriptionsMapBuildStage == 0) {
                this.schemaFieldDescriptionsMapBuildStage = (byte)-1;
                this.schemaFieldDescriptionsMap = Objects.requireNonNull(ImmutableTKafkaInputAvro.super.getSchemaFieldDescriptionsMap(), "schemaFieldDescriptionsMap");
                this.schemaFieldDescriptionsMapBuildStage = 1;
            }
            return this.schemaFieldDescriptionsMap;
        }

        Class<Row> rowClass() {
            if (this.rowClassBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rowClassBuildStage == 0) {
                this.rowClassBuildStage = (byte)-1;
                this.rowClass = Objects.requireNonNull(ImmutableTKafkaInputAvro.super.rowClass(), "rowClass");
                this.rowClassBuildStage = 1;
            }
            return this.rowClass;
        }

        void rowClass(Class<Row> rowClass) {
            this.rowClass = rowClass;
            this.rowClassBuildStage = 1;
        }

        Encoder<Row> encoder() {
            if (this.encoderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.encoderBuildStage == 0) {
                this.encoderBuildStage = (byte)-1;
                this.encoder = Objects.requireNonNull(ImmutableTKafkaInputAvro.super.encoder(), "encoder");
                this.encoderBuildStage = 1;
            }
            return this.encoder;
        }

        void encoder(Encoder<Row> encoder) {
            this.encoder = encoder;
            this.encoderBuildStage = 1;
        }

        JavaSparkContext context() {
            if (this.contextBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.contextBuildStage == 0) {
                this.contextBuildStage = (byte)-1;
                this.context = Objects.requireNonNull(ImmutableTKafkaInputAvro.super.context(), "context");
                this.contextBuildStage = 1;
            }
            return this.context;
        }

        ImmutableMap<String, String> options() {
            if (this.optionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.optionsBuildStage == 0) {
                this.optionsBuildStage = (byte)-1;
                this.options = ImmutableMap.copyOf((Map)ImmutableTKafkaInputAvro.super.options());
                this.optionsBuildStage = 1;
            }
            return this.options;
        }

        void options(ImmutableMap<String, String> options) {
            this.options = options;
            this.optionsBuildStage = 1;
        }

        String topic() {
            if (this.topicBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.topicBuildStage == 0) {
                this.topicBuildStage = (byte)-1;
                this.topic = Objects.requireNonNull(ImmutableTKafkaInputAvro.super.topic(), "topic");
                this.topicBuildStage = 1;
            }
            return this.topic;
        }

        void topic(String topic) {
            this.topic = topic;
            this.topicBuildStage = 1;
        }

        String groupId() {
            if (this.groupIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.groupIdBuildStage == 0) {
                this.groupIdBuildStage = (byte)-1;
                this.groupId = Objects.requireNonNull(ImmutableTKafkaInputAvro.super.groupId(), "groupId");
                this.groupIdBuildStage = 1;
            }
            return this.groupId;
        }

        void groupId(String groupId) {
            this.groupId = groupId;
            this.groupIdBuildStage = 1;
        }

        String startingOffset() {
            if (this.startingOffsetBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.startingOffsetBuildStage == 0) {
                this.startingOffsetBuildStage = (byte)-1;
                this.startingOffset = Objects.requireNonNull(ImmutableTKafkaInputAvro.super.startingOffset(), "startingOffset");
                this.startingOffsetBuildStage = 1;
            }
            return this.startingOffset;
        }

        void startingOffset(String startingOffset) {
            this.startingOffset = startingOffset;
            this.startingOffsetBuildStage = 1;
        }

        boolean isSetNumberOfRecordsPerSecond() {
            if (this.isSetNumberOfRecordsPerSecondBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isSetNumberOfRecordsPerSecondBuildStage == 0) {
                this.isSetNumberOfRecordsPerSecondBuildStage = (byte)-1;
                this.isSetNumberOfRecordsPerSecond = ImmutableTKafkaInputAvro.super.isSetNumberOfRecordsPerSecond();
                this.isSetNumberOfRecordsPerSecondBuildStage = 1;
            }
            return this.isSetNumberOfRecordsPerSecond;
        }

        void isSetNumberOfRecordsPerSecond(boolean isSetNumberOfRecordsPerSecond) {
            this.isSetNumberOfRecordsPerSecond = isSetNumberOfRecordsPerSecond;
            this.isSetNumberOfRecordsPerSecondBuildStage = 1;
        }

        int numberOfRecordsPerSecond() {
            if (this.numberOfRecordsPerSecondBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.numberOfRecordsPerSecondBuildStage == 0) {
                this.numberOfRecordsPerSecondBuildStage = (byte)-1;
                this.numberOfRecordsPerSecond = ImmutableTKafkaInputAvro.super.numberOfRecordsPerSecond();
                this.numberOfRecordsPerSecondBuildStage = 1;
            }
            return this.numberOfRecordsPerSecond;
        }

        void numberOfRecordsPerSecond(int numberOfRecordsPerSecond) {
            this.numberOfRecordsPerSecond = numberOfRecordsPerSecond;
            this.numberOfRecordsPerSecondBuildStage = 1;
        }

        ImmutableMap<String, String> kafKaPropertiesMap() {
            if (this.kafKaPropertiesMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.kafKaPropertiesMapBuildStage == 0) {
                this.kafKaPropertiesMapBuildStage = (byte)-1;
                this.kafKaPropertiesMap = ImmutableMap.copyOf((Map)ImmutableTKafkaInputAvro.super.kafKaPropertiesMap());
                this.kafKaPropertiesMapBuildStage = 1;
            }
            return this.kafKaPropertiesMap;
        }

        void kafKaPropertiesMap(ImmutableMap<String, String> kafKaPropertiesMap) {
            this.kafKaPropertiesMap = kafKaPropertiesMap;
            this.kafKaPropertiesMapBuildStage = 1;
        }

        boolean useHierarchicalMode() {
            if (this.useHierarchicalModeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useHierarchicalModeBuildStage == 0) {
                this.useHierarchicalModeBuildStage = (byte)-1;
                this.useHierarchicalMode = ImmutableTKafkaInputAvro.super.useHierarchicalMode();
                this.useHierarchicalModeBuildStage = 1;
            }
            return this.useHierarchicalMode;
        }

        void useHierarchicalMode(boolean useHierarchicalMode) {
            this.useHierarchicalMode = useHierarchicalMode;
            this.useHierarchicalModeBuildStage = 1;
        }

        boolean failOnDataLoss() {
            if (this.failOnDataLossBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.failOnDataLossBuildStage == 0) {
                this.failOnDataLossBuildStage = (byte)-1;
                this.failOnDataLoss = ImmutableTKafkaInputAvro.super.failOnDataLoss();
                this.failOnDataLossBuildStage = 1;
            }
            return this.failOnDataLoss;
        }

        void failOnDataLoss(boolean failOnDataLoss) {
            this.failOnDataLoss = failOnDataLoss;
            this.failOnDataLossBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.outputRowStructBuildStage == -1) {
                attributes.add("outputRowStruct");
            }
            if (this.schemaFieldDescriptionsMapBuildStage == -1) {
                attributes.add("schemaFieldDescriptionsMap");
            }
            if (this.rowClassBuildStage == -1) {
                attributes.add("rowClass");
            }
            if (this.encoderBuildStage == -1) {
                attributes.add("encoder");
            }
            if (this.contextBuildStage == -1) {
                attributes.add("context");
            }
            if (this.optionsBuildStage == -1) {
                attributes.add("options");
            }
            if (this.topicBuildStage == -1) {
                attributes.add("topic");
            }
            if (this.groupIdBuildStage == -1) {
                attributes.add("groupId");
            }
            if (this.startingOffsetBuildStage == -1) {
                attributes.add("startingOffset");
            }
            if (this.isSetNumberOfRecordsPerSecondBuildStage == -1) {
                attributes.add("isSetNumberOfRecordsPerSecond");
            }
            if (this.numberOfRecordsPerSecondBuildStage == -1) {
                attributes.add("numberOfRecordsPerSecond");
            }
            if (this.kafKaPropertiesMapBuildStage == -1) {
                attributes.add("kafKaPropertiesMap");
            }
            if (this.useHierarchicalModeBuildStage == -1) {
                attributes.add("useHierarchicalMode");
            }
            if (this.failOnDataLossBuildStage == -1) {
                attributes.add("failOnDataLoss");
            }
            return "Cannot build TKafkaInputAvro, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="TKafkaInputAvro", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SPARK_SESSION = 1L;
        private static final long INIT_BIT_T_KAFKA_CONFIGURATION = 2L;
        private static final long INIT_BIT_SPECIFIC_RECORD_SCHEMA = 4L;
        private static final long OPT_BIT_OPTIONS = 1L;
        private static final long OPT_BIT_IS_SET_NUMBER_OF_RECORDS_PER_SECOND = 2L;
        private static final long OPT_BIT_NUMBER_OF_RECORDS_PER_SECOND = 4L;
        private static final long OPT_BIT_KAF_KA_PROPERTIES_MAP = 8L;
        private static final long OPT_BIT_USE_HIERARCHICAL_MODE = 16L;
        private static final long OPT_BIT_FAIL_ON_DATA_LOSS = 32L;
        private long initBits = 7L;
        private long optBits;
        private ImmutableList.Builder<Component.SchemaFieldDescription> schemaFieldDescriptions = ImmutableList.builder();
        @Nullable
        private Class<Row> rowClass;
        @Nullable
        private Encoder<Row> encoder;
        private ImmutableMap.Builder<String, String> options = ImmutableMap.builder();
        @Nullable
        private StreamReader.WatermarkingType enableWatermarking;
        @Nullable
        private String watermarkColumn;
        @Nullable
        private String watermarkDelay;
        @Nullable
        private String format;
        @Nullable
        private SparkSession sparkSession;
        @Nullable
        private TKafkaConfiguration tKafkaConfiguration;
        private ImmutableMap.Builder<String, String> mappings = ImmutableMap.builder();
        @Nullable
        private String topic;
        @Nullable
        private String groupId;
        @Nullable
        private String startingOffset;
        private boolean isSetNumberOfRecordsPerSecond;
        private int numberOfRecordsPerSecond;
        private ImmutableMap.Builder<String, String> kafKaPropertiesMap = ImmutableMap.builder();
        private boolean useHierarchicalMode;
        private boolean failOnDataLoss;
        @Nullable
        private Schema specificRecordSchema;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Component.WithSchemaDescription instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TKafkaInputAvro instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StreamReader instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional watermarkColumnOptional;
            Optional watermarkDelayOptional;
            Optional<StreamReader.WatermarkingType> enableWatermarkingOptional;
            Optional<String> formatOptional;
            Component.WithSchemaDescription instance;
            long bits = 0L;
            if (object instanceof Component.WithSchemaDescription) {
                instance = (Component.WithSchemaDescription)object;
                if ((bits & 0x40L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 0x40L;
                }
            }
            if (object instanceof TKafkaInputAvro) {
                instance = (TKafkaInputAvro)object;
                this.numberOfRecordsPerSecond(instance.numberOfRecordsPerSecond());
                this.groupId(instance.groupId());
                if ((bits & 1L) == 0L) {
                    formatOptional = instance.format();
                    if (formatOptional.isPresent()) {
                        this.format(formatOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    enableWatermarkingOptional = instance.enableWatermarking();
                    if (enableWatermarkingOptional.isPresent()) {
                        this.enableWatermarking((Optional<? extends StreamReader.WatermarkingType>)enableWatermarkingOptional);
                    }
                    bits |= 2L;
                }
                this.putAllKafKaPropertiesMap(instance.kafKaPropertiesMap());
                this.encoder((Encoder<Row>)instance.encoder());
                this.failOnDataLoss(instance.failOnDataLoss());
                this.putAllMappings(instance.mappings());
                this.rowClass(instance.rowClass());
                this.startingOffset(instance.startingOffset());
                if ((bits & 4L) == 0L) {
                    watermarkDelayOptional = instance.watermarkDelay();
                    if (watermarkDelayOptional.isPresent()) {
                        this.watermarkDelay(watermarkDelayOptional);
                    }
                    bits |= 4L;
                }
                this.specificRecordSchema(instance.specificRecordSchema());
                this.useHierarchicalMode(instance.useHierarchicalMode());
                if ((bits & 8L) == 0L) {
                    watermarkColumnOptional = instance.watermarkColumn();
                    if (watermarkColumnOptional.isPresent()) {
                        this.watermarkColumn(watermarkColumnOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.sparkSession(instance.sparkSession());
                    bits |= 0x10L;
                }
                this.isSetNumberOfRecordsPerSecond(instance.isSetNumberOfRecordsPerSecond());
                if ((bits & 0x20L) == 0L) {
                    this.putAllOptions(instance.options());
                    bits |= 0x20L;
                }
                this.topic(instance.topic());
                this.tKafkaConfiguration(instance.tKafkaConfiguration());
                if ((bits & 0x40L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 0x40L;
                }
            }
            if (object instanceof StreamReader) {
                instance = (StreamReader)object;
                if ((bits & 4L) == 0L) {
                    watermarkDelayOptional = instance.watermarkDelay();
                    if (watermarkDelayOptional.isPresent()) {
                        this.watermarkDelay(watermarkDelayOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    watermarkColumnOptional = instance.watermarkColumn();
                    if (watermarkColumnOptional.isPresent()) {
                        this.watermarkColumn(watermarkColumnOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.sparkSession(instance.sparkSession());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    formatOptional = instance.format();
                    if (formatOptional.isPresent()) {
                        this.format(formatOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.putAllOptions(instance.options());
                    bits |= 0x20L;
                }
                if ((bits & 2L) == 0L) {
                    enableWatermarkingOptional = instance.enableWatermarking();
                    if (enableWatermarkingOptional.isPresent()) {
                        this.enableWatermarking(enableWatermarkingOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 0x40L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder addSchemaFieldDescriptions(Component.SchemaFieldDescription element) {
            this.schemaFieldDescriptions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSchemaFieldDescriptions(Component.SchemaFieldDescription ... elements) {
            this.schemaFieldDescriptions.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
            this.schemaFieldDescriptions = ImmutableList.builder();
            return this.addAllSchemaFieldDescriptions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSchemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
            this.schemaFieldDescriptions.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rowClass(Class<Row> rowClass) {
            this.rowClass = Objects.requireNonNull(rowClass, "rowClass");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder encoder(Encoder<Row> encoder) {
            this.encoder = Objects.requireNonNull(encoder, "encoder");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptions(String key, String value) {
            this.options.put((Object)key, (Object)value);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptions(Map.Entry<String, ? extends String> entry) {
            this.options.put(entry);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder options(Map<String, ? extends String> entries) {
            this.options = ImmutableMap.builder();
            this.optBits |= 1L;
            return this.putAllOptions(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllOptions(Map<String, ? extends String> entries) {
            this.options.putAll(entries);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enableWatermarking(StreamReader.WatermarkingType enableWatermarking) {
            this.enableWatermarking = Objects.requireNonNull(enableWatermarking, "enableWatermarking");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enableWatermarking(Optional<? extends StreamReader.WatermarkingType> enableWatermarking) {
            this.enableWatermarking = enableWatermarking.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder watermarkColumn(String watermarkColumn) {
            this.watermarkColumn = Objects.requireNonNull(watermarkColumn, "watermarkColumn");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder watermarkColumn(Optional<String> watermarkColumn) {
            this.watermarkColumn = watermarkColumn.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder watermarkDelay(String watermarkDelay) {
            this.watermarkDelay = Objects.requireNonNull(watermarkDelay, "watermarkDelay");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder watermarkDelay(Optional<String> watermarkDelay) {
            this.watermarkDelay = watermarkDelay.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder format(String format) {
            this.format = Objects.requireNonNull(format, "format");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder format(Optional<String> format) {
            this.format = format.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sparkSession(SparkSession sparkSession) {
            this.sparkSession = Objects.requireNonNull(sparkSession, "sparkSession");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tKafkaConfiguration(TKafkaConfiguration tKafkaConfiguration) {
            this.tKafkaConfiguration = Objects.requireNonNull(tKafkaConfiguration, "tKafkaConfiguration");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMappings(String key, String value) {
            this.mappings.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMappings(Map.Entry<String, ? extends String> entry) {
            this.mappings.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mappings(Map<String, ? extends String> entries) {
            this.mappings = ImmutableMap.builder();
            return this.putAllMappings(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllMappings(Map<String, ? extends String> entries) {
            this.mappings.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder topic(String topic) {
            this.topic = Objects.requireNonNull(topic, "topic");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder groupId(String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder startingOffset(String startingOffset) {
            this.startingOffset = Objects.requireNonNull(startingOffset, "startingOffset");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isSetNumberOfRecordsPerSecond(boolean isSetNumberOfRecordsPerSecond) {
            this.isSetNumberOfRecordsPerSecond = isSetNumberOfRecordsPerSecond;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder numberOfRecordsPerSecond(int numberOfRecordsPerSecond) {
            this.numberOfRecordsPerSecond = numberOfRecordsPerSecond;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putKafKaPropertiesMap(String key, String value) {
            this.kafKaPropertiesMap.put((Object)key, (Object)value);
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putKafKaPropertiesMap(Map.Entry<String, ? extends String> entry) {
            this.kafKaPropertiesMap.put(entry);
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder kafKaPropertiesMap(Map<String, ? extends String> entries) {
            this.kafKaPropertiesMap = ImmutableMap.builder();
            this.optBits |= 8L;
            return this.putAllKafKaPropertiesMap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllKafKaPropertiesMap(Map<String, ? extends String> entries) {
            this.kafKaPropertiesMap.putAll(entries);
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder useHierarchicalMode(boolean useHierarchicalMode) {
            this.useHierarchicalMode = useHierarchicalMode;
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder failOnDataLoss(boolean failOnDataLoss) {
            this.failOnDataLoss = failOnDataLoss;
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder specificRecordSchema(Schema specificRecordSchema) {
            this.specificRecordSchema = Objects.requireNonNull(specificRecordSchema, "specificRecordSchema");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableTKafkaInputAvro build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTKafkaInputAvro(this);
        }

        private boolean optionsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean isSetNumberOfRecordsPerSecondIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean numberOfRecordsPerSecondIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean kafKaPropertiesMapIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean useHierarchicalModeIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean failOnDataLossIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sparkSession");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tKafkaConfiguration");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("specificRecordSchema");
            }
            return "Cannot build TKafkaInputAvro, some of required attributes are not set " + attributes;
        }
    }
}

