/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.kafka;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.immutables.value.Generated;
import org.talend.bigdata.structuredstreaming.kafka.TKafkaConfiguration;
import org.talend.bigdata.structuredstreaming.kafka.TKafkaOutput;

@ParametersAreNonnullByDefault
@Generated(from="TKafkaOutput", generator="Immutables")
public final class ImmutableTKafkaOutput {
    private ImmutableTKafkaOutput() {
    }

    @CheckReturnValue
    @Generated(from="TKafkaOutput.Dataframe", generator="Immutables")
    @Immutable
    public static final class Dataframe
    extends TKafkaOutput.Dataframe {
        private final ImmutableMap<String, String> kafKaPropertiesMap;
        private final String topic;
        private final int partition;
        private final String key;
        private final boolean isCompressDataSelected;
        private final TKafkaOutput.Compression compression;
        private final Optional<String> checkpointLocationOptional;
        private final Dataset<Row> inputDataset;
        private final TKafkaConfiguration tKafkaConfiguration;
        private final SparkSession sparkSession;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private Dataframe(Builder builder) {
            this.inputDataset = builder.inputDataset;
            this.tKafkaConfiguration = builder.tKafkaConfiguration;
            this.sparkSession = builder.sparkSession;
            if (builder.kafKaPropertiesMapIsSet()) {
                this.initShim.kafKaPropertiesMap((ImmutableMap<String, String>)builder.kafKaPropertiesMap.build());
            }
            if (builder.topic != null) {
                this.initShim.topic(builder.topic);
            }
            if (builder.partitionIsSet()) {
                this.initShim.partition(builder.partition);
            }
            if (builder.key != null) {
                this.initShim.key(builder.key);
            }
            if (builder.isCompressDataSelectedIsSet()) {
                this.initShim.isCompressDataSelected(builder.isCompressDataSelected);
            }
            if (builder.compression != null) {
                this.initShim.compression(builder.compression);
            }
            if (builder.checkpointLocationOptional != null) {
                this.initShim.checkpointLocationOptional(builder.checkpointLocationOptional);
            }
            this.kafKaPropertiesMap = this.initShim.kafKaPropertiesMap();
            this.topic = this.initShim.topic();
            this.partition = this.initShim.partition();
            this.key = this.initShim.key();
            this.isCompressDataSelected = this.initShim.isCompressDataSelected();
            this.compression = this.initShim.compression();
            this.checkpointLocationOptional = this.initShim.checkpointLocationOptional();
            this.initShim = null;
        }

        private Dataframe(ImmutableMap<String, String> kafKaPropertiesMap, String topic, int partition, String key, boolean isCompressDataSelected, TKafkaOutput.Compression compression, Optional<String> checkpointLocationOptional, Dataset<Row> inputDataset, TKafkaConfiguration tKafkaConfiguration, SparkSession sparkSession) {
            this.kafKaPropertiesMap = kafKaPropertiesMap;
            this.topic = topic;
            this.partition = partition;
            this.key = key;
            this.isCompressDataSelected = isCompressDataSelected;
            this.compression = compression;
            this.checkpointLocationOptional = checkpointLocationOptional;
            this.inputDataset = inputDataset;
            this.tKafkaConfiguration = tKafkaConfiguration;
            this.sparkSession = sparkSession;
            this.initShim = null;
        }

        public ImmutableMap<String, String> kafKaPropertiesMap() {
            InitShim shim = this.initShim;
            return shim != null ? shim.kafKaPropertiesMap() : this.kafKaPropertiesMap;
        }

        @Override
        public String topic() {
            InitShim shim = this.initShim;
            return shim != null ? shim.topic() : this.topic;
        }

        @Override
        public int partition() {
            InitShim shim = this.initShim;
            return shim != null ? shim.partition() : this.partition;
        }

        @Override
        public String key() {
            InitShim shim = this.initShim;
            return shim != null ? shim.key() : this.key;
        }

        @Override
        public boolean isCompressDataSelected() {
            InitShim shim = this.initShim;
            return shim != null ? shim.isCompressDataSelected() : this.isCompressDataSelected;
        }

        @Override
        public TKafkaOutput.Compression compression() {
            InitShim shim = this.initShim;
            return shim != null ? shim.compression() : this.compression;
        }

        @Override
        public Optional<String> checkpointLocationOptional() {
            InitShim shim = this.initShim;
            return shim != null ? shim.checkpointLocationOptional() : this.checkpointLocationOptional;
        }

        @Override
        public Dataset<Row> inputDataset() {
            return this.inputDataset;
        }

        @Override
        public TKafkaConfiguration tKafkaConfiguration() {
            return this.tKafkaConfiguration;
        }

        @Override
        public SparkSession sparkSession() {
            return this.sparkSession;
        }

        public final Dataframe withKafKaPropertiesMap(Map<String, ? extends String> entries) {
            if (this.kafKaPropertiesMap == entries) {
                return this;
            }
            ImmutableMap newValue = ImmutableMap.copyOf(entries);
            return new Dataframe((ImmutableMap<String, String>)newValue, this.topic, this.partition, this.key, this.isCompressDataSelected, this.compression, this.checkpointLocationOptional, this.inputDataset, this.tKafkaConfiguration, this.sparkSession);
        }

        public final Dataframe withTopic(String value) {
            String newValue = Objects.requireNonNull(value, "topic");
            if (this.topic.equals(newValue)) {
                return this;
            }
            return new Dataframe(this.kafKaPropertiesMap, newValue, this.partition, this.key, this.isCompressDataSelected, this.compression, this.checkpointLocationOptional, this.inputDataset, this.tKafkaConfiguration, this.sparkSession);
        }

        public final Dataframe withPartition(int value) {
            if (this.partition == value) {
                return this;
            }
            return new Dataframe(this.kafKaPropertiesMap, this.topic, value, this.key, this.isCompressDataSelected, this.compression, this.checkpointLocationOptional, this.inputDataset, this.tKafkaConfiguration, this.sparkSession);
        }

        public final Dataframe withKey(String value) {
            String newValue = Objects.requireNonNull(value, "key");
            if (this.key.equals(newValue)) {
                return this;
            }
            return new Dataframe(this.kafKaPropertiesMap, this.topic, this.partition, newValue, this.isCompressDataSelected, this.compression, this.checkpointLocationOptional, this.inputDataset, this.tKafkaConfiguration, this.sparkSession);
        }

        public final Dataframe withIsCompressDataSelected(boolean value) {
            if (this.isCompressDataSelected == value) {
                return this;
            }
            return new Dataframe(this.kafKaPropertiesMap, this.topic, this.partition, this.key, value, this.compression, this.checkpointLocationOptional, this.inputDataset, this.tKafkaConfiguration, this.sparkSession);
        }

        public final Dataframe withCompression(TKafkaOutput.Compression value) {
            TKafkaOutput.Compression newValue = Objects.requireNonNull(value, "compression");
            if (this.compression == newValue) {
                return this;
            }
            return new Dataframe(this.kafKaPropertiesMap, this.topic, this.partition, this.key, this.isCompressDataSelected, newValue, this.checkpointLocationOptional, this.inputDataset, this.tKafkaConfiguration, this.sparkSession);
        }

        public final Dataframe withCheckpointLocationOptional(Optional<String> value) {
            Optional<String> newValue = Objects.requireNonNull(value, "checkpointLocationOptional");
            if (this.checkpointLocationOptional.equals(newValue)) {
                return this;
            }
            return new Dataframe(this.kafKaPropertiesMap, this.topic, this.partition, this.key, this.isCompressDataSelected, this.compression, newValue, this.inputDataset, this.tKafkaConfiguration, this.sparkSession);
        }

        public final Dataframe withInputDataset(Dataset<Row> value) {
            if (this.inputDataset == value) {
                return this;
            }
            Dataset<Row> newValue = Objects.requireNonNull(value, "inputDataset");
            return new Dataframe(this.kafKaPropertiesMap, this.topic, this.partition, this.key, this.isCompressDataSelected, this.compression, this.checkpointLocationOptional, newValue, this.tKafkaConfiguration, this.sparkSession);
        }

        public final Dataframe withTKafkaConfiguration(TKafkaConfiguration value) {
            if (this.tKafkaConfiguration == value) {
                return this;
            }
            TKafkaConfiguration newValue = Objects.requireNonNull(value, "tKafkaConfiguration");
            return new Dataframe(this.kafKaPropertiesMap, this.topic, this.partition, this.key, this.isCompressDataSelected, this.compression, this.checkpointLocationOptional, this.inputDataset, newValue, this.sparkSession);
        }

        public final Dataframe withSparkSession(SparkSession value) {
            if (this.sparkSession == value) {
                return this;
            }
            SparkSession newValue = Objects.requireNonNull(value, "sparkSession");
            return new Dataframe(this.kafKaPropertiesMap, this.topic, this.partition, this.key, this.isCompressDataSelected, this.compression, this.checkpointLocationOptional, this.inputDataset, this.tKafkaConfiguration, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Dataframe && this.equalTo(0, (Dataframe)another);
        }

        private boolean equalTo(int synthetic, Dataframe another) {
            return this.kafKaPropertiesMap.equals(another.kafKaPropertiesMap) && this.topic.equals(another.topic) && this.partition == another.partition && this.key.equals(another.key) && this.isCompressDataSelected == another.isCompressDataSelected && this.compression.equals((Object)another.compression) && this.checkpointLocationOptional.equals(another.checkpointLocationOptional) && this.inputDataset.equals(another.inputDataset) && this.tKafkaConfiguration.equals(another.tKafkaConfiguration) && this.sparkSession.equals(another.sparkSession);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.kafKaPropertiesMap.hashCode();
            h += (h << 5) + this.topic.hashCode();
            h += (h << 5) + this.partition;
            h += (h << 5) + this.key.hashCode();
            h += (h << 5) + Booleans.hashCode((boolean)this.isCompressDataSelected);
            h += (h << 5) + this.compression.hashCode();
            h += (h << 5) + this.checkpointLocationOptional.hashCode();
            h += (h << 5) + this.inputDataset.hashCode();
            h += (h << 5) + this.tKafkaConfiguration.hashCode();
            h += (h << 5) + this.sparkSession.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Dataframe").omitNullValues().add("kafKaPropertiesMap", this.kafKaPropertiesMap).add("topic", (Object)this.topic).add("partition", this.partition).add("key", (Object)this.key).add("isCompressDataSelected", this.isCompressDataSelected).add("compression", (Object)this.compression).add("checkpointLocationOptional", this.checkpointLocationOptional).add("inputDataset", this.inputDataset).add("tKafkaConfiguration", (Object)this.tKafkaConfiguration).add("sparkSession", (Object)this.sparkSession).toString();
        }

        public static Dataframe copyOf(TKafkaOutput.Dataframe instance) {
            if (instance instanceof Dataframe) {
                return (Dataframe)instance;
            }
            return Dataframe.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="TKafkaOutput.Dataframe", generator="Immutables")
        private final class InitShim {
            private byte kafKaPropertiesMapBuildStage = 0;
            private ImmutableMap<String, String> kafKaPropertiesMap;
            private byte topicBuildStage = 0;
            private String topic;
            private byte partitionBuildStage = 0;
            private int partition;
            private byte keyBuildStage = 0;
            private String key;
            private byte isCompressDataSelectedBuildStage = 0;
            private boolean isCompressDataSelected;
            private byte compressionBuildStage = 0;
            private TKafkaOutput.Compression compression;
            private byte checkpointLocationOptionalBuildStage = 0;
            private Optional<String> checkpointLocationOptional;

            private InitShim() {
            }

            ImmutableMap<String, String> kafKaPropertiesMap() {
                if (this.kafKaPropertiesMapBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.kafKaPropertiesMapBuildStage == 0) {
                    this.kafKaPropertiesMapBuildStage = (byte)-1;
                    this.kafKaPropertiesMap = ImmutableMap.copyOf((Map)Dataframe.super.kafKaPropertiesMap());
                    this.kafKaPropertiesMapBuildStage = 1;
                }
                return this.kafKaPropertiesMap;
            }

            void kafKaPropertiesMap(ImmutableMap<String, String> kafKaPropertiesMap) {
                this.kafKaPropertiesMap = kafKaPropertiesMap;
                this.kafKaPropertiesMapBuildStage = 1;
            }

            String topic() {
                if (this.topicBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.topicBuildStage == 0) {
                    this.topicBuildStage = (byte)-1;
                    this.topic = Objects.requireNonNull(Dataframe.super.topic(), "topic");
                    this.topicBuildStage = 1;
                }
                return this.topic;
            }

            void topic(String topic) {
                this.topic = topic;
                this.topicBuildStage = 1;
            }

            int partition() {
                if (this.partitionBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.partitionBuildStage == 0) {
                    this.partitionBuildStage = (byte)-1;
                    this.partition = Dataframe.super.partition();
                    this.partitionBuildStage = 1;
                }
                return this.partition;
            }

            void partition(int partition) {
                this.partition = partition;
                this.partitionBuildStage = 1;
            }

            String key() {
                if (this.keyBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.keyBuildStage == 0) {
                    this.keyBuildStage = (byte)-1;
                    this.key = Objects.requireNonNull(Dataframe.super.key(), "key");
                    this.keyBuildStage = 1;
                }
                return this.key;
            }

            void key(String key) {
                this.key = key;
                this.keyBuildStage = 1;
            }

            boolean isCompressDataSelected() {
                if (this.isCompressDataSelectedBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.isCompressDataSelectedBuildStage == 0) {
                    this.isCompressDataSelectedBuildStage = (byte)-1;
                    this.isCompressDataSelected = Dataframe.super.isCompressDataSelected();
                    this.isCompressDataSelectedBuildStage = 1;
                }
                return this.isCompressDataSelected;
            }

            void isCompressDataSelected(boolean isCompressDataSelected) {
                this.isCompressDataSelected = isCompressDataSelected;
                this.isCompressDataSelectedBuildStage = 1;
            }

            TKafkaOutput.Compression compression() {
                if (this.compressionBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.compressionBuildStage == 0) {
                    this.compressionBuildStage = (byte)-1;
                    this.compression = Objects.requireNonNull(Dataframe.super.compression(), "compression");
                    this.compressionBuildStage = 1;
                }
                return this.compression;
            }

            void compression(TKafkaOutput.Compression compression) {
                this.compression = compression;
                this.compressionBuildStage = 1;
            }

            Optional<String> checkpointLocationOptional() {
                if (this.checkpointLocationOptionalBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.checkpointLocationOptionalBuildStage == 0) {
                    this.checkpointLocationOptionalBuildStage = (byte)-1;
                    this.checkpointLocationOptional = Objects.requireNonNull(Dataframe.super.checkpointLocationOptional(), "checkpointLocationOptional");
                    this.checkpointLocationOptionalBuildStage = 1;
                }
                return this.checkpointLocationOptional;
            }

            void checkpointLocationOptional(Optional<String> checkpointLocationOptional) {
                this.checkpointLocationOptional = checkpointLocationOptional;
                this.checkpointLocationOptionalBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.kafKaPropertiesMapBuildStage == -1) {
                    attributes.add("kafKaPropertiesMap");
                }
                if (this.topicBuildStage == -1) {
                    attributes.add("topic");
                }
                if (this.partitionBuildStage == -1) {
                    attributes.add("partition");
                }
                if (this.keyBuildStage == -1) {
                    attributes.add("key");
                }
                if (this.isCompressDataSelectedBuildStage == -1) {
                    attributes.add("isCompressDataSelected");
                }
                if (this.compressionBuildStage == -1) {
                    attributes.add("compression");
                }
                if (this.checkpointLocationOptionalBuildStage == -1) {
                    attributes.add("checkpointLocationOptional");
                }
                return "Cannot build Dataframe, attribute initializers form cycle " + attributes;
            }
        }

        @Generated(from="TKafkaOutput.Dataframe", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_INPUT_DATASET = 1L;
            private static final long INIT_BIT_T_KAFKA_CONFIGURATION = 2L;
            private static final long INIT_BIT_SPARK_SESSION = 4L;
            private static final long OPT_BIT_KAF_KA_PROPERTIES_MAP = 1L;
            private static final long OPT_BIT_PARTITION = 2L;
            private static final long OPT_BIT_IS_COMPRESS_DATA_SELECTED = 4L;
            private long initBits = 7L;
            private long optBits;
            private ImmutableMap.Builder<String, String> kafKaPropertiesMap = ImmutableMap.builder();
            @Nullable
            private String topic;
            private int partition;
            @Nullable
            private String key;
            private boolean isCompressDataSelected;
            @Nullable
            private TKafkaOutput.Compression compression;
            @Nullable
            private Optional<String> checkpointLocationOptional;
            @Nullable
            private Dataset<Row> inputDataset;
            @Nullable
            private TKafkaConfiguration tKafkaConfiguration;
            @Nullable
            private SparkSession sparkSession;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(TKafkaOutput.Dataframe instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(TKafkaOutput.WithAdvanceComponentConfiguration instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(TKafkaOutput.WithComponentConfiguration instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                TKafkaOutput.WithAdvanceComponentConfiguration instance;
                long bits = 0L;
                if (object instanceof TKafkaOutput.Dataframe) {
                    instance = (TKafkaOutput.Dataframe)object;
                    if ((bits & 1L) == 0L) {
                        this.partition(instance.partition());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.checkpointLocationOptional(instance.checkpointLocationOptional());
                        bits |= 2L;
                    }
                    this.sparkSession(((TKafkaOutput.Dataframe)instance).sparkSession());
                    if ((bits & 4L) == 0L) {
                        this.topic(instance.topic());
                        bits |= 4L;
                    }
                    if ((bits & 8L) == 0L) {
                        this.putAllKafKaPropertiesMap(instance.kafKaPropertiesMap());
                        bits |= 8L;
                    }
                    this.tKafkaConfiguration(((TKafkaOutput.Dataframe)instance).tKafkaConfiguration());
                    if ((bits & 0x10L) == 0L) {
                        this.isCompressDataSelected(instance.isCompressDataSelected());
                        bits |= 0x10L;
                    }
                    if ((bits & 0x20L) == 0L) {
                        this.compression(instance.compression());
                        bits |= 0x20L;
                    }
                    if ((bits & 0x40L) == 0L) {
                        this.key(instance.key());
                        bits |= 0x40L;
                    }
                    this.inputDataset(((TKafkaOutput.Dataframe)instance).inputDataset());
                }
                if (object instanceof TKafkaOutput.WithAdvanceComponentConfiguration) {
                    instance = (TKafkaOutput.WithAdvanceComponentConfiguration)object;
                    if ((bits & 8L) == 0L) {
                        this.putAllKafKaPropertiesMap(instance.kafKaPropertiesMap());
                        bits |= 8L;
                    }
                }
                if (object instanceof TKafkaOutput.WithComponentConfiguration) {
                    instance = (TKafkaOutput.WithComponentConfiguration)object;
                    if ((bits & 1L) == 0L) {
                        this.partition(instance.partition());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.checkpointLocationOptional(instance.checkpointLocationOptional());
                        bits |= 2L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.topic(instance.topic());
                        bits |= 4L;
                    }
                    if ((bits & 8L) == 0L) {
                        this.putAllKafKaPropertiesMap(instance.kafKaPropertiesMap());
                        bits |= 8L;
                    }
                    if ((bits & 0x10L) == 0L) {
                        this.isCompressDataSelected(instance.isCompressDataSelected());
                        bits |= 0x10L;
                    }
                    if ((bits & 0x20L) == 0L) {
                        this.compression(instance.compression());
                        bits |= 0x20L;
                    }
                    if ((bits & 0x40L) == 0L) {
                        this.key(instance.key());
                        bits |= 0x40L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder putKafKaPropertiesMap(String key, String value) {
                this.kafKaPropertiesMap.put((Object)key, (Object)value);
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder putKafKaPropertiesMap(Map.Entry<String, ? extends String> entry) {
                this.kafKaPropertiesMap.put(entry);
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder kafKaPropertiesMap(Map<String, ? extends String> entries) {
                this.kafKaPropertiesMap = ImmutableMap.builder();
                this.optBits |= 1L;
                return this.putAllKafKaPropertiesMap(entries);
            }

            @CanIgnoreReturnValue
            public final Builder putAllKafKaPropertiesMap(Map<String, ? extends String> entries) {
                this.kafKaPropertiesMap.putAll(entries);
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder topic(String topic) {
                this.topic = Objects.requireNonNull(topic, "topic");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder partition(int partition) {
                this.partition = partition;
                this.optBits |= 2L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder key(String key) {
                this.key = Objects.requireNonNull(key, "key");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder isCompressDataSelected(boolean isCompressDataSelected) {
                this.isCompressDataSelected = isCompressDataSelected;
                this.optBits |= 4L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder compression(TKafkaOutput.Compression compression) {
                this.compression = Objects.requireNonNull(compression, "compression");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder checkpointLocationOptional(Optional<String> checkpointLocationOptional) {
                this.checkpointLocationOptional = Objects.requireNonNull(checkpointLocationOptional, "checkpointLocationOptional");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder inputDataset(Dataset<Row> inputDataset) {
                this.inputDataset = Objects.requireNonNull(inputDataset, "inputDataset");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder tKafkaConfiguration(TKafkaConfiguration tKafkaConfiguration) {
                this.tKafkaConfiguration = Objects.requireNonNull(tKafkaConfiguration, "tKafkaConfiguration");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder sparkSession(SparkSession sparkSession) {
                this.sparkSession = Objects.requireNonNull(sparkSession, "sparkSession");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public Dataframe build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Dataframe(this);
            }

            private boolean kafKaPropertiesMapIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private boolean partitionIsSet() {
                return (this.optBits & 2L) != 0L;
            }

            private boolean isCompressDataSelectedIsSet() {
                return (this.optBits & 4L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("inputDataset");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("tKafkaConfiguration");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("sparkSession");
                }
                return "Cannot build Dataframe, some of required attributes are not set " + attributes;
            }
        }
    }
}

