/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.misc.tlogrow.mode;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructField;
import org.immutables.value.Value;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.mode.WithLoggerMode;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.util.TLogRowUtils;

@Value.Immutable
public abstract class BasicLoggerMode
implements WithLoggerMode {
    @Value.Default
    public String fieldSeparator() {
        return "|";
    }

    @Value.Default
    public boolean printHeader() {
        return false;
    }

    @Value.Default
    public boolean printComponentUniqueName() {
        return false;
    }

    @Value.Default
    public boolean printSchemaColumnName() {
        return false;
    }

    @Value.Default
    public boolean useFixedLengthForValues() {
        return false;
    }

    @Value.Default
    public Map<String, Integer> fixedLengthValuesMap() {
        return Collections.emptyMap();
    }

    @Override
    public String log(Row recordValue) {
        StringBuilder stringBuilder = new StringBuilder();
        List<StructField> fieldList = Arrays.asList(recordValue.schema().fields());
        AtomicBoolean rowHeaderActive = new AtomicBoolean(true);
        fieldList.forEach(field -> {
            if (this.printComponentUniqueName() && rowHeaderActive.get()) {
                stringBuilder.append("[").append(this.componentName()).append("] ");
                rowHeaderActive.set(false);
            }
            if (this.printSchemaColumnName()) {
                stringBuilder.append(field.name()).append(": ");
            }
            if (recordValue.getAs(field.name()) != null) {
                if (this.useFixedLengthForValues()) {
                    Formatter formatter = new Formatter(new StringBuilder());
                    stringBuilder.append(formatter.format("%1$" + this.fixedLengthValuesMap().get(field.name()) + "s", this.getFormattedValue(recordValue, (StructField)field)));
                } else {
                    stringBuilder.append(this.getFormattedValue(recordValue, (StructField)field));
                }
            }
            stringBuilder.append(this.fieldSeparator());
        });
        return new String(stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length()).toString().getBytes(StandardCharsets.UTF_8), Charset.defaultCharset());
    }

    @Override
    public String log(Dataset<Row> ds) {
        StringBuilder result = new StringBuilder();
        if (this.printHeader()) {
            List<StructField> fields = Arrays.asList(ds.schema().fields());
            String[] columnNames = TLogRowUtils.getColumnsNameArray(fields);
            StringBuilder headerStringBuilder = new StringBuilder();
            Arrays.stream(columnNames).forEach(columnName -> headerStringBuilder.append((String)columnName).append("\t"));
            headerStringBuilder.deleteCharAt(headerStringBuilder.length() - 1);
            result.append((CharSequence)headerStringBuilder).append("\n");
        }
        for (Row row : ds.collectAsList()) {
            result.append(this.log(row)).append("\n");
        }
        return result.toString();
    }
}

