/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.misc.tlogrow.mode;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.spark.sql.types.StructType;
import org.immutables.value.Generated;
import org.talend.bigdata.common.Component;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.mode.BasicLoggerMode;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.mode.WithLoggerMode;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BasicLoggerMode", generator="Immutables")
@Immutable
public final class ImmutableBasicLoggerMode
extends BasicLoggerMode {
    private final ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions;
    private final StructType outputRowStruct;
    private final Map<String, Component.SchemaFieldDescription> schemaFieldDescriptionsMap;
    private final String componentName;
    private final boolean useLocalTimeZone;
    private final String fieldSeparator;
    private final boolean printHeader;
    private final boolean printComponentUniqueName;
    private final boolean printSchemaColumnName;
    private final boolean useFixedLengthForValues;
    private final ImmutableMap<String, Integer> fixedLengthValuesMap;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBasicLoggerMode(Builder builder) {
        this.schemaFieldDescriptions = builder.schemaFieldDescriptions.build();
        if (builder.componentName != null) {
            this.initShim.componentName(builder.componentName);
        }
        if (builder.useLocalTimeZoneIsSet()) {
            this.initShim.useLocalTimeZone(builder.useLocalTimeZone);
        }
        if (builder.fieldSeparator != null) {
            this.initShim.fieldSeparator(builder.fieldSeparator);
        }
        if (builder.printHeaderIsSet()) {
            this.initShim.printHeader(builder.printHeader);
        }
        if (builder.printComponentUniqueNameIsSet()) {
            this.initShim.printComponentUniqueName(builder.printComponentUniqueName);
        }
        if (builder.printSchemaColumnNameIsSet()) {
            this.initShim.printSchemaColumnName(builder.printSchemaColumnName);
        }
        if (builder.useFixedLengthForValuesIsSet()) {
            this.initShim.useFixedLengthForValues(builder.useFixedLengthForValues);
        }
        if (builder.fixedLengthValuesMapIsSet()) {
            this.initShim.fixedLengthValuesMap((ImmutableMap<String, Integer>)builder.fixedLengthValuesMap.build());
        }
        this.outputRowStruct = this.initShim.getOutputRowStruct();
        this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
        this.componentName = this.initShim.componentName();
        this.useLocalTimeZone = this.initShim.useLocalTimeZone();
        this.fieldSeparator = this.initShim.fieldSeparator();
        this.printHeader = this.initShim.printHeader();
        this.printComponentUniqueName = this.initShim.printComponentUniqueName();
        this.printSchemaColumnName = this.initShim.printSchemaColumnName();
        this.useFixedLengthForValues = this.initShim.useFixedLengthForValues();
        this.fixedLengthValuesMap = this.initShim.fixedLengthValuesMap();
        this.initShim = null;
    }

    private ImmutableBasicLoggerMode(ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions, String componentName, boolean useLocalTimeZone, String fieldSeparator, boolean printHeader, boolean printComponentUniqueName, boolean printSchemaColumnName, boolean useFixedLengthForValues, ImmutableMap<String, Integer> fixedLengthValuesMap) {
        this.schemaFieldDescriptions = schemaFieldDescriptions;
        this.initShim.componentName(componentName);
        this.initShim.useLocalTimeZone(useLocalTimeZone);
        this.initShim.fieldSeparator(fieldSeparator);
        this.initShim.printHeader(printHeader);
        this.initShim.printComponentUniqueName(printComponentUniqueName);
        this.initShim.printSchemaColumnName(printSchemaColumnName);
        this.initShim.useFixedLengthForValues(useFixedLengthForValues);
        this.initShim.fixedLengthValuesMap(fixedLengthValuesMap);
        this.outputRowStruct = this.initShim.getOutputRowStruct();
        this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
        this.componentName = this.initShim.componentName();
        this.useLocalTimeZone = this.initShim.useLocalTimeZone();
        this.fieldSeparator = this.initShim.fieldSeparator();
        this.printHeader = this.initShim.printHeader();
        this.printComponentUniqueName = this.initShim.printComponentUniqueName();
        this.printSchemaColumnName = this.initShim.printSchemaColumnName();
        this.useFixedLengthForValues = this.initShim.useFixedLengthForValues();
        this.fixedLengthValuesMap = this.initShim.fixedLengthValuesMap();
        this.initShim = null;
    }

    public ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions() {
        return this.schemaFieldDescriptions;
    }

    public StructType getOutputRowStruct() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOutputRowStruct() : this.outputRowStruct;
    }

    public Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSchemaFieldDescriptionsMap() : this.schemaFieldDescriptionsMap;
    }

    @Override
    public String componentName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.componentName() : this.componentName;
    }

    @Override
    public boolean useLocalTimeZone() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useLocalTimeZone() : this.useLocalTimeZone;
    }

    @Override
    public String fieldSeparator() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fieldSeparator() : this.fieldSeparator;
    }

    @Override
    public boolean printHeader() {
        InitShim shim = this.initShim;
        return shim != null ? shim.printHeader() : this.printHeader;
    }

    @Override
    public boolean printComponentUniqueName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.printComponentUniqueName() : this.printComponentUniqueName;
    }

    @Override
    public boolean printSchemaColumnName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.printSchemaColumnName() : this.printSchemaColumnName;
    }

    @Override
    public boolean useFixedLengthForValues() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useFixedLengthForValues() : this.useFixedLengthForValues;
    }

    public ImmutableMap<String, Integer> fixedLengthValuesMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fixedLengthValuesMap() : this.fixedLengthValuesMap;
    }

    public final ImmutableBasicLoggerMode withSchemaFieldDescriptions(Component.SchemaFieldDescription ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableBasicLoggerMode((ImmutableList<Component.SchemaFieldDescription>)newValue, this.componentName, this.useLocalTimeZone, this.fieldSeparator, this.printHeader, this.printComponentUniqueName, this.printSchemaColumnName, this.useFixedLengthForValues, this.fixedLengthValuesMap);
    }

    public final ImmutableBasicLoggerMode withSchemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
        if (this.schemaFieldDescriptions == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableBasicLoggerMode((ImmutableList<Component.SchemaFieldDescription>)newValue, this.componentName, this.useLocalTimeZone, this.fieldSeparator, this.printHeader, this.printComponentUniqueName, this.printSchemaColumnName, this.useFixedLengthForValues, this.fixedLengthValuesMap);
    }

    public final ImmutableBasicLoggerMode withComponentName(String value) {
        String newValue = Objects.requireNonNull(value, "componentName");
        if (this.componentName.equals(newValue)) {
            return this;
        }
        return new ImmutableBasicLoggerMode(this.schemaFieldDescriptions, newValue, this.useLocalTimeZone, this.fieldSeparator, this.printHeader, this.printComponentUniqueName, this.printSchemaColumnName, this.useFixedLengthForValues, this.fixedLengthValuesMap);
    }

    public final ImmutableBasicLoggerMode withUseLocalTimeZone(boolean value) {
        if (this.useLocalTimeZone == value) {
            return this;
        }
        return new ImmutableBasicLoggerMode(this.schemaFieldDescriptions, this.componentName, value, this.fieldSeparator, this.printHeader, this.printComponentUniqueName, this.printSchemaColumnName, this.useFixedLengthForValues, this.fixedLengthValuesMap);
    }

    public final ImmutableBasicLoggerMode withFieldSeparator(String value) {
        String newValue = Objects.requireNonNull(value, "fieldSeparator");
        if (this.fieldSeparator.equals(newValue)) {
            return this;
        }
        return new ImmutableBasicLoggerMode(this.schemaFieldDescriptions, this.componentName, this.useLocalTimeZone, newValue, this.printHeader, this.printComponentUniqueName, this.printSchemaColumnName, this.useFixedLengthForValues, this.fixedLengthValuesMap);
    }

    public final ImmutableBasicLoggerMode withPrintHeader(boolean value) {
        if (this.printHeader == value) {
            return this;
        }
        return new ImmutableBasicLoggerMode(this.schemaFieldDescriptions, this.componentName, this.useLocalTimeZone, this.fieldSeparator, value, this.printComponentUniqueName, this.printSchemaColumnName, this.useFixedLengthForValues, this.fixedLengthValuesMap);
    }

    public final ImmutableBasicLoggerMode withPrintComponentUniqueName(boolean value) {
        if (this.printComponentUniqueName == value) {
            return this;
        }
        return new ImmutableBasicLoggerMode(this.schemaFieldDescriptions, this.componentName, this.useLocalTimeZone, this.fieldSeparator, this.printHeader, value, this.printSchemaColumnName, this.useFixedLengthForValues, this.fixedLengthValuesMap);
    }

    public final ImmutableBasicLoggerMode withPrintSchemaColumnName(boolean value) {
        if (this.printSchemaColumnName == value) {
            return this;
        }
        return new ImmutableBasicLoggerMode(this.schemaFieldDescriptions, this.componentName, this.useLocalTimeZone, this.fieldSeparator, this.printHeader, this.printComponentUniqueName, value, this.useFixedLengthForValues, this.fixedLengthValuesMap);
    }

    public final ImmutableBasicLoggerMode withUseFixedLengthForValues(boolean value) {
        if (this.useFixedLengthForValues == value) {
            return this;
        }
        return new ImmutableBasicLoggerMode(this.schemaFieldDescriptions, this.componentName, this.useLocalTimeZone, this.fieldSeparator, this.printHeader, this.printComponentUniqueName, this.printSchemaColumnName, value, this.fixedLengthValuesMap);
    }

    public final ImmutableBasicLoggerMode withFixedLengthValuesMap(Map<String, ? extends Integer> entries) {
        if (this.fixedLengthValuesMap == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableBasicLoggerMode(this.schemaFieldDescriptions, this.componentName, this.useLocalTimeZone, this.fieldSeparator, this.printHeader, this.printComponentUniqueName, this.printSchemaColumnName, this.useFixedLengthForValues, (ImmutableMap<String, Integer>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBasicLoggerMode && this.equalTo(0, (ImmutableBasicLoggerMode)another);
    }

    private boolean equalTo(int synthetic, ImmutableBasicLoggerMode another) {
        return this.schemaFieldDescriptions.equals(another.schemaFieldDescriptions) && this.outputRowStruct.equals((Object)another.outputRowStruct) && this.schemaFieldDescriptionsMap.equals(another.schemaFieldDescriptionsMap) && this.componentName.equals(another.componentName) && this.useLocalTimeZone == another.useLocalTimeZone && this.fieldSeparator.equals(another.fieldSeparator) && this.printHeader == another.printHeader && this.printComponentUniqueName == another.printComponentUniqueName && this.printSchemaColumnName == another.printSchemaColumnName && this.useFixedLengthForValues == another.useFixedLengthForValues && this.fixedLengthValuesMap.equals(another.fixedLengthValuesMap);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.schemaFieldDescriptions.hashCode();
        h += (h << 5) + this.outputRowStruct.hashCode();
        h += (h << 5) + this.schemaFieldDescriptionsMap.hashCode();
        h += (h << 5) + this.componentName.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.useLocalTimeZone);
        h += (h << 5) + this.fieldSeparator.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.printHeader);
        h += (h << 5) + Booleans.hashCode((boolean)this.printComponentUniqueName);
        h += (h << 5) + Booleans.hashCode((boolean)this.printSchemaColumnName);
        h += (h << 5) + Booleans.hashCode((boolean)this.useFixedLengthForValues);
        h += (h << 5) + this.fixedLengthValuesMap.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BasicLoggerMode").omitNullValues().add("schemaFieldDescriptions", this.schemaFieldDescriptions).add("outputRowStruct", (Object)this.outputRowStruct).add("schemaFieldDescriptionsMap", this.schemaFieldDescriptionsMap).add("componentName", (Object)this.componentName).add("useLocalTimeZone", this.useLocalTimeZone).add("fieldSeparator", (Object)this.fieldSeparator).add("printHeader", this.printHeader).add("printComponentUniqueName", this.printComponentUniqueName).add("printSchemaColumnName", this.printSchemaColumnName).add("useFixedLengthForValues", this.useFixedLengthForValues).add("fixedLengthValuesMap", this.fixedLengthValuesMap).toString();
    }

    public static ImmutableBasicLoggerMode copyOf(BasicLoggerMode instance) {
        if (instance instanceof ImmutableBasicLoggerMode) {
            return (ImmutableBasicLoggerMode)instance;
        }
        return ImmutableBasicLoggerMode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BasicLoggerMode", generator="Immutables")
    private final class InitShim {
        private byte outputRowStructBuildStage = 0;
        private StructType outputRowStruct;
        private byte schemaFieldDescriptionsMapBuildStage = 0;
        private Map<String, Component.SchemaFieldDescription> schemaFieldDescriptionsMap;
        private byte componentNameBuildStage = 0;
        private String componentName;
        private byte useLocalTimeZoneBuildStage = 0;
        private boolean useLocalTimeZone;
        private byte fieldSeparatorBuildStage = 0;
        private String fieldSeparator;
        private byte printHeaderBuildStage = 0;
        private boolean printHeader;
        private byte printComponentUniqueNameBuildStage = 0;
        private boolean printComponentUniqueName;
        private byte printSchemaColumnNameBuildStage = 0;
        private boolean printSchemaColumnName;
        private byte useFixedLengthForValuesBuildStage = 0;
        private boolean useFixedLengthForValues;
        private byte fixedLengthValuesMapBuildStage = 0;
        private ImmutableMap<String, Integer> fixedLengthValuesMap;

        private InitShim() {
        }

        StructType getOutputRowStruct() {
            if (this.outputRowStructBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outputRowStructBuildStage == 0) {
                this.outputRowStructBuildStage = (byte)-1;
                this.outputRowStruct = Objects.requireNonNull(ImmutableBasicLoggerMode.super.getOutputRowStruct(), "outputRowStruct");
                this.outputRowStructBuildStage = 1;
            }
            return this.outputRowStruct;
        }

        Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMap() {
            if (this.schemaFieldDescriptionsMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.schemaFieldDescriptionsMapBuildStage == 0) {
                this.schemaFieldDescriptionsMapBuildStage = (byte)-1;
                this.schemaFieldDescriptionsMap = Objects.requireNonNull(ImmutableBasicLoggerMode.super.getSchemaFieldDescriptionsMap(), "schemaFieldDescriptionsMap");
                this.schemaFieldDescriptionsMapBuildStage = 1;
            }
            return this.schemaFieldDescriptionsMap;
        }

        String componentName() {
            if (this.componentNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.componentNameBuildStage == 0) {
                this.componentNameBuildStage = (byte)-1;
                this.componentName = Objects.requireNonNull(ImmutableBasicLoggerMode.super.componentName(), "componentName");
                this.componentNameBuildStage = 1;
            }
            return this.componentName;
        }

        void componentName(String componentName) {
            this.componentName = componentName;
            this.componentNameBuildStage = 1;
        }

        boolean useLocalTimeZone() {
            if (this.useLocalTimeZoneBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useLocalTimeZoneBuildStage == 0) {
                this.useLocalTimeZoneBuildStage = (byte)-1;
                this.useLocalTimeZone = ImmutableBasicLoggerMode.super.useLocalTimeZone();
                this.useLocalTimeZoneBuildStage = 1;
            }
            return this.useLocalTimeZone;
        }

        void useLocalTimeZone(boolean useLocalTimeZone) {
            this.useLocalTimeZone = useLocalTimeZone;
            this.useLocalTimeZoneBuildStage = 1;
        }

        String fieldSeparator() {
            if (this.fieldSeparatorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fieldSeparatorBuildStage == 0) {
                this.fieldSeparatorBuildStage = (byte)-1;
                this.fieldSeparator = Objects.requireNonNull(ImmutableBasicLoggerMode.super.fieldSeparator(), "fieldSeparator");
                this.fieldSeparatorBuildStage = 1;
            }
            return this.fieldSeparator;
        }

        void fieldSeparator(String fieldSeparator) {
            this.fieldSeparator = fieldSeparator;
            this.fieldSeparatorBuildStage = 1;
        }

        boolean printHeader() {
            if (this.printHeaderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.printHeaderBuildStage == 0) {
                this.printHeaderBuildStage = (byte)-1;
                this.printHeader = ImmutableBasicLoggerMode.super.printHeader();
                this.printHeaderBuildStage = 1;
            }
            return this.printHeader;
        }

        void printHeader(boolean printHeader) {
            this.printHeader = printHeader;
            this.printHeaderBuildStage = 1;
        }

        boolean printComponentUniqueName() {
            if (this.printComponentUniqueNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.printComponentUniqueNameBuildStage == 0) {
                this.printComponentUniqueNameBuildStage = (byte)-1;
                this.printComponentUniqueName = ImmutableBasicLoggerMode.super.printComponentUniqueName();
                this.printComponentUniqueNameBuildStage = 1;
            }
            return this.printComponentUniqueName;
        }

        void printComponentUniqueName(boolean printComponentUniqueName) {
            this.printComponentUniqueName = printComponentUniqueName;
            this.printComponentUniqueNameBuildStage = 1;
        }

        boolean printSchemaColumnName() {
            if (this.printSchemaColumnNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.printSchemaColumnNameBuildStage == 0) {
                this.printSchemaColumnNameBuildStage = (byte)-1;
                this.printSchemaColumnName = ImmutableBasicLoggerMode.super.printSchemaColumnName();
                this.printSchemaColumnNameBuildStage = 1;
            }
            return this.printSchemaColumnName;
        }

        void printSchemaColumnName(boolean printSchemaColumnName) {
            this.printSchemaColumnName = printSchemaColumnName;
            this.printSchemaColumnNameBuildStage = 1;
        }

        boolean useFixedLengthForValues() {
            if (this.useFixedLengthForValuesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useFixedLengthForValuesBuildStage == 0) {
                this.useFixedLengthForValuesBuildStage = (byte)-1;
                this.useFixedLengthForValues = ImmutableBasicLoggerMode.super.useFixedLengthForValues();
                this.useFixedLengthForValuesBuildStage = 1;
            }
            return this.useFixedLengthForValues;
        }

        void useFixedLengthForValues(boolean useFixedLengthForValues) {
            this.useFixedLengthForValues = useFixedLengthForValues;
            this.useFixedLengthForValuesBuildStage = 1;
        }

        ImmutableMap<String, Integer> fixedLengthValuesMap() {
            if (this.fixedLengthValuesMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fixedLengthValuesMapBuildStage == 0) {
                this.fixedLengthValuesMapBuildStage = (byte)-1;
                this.fixedLengthValuesMap = ImmutableMap.copyOf((Map)ImmutableBasicLoggerMode.super.fixedLengthValuesMap());
                this.fixedLengthValuesMapBuildStage = 1;
            }
            return this.fixedLengthValuesMap;
        }

        void fixedLengthValuesMap(ImmutableMap<String, Integer> fixedLengthValuesMap) {
            this.fixedLengthValuesMap = fixedLengthValuesMap;
            this.fixedLengthValuesMapBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.outputRowStructBuildStage == -1) {
                attributes.add("outputRowStruct");
            }
            if (this.schemaFieldDescriptionsMapBuildStage == -1) {
                attributes.add("schemaFieldDescriptionsMap");
            }
            if (this.componentNameBuildStage == -1) {
                attributes.add("componentName");
            }
            if (this.useLocalTimeZoneBuildStage == -1) {
                attributes.add("useLocalTimeZone");
            }
            if (this.fieldSeparatorBuildStage == -1) {
                attributes.add("fieldSeparator");
            }
            if (this.printHeaderBuildStage == -1) {
                attributes.add("printHeader");
            }
            if (this.printComponentUniqueNameBuildStage == -1) {
                attributes.add("printComponentUniqueName");
            }
            if (this.printSchemaColumnNameBuildStage == -1) {
                attributes.add("printSchemaColumnName");
            }
            if (this.useFixedLengthForValuesBuildStage == -1) {
                attributes.add("useFixedLengthForValues");
            }
            if (this.fixedLengthValuesMapBuildStage == -1) {
                attributes.add("fixedLengthValuesMap");
            }
            return "Cannot build BasicLoggerMode, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="BasicLoggerMode", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_USE_LOCAL_TIME_ZONE = 1L;
        private static final long OPT_BIT_PRINT_HEADER = 2L;
        private static final long OPT_BIT_PRINT_COMPONENT_UNIQUE_NAME = 4L;
        private static final long OPT_BIT_PRINT_SCHEMA_COLUMN_NAME = 8L;
        private static final long OPT_BIT_USE_FIXED_LENGTH_FOR_VALUES = 16L;
        private static final long OPT_BIT_FIXED_LENGTH_VALUES_MAP = 32L;
        private long optBits;
        private ImmutableList.Builder<Component.SchemaFieldDescription> schemaFieldDescriptions = ImmutableList.builder();
        @Nullable
        private String componentName;
        private boolean useLocalTimeZone;
        @Nullable
        private String fieldSeparator;
        private boolean printHeader;
        private boolean printComponentUniqueName;
        private boolean printSchemaColumnName;
        private boolean useFixedLengthForValues;
        private ImmutableMap.Builder<String, Integer> fixedLengthValuesMap = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Component.WithSchemaDescription instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(WithLoggerMode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(BasicLoggerMode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Component.WithSchemaDescription instance;
            long bits = 0L;
            if (object instanceof Component.WithSchemaDescription) {
                instance = (Component.WithSchemaDescription)object;
                if ((bits & 4L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 4L;
                }
            }
            if (object instanceof WithLoggerMode) {
                instance = (WithLoggerMode)object;
                if ((bits & 4L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.useLocalTimeZone(instance.useLocalTimeZone());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.componentName(instance.componentName());
                    bits |= 2L;
                }
            }
            if (object instanceof BasicLoggerMode) {
                instance = (BasicLoggerMode)object;
                this.fieldSeparator(instance.fieldSeparator());
                this.printHeader(instance.printHeader());
                if ((bits & 1L) == 0L) {
                    this.useLocalTimeZone(instance.useLocalTimeZone());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.componentName(instance.componentName());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 4L;
                }
                this.putAllFixedLengthValuesMap(instance.fixedLengthValuesMap());
                this.printSchemaColumnName(instance.printSchemaColumnName());
                this.useFixedLengthForValues(instance.useFixedLengthForValues());
                this.printComponentUniqueName(instance.printComponentUniqueName());
            }
        }

        @CanIgnoreReturnValue
        public final Builder addSchemaFieldDescriptions(Component.SchemaFieldDescription element) {
            this.schemaFieldDescriptions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSchemaFieldDescriptions(Component.SchemaFieldDescription ... elements) {
            this.schemaFieldDescriptions.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
            this.schemaFieldDescriptions = ImmutableList.builder();
            return this.addAllSchemaFieldDescriptions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSchemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
            this.schemaFieldDescriptions.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder componentName(String componentName) {
            this.componentName = Objects.requireNonNull(componentName, "componentName");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder useLocalTimeZone(boolean useLocalTimeZone) {
            this.useLocalTimeZone = useLocalTimeZone;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fieldSeparator(String fieldSeparator) {
            this.fieldSeparator = Objects.requireNonNull(fieldSeparator, "fieldSeparator");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder printHeader(boolean printHeader) {
            this.printHeader = printHeader;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder printComponentUniqueName(boolean printComponentUniqueName) {
            this.printComponentUniqueName = printComponentUniqueName;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder printSchemaColumnName(boolean printSchemaColumnName) {
            this.printSchemaColumnName = printSchemaColumnName;
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder useFixedLengthForValues(boolean useFixedLengthForValues) {
            this.useFixedLengthForValues = useFixedLengthForValues;
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putFixedLengthValuesMap(String key, int value) {
            this.fixedLengthValuesMap.put((Object)key, (Object)value);
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putFixedLengthValuesMap(Map.Entry<String, ? extends Integer> entry) {
            this.fixedLengthValuesMap.put(entry);
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fixedLengthValuesMap(Map<String, ? extends Integer> entries) {
            this.fixedLengthValuesMap = ImmutableMap.builder();
            this.optBits |= 0x20L;
            return this.putAllFixedLengthValuesMap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllFixedLengthValuesMap(Map<String, ? extends Integer> entries) {
            this.fixedLengthValuesMap.putAll(entries);
            this.optBits |= 0x20L;
            return this;
        }

        public ImmutableBasicLoggerMode build() {
            return new ImmutableBasicLoggerMode(this);
        }

        private boolean useLocalTimeZoneIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean printHeaderIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean printComponentUniqueNameIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean printSchemaColumnNameIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean useFixedLengthForValuesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean fixedLengthValuesMapIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }
    }
}

