/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.misc.tlogrow.mode;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.spark.sql.types.StructType;
import org.immutables.value.Generated;
import org.talend.bigdata.common.Component;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.mode.TableLoggerMode;
import org.talend.bigdata.structuredstreaming.misc.tlogrow.mode.WithLoggerMode;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TableLoggerMode", generator="Immutables")
@Immutable
public final class ImmutableTableLoggerMode
extends TableLoggerMode {
    private final ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions;
    private final StructType outputRowStruct;
    private final Map<String, Component.SchemaFieldDescription> schemaFieldDescriptionsMap;
    private final String componentName;
    private final boolean useLocalTimeZone;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTableLoggerMode(Builder builder) {
        this.schemaFieldDescriptions = builder.schemaFieldDescriptions.build();
        if (builder.componentName != null) {
            this.initShim.componentName(builder.componentName);
        }
        if (builder.useLocalTimeZoneIsSet()) {
            this.initShim.useLocalTimeZone(builder.useLocalTimeZone);
        }
        this.outputRowStruct = this.initShim.getOutputRowStruct();
        this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
        this.componentName = this.initShim.componentName();
        this.useLocalTimeZone = this.initShim.useLocalTimeZone();
        this.initShim = null;
    }

    private ImmutableTableLoggerMode(ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions, String componentName, boolean useLocalTimeZone) {
        this.schemaFieldDescriptions = schemaFieldDescriptions;
        this.initShim.componentName(componentName);
        this.initShim.useLocalTimeZone(useLocalTimeZone);
        this.outputRowStruct = this.initShim.getOutputRowStruct();
        this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
        this.componentName = this.initShim.componentName();
        this.useLocalTimeZone = this.initShim.useLocalTimeZone();
        this.initShim = null;
    }

    public ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions() {
        return this.schemaFieldDescriptions;
    }

    public StructType getOutputRowStruct() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOutputRowStruct() : this.outputRowStruct;
    }

    public Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSchemaFieldDescriptionsMap() : this.schemaFieldDescriptionsMap;
    }

    @Override
    public String componentName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.componentName() : this.componentName;
    }

    @Override
    public boolean useLocalTimeZone() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useLocalTimeZone() : this.useLocalTimeZone;
    }

    public final ImmutableTableLoggerMode withSchemaFieldDescriptions(Component.SchemaFieldDescription ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTableLoggerMode((ImmutableList<Component.SchemaFieldDescription>)newValue, this.componentName, this.useLocalTimeZone);
    }

    public final ImmutableTableLoggerMode withSchemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
        if (this.schemaFieldDescriptions == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTableLoggerMode((ImmutableList<Component.SchemaFieldDescription>)newValue, this.componentName, this.useLocalTimeZone);
    }

    public final ImmutableTableLoggerMode withComponentName(String value) {
        String newValue = Objects.requireNonNull(value, "componentName");
        if (this.componentName.equals(newValue)) {
            return this;
        }
        return new ImmutableTableLoggerMode(this.schemaFieldDescriptions, newValue, this.useLocalTimeZone);
    }

    public final ImmutableTableLoggerMode withUseLocalTimeZone(boolean value) {
        if (this.useLocalTimeZone == value) {
            return this;
        }
        return new ImmutableTableLoggerMode(this.schemaFieldDescriptions, this.componentName, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTableLoggerMode && this.equalTo(0, (ImmutableTableLoggerMode)another);
    }

    private boolean equalTo(int synthetic, ImmutableTableLoggerMode another) {
        return this.schemaFieldDescriptions.equals(another.schemaFieldDescriptions) && this.outputRowStruct.equals((Object)another.outputRowStruct) && this.schemaFieldDescriptionsMap.equals(another.schemaFieldDescriptionsMap) && this.componentName.equals(another.componentName) && this.useLocalTimeZone == another.useLocalTimeZone;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.schemaFieldDescriptions.hashCode();
        h += (h << 5) + this.outputRowStruct.hashCode();
        h += (h << 5) + this.schemaFieldDescriptionsMap.hashCode();
        h += (h << 5) + this.componentName.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.useLocalTimeZone);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TableLoggerMode").omitNullValues().add("schemaFieldDescriptions", this.schemaFieldDescriptions).add("outputRowStruct", (Object)this.outputRowStruct).add("schemaFieldDescriptionsMap", this.schemaFieldDescriptionsMap).add("componentName", (Object)this.componentName).add("useLocalTimeZone", this.useLocalTimeZone).toString();
    }

    public static ImmutableTableLoggerMode copyOf(TableLoggerMode instance) {
        if (instance instanceof ImmutableTableLoggerMode) {
            return (ImmutableTableLoggerMode)instance;
        }
        return ImmutableTableLoggerMode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TableLoggerMode", generator="Immutables")
    private final class InitShim {
        private byte outputRowStructBuildStage = 0;
        private StructType outputRowStruct;
        private byte schemaFieldDescriptionsMapBuildStage = 0;
        private Map<String, Component.SchemaFieldDescription> schemaFieldDescriptionsMap;
        private byte componentNameBuildStage = 0;
        private String componentName;
        private byte useLocalTimeZoneBuildStage = 0;
        private boolean useLocalTimeZone;

        private InitShim() {
        }

        StructType getOutputRowStruct() {
            if (this.outputRowStructBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outputRowStructBuildStage == 0) {
                this.outputRowStructBuildStage = (byte)-1;
                this.outputRowStruct = Objects.requireNonNull(ImmutableTableLoggerMode.super.getOutputRowStruct(), "outputRowStruct");
                this.outputRowStructBuildStage = 1;
            }
            return this.outputRowStruct;
        }

        Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMap() {
            if (this.schemaFieldDescriptionsMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.schemaFieldDescriptionsMapBuildStage == 0) {
                this.schemaFieldDescriptionsMapBuildStage = (byte)-1;
                this.schemaFieldDescriptionsMap = Objects.requireNonNull(ImmutableTableLoggerMode.super.getSchemaFieldDescriptionsMap(), "schemaFieldDescriptionsMap");
                this.schemaFieldDescriptionsMapBuildStage = 1;
            }
            return this.schemaFieldDescriptionsMap;
        }

        String componentName() {
            if (this.componentNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.componentNameBuildStage == 0) {
                this.componentNameBuildStage = (byte)-1;
                this.componentName = Objects.requireNonNull(ImmutableTableLoggerMode.super.componentName(), "componentName");
                this.componentNameBuildStage = 1;
            }
            return this.componentName;
        }

        void componentName(String componentName) {
            this.componentName = componentName;
            this.componentNameBuildStage = 1;
        }

        boolean useLocalTimeZone() {
            if (this.useLocalTimeZoneBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useLocalTimeZoneBuildStage == 0) {
                this.useLocalTimeZoneBuildStage = (byte)-1;
                this.useLocalTimeZone = ImmutableTableLoggerMode.super.useLocalTimeZone();
                this.useLocalTimeZoneBuildStage = 1;
            }
            return this.useLocalTimeZone;
        }

        void useLocalTimeZone(boolean useLocalTimeZone) {
            this.useLocalTimeZone = useLocalTimeZone;
            this.useLocalTimeZoneBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.outputRowStructBuildStage == -1) {
                attributes.add("outputRowStruct");
            }
            if (this.schemaFieldDescriptionsMapBuildStage == -1) {
                attributes.add("schemaFieldDescriptionsMap");
            }
            if (this.componentNameBuildStage == -1) {
                attributes.add("componentName");
            }
            if (this.useLocalTimeZoneBuildStage == -1) {
                attributes.add("useLocalTimeZone");
            }
            return "Cannot build TableLoggerMode, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="TableLoggerMode", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_USE_LOCAL_TIME_ZONE = 1L;
        private long optBits;
        private ImmutableList.Builder<Component.SchemaFieldDescription> schemaFieldDescriptions = ImmutableList.builder();
        @Nullable
        private String componentName;
        private boolean useLocalTimeZone;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TableLoggerMode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Component.WithSchemaDescription instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(WithLoggerMode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            WithLoggerMode instance;
            long bits = 0L;
            if (object instanceof TableLoggerMode) {
                instance = (TableLoggerMode)object;
                if ((bits & 4L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.useLocalTimeZone(instance.useLocalTimeZone());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.componentName(instance.componentName());
                    bits |= 2L;
                }
            }
            if (object instanceof Component.WithSchemaDescription) {
                instance = (Component.WithSchemaDescription)object;
                if ((bits & 4L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 4L;
                }
            }
            if (object instanceof WithLoggerMode) {
                instance = (WithLoggerMode)object;
                if ((bits & 4L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.useLocalTimeZone(instance.useLocalTimeZone());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.componentName(instance.componentName());
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder addSchemaFieldDescriptions(Component.SchemaFieldDescription element) {
            this.schemaFieldDescriptions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSchemaFieldDescriptions(Component.SchemaFieldDescription ... elements) {
            this.schemaFieldDescriptions.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
            this.schemaFieldDescriptions = ImmutableList.builder();
            return this.addAllSchemaFieldDescriptions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSchemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
            this.schemaFieldDescriptions.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder componentName(String componentName) {
            this.componentName = Objects.requireNonNull(componentName, "componentName");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder useLocalTimeZone(boolean useLocalTimeZone) {
            this.useLocalTimeZone = useLocalTimeZone;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableTableLoggerMode build() {
            return new ImmutableTableLoggerMode(this);
        }

        private boolean useLocalTimeZoneIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

